#!/bin/bash
#set -x

## NOTE: Changes made to this file will be overwritten with updates. To make
## permanent environment changes for tomcat, use setenvpersist.sh instead.
## That file is created at install time and will not be overwritten with updates.

CATALINA_PID="$CATALINA_BASE/bin/catalina.pid"

# Use base script to get log path from registry:
. "../../Base/cvToolsBase.sh"
log_path=$(getLogFilesFolder)/Web
echo "tomcat log_path: ${log_path}"

# Create log path if needed:
if [[ ! -d "$log_path" ]]; then
        echo "Creating tomcat log path: $log_path"
        mkdir "$log_path"
fi

# Set JRE_HOME to use cvjre:
JRE_HOME=$(getGalaxyHome)/jre
echo "JRE_HOME: ${JRE_HOME}"

# Set preload to prevent crash related to signal handler conflict between libCvLib.so and the jre:
LD_PRELOAD=${JRE_HOME}/lib/libjsig.so
echo "LD_PRELOAD: ${LD_PRELOAD}"
export LD_PRELOAD

# Set library path for JNI:
CATALINA_OPTS="$CATALINA_OPTS -Djava.library.path=$(readlink -m ../../Base)"

# Make tomcat use UTF-8 encoding instead of OS's default encoding.
CATALINA_OPTS="$CATALINA_OPTS -Dfile.encoding=UTF8"

# Add log path to options used by catalina.sh:
CATALINA_OPTS="$CATALINA_OPTS -Dcatalina.logpath=$log_path"
echo "CATALINA_OPTS: $CATALINA_OPTS"

# CATALINA_OUT is set to /dev/null here to prevents catalina.out from growing
# out of control on production systems. To log stdout/stderr logging to
# catalina.out temporarily, swap the commenting on the two lines below.
# To restore it permanently, set CATALINA_OUT in setenvpersist.sh, which
# overrides settings here and does not get overwritten when updates are
# installed.
CATALINA_OUT=/dev/null
#CATALINA_OUT="$log_path/catalina.out"

echo "CATALINA_OUT: $CATALINA_OUT"

# Execute persistent script--changes to setenvpersist.sh will not be
# overwritten by product updates, whereas setenv.sh will be:
if [[ -f "./setenvpersist.sh" ]]; then
        . "./setenvpersist.sh"
fi
