@echo off
rem Licensed to the Apache Software Foundation (ASF) under one or more
rem contributor license agreements.  See the NOTICE file distributed with
rem this work for additional information regarding copyright ownership.
rem The ASF licenses this file to You under the Apache License, Version 2.0
rem (the "License"); you may not use this file except in compliance with
rem the License.  You may obtain a copy of the License at
rem
rem     http://www.apache.org/licenses/LICENSE-2.0
rem
rem Unless required by applicable law or agreed to in writing, software
rem distributed under the License is distributed on an "AS IS" BASIS,
rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
rem See the License for the specific language governing permissions and
rem limitations under the License.

rem ---------------------------------------------------------------------------
rem NT Service Install/Uninstall script
rem
rem Options
rem install                Install the service using Tomcat8 as service name.
rem                        Service is installed using default settings.
rem remove                 Remove the service from the System.
rem
rem name        (optional) If the second argument is present it is considered
rem                        to be new service name
rem ---------------------------------------------------------------------------

setlocal

set "SELF=%~dp0%service.bat"
rem Guess CATALINA_HOME if not defined
set "CURRENT_DIR=%cd%"
if not "%CATALINA_HOME%" == "" goto gotHome
set "CATALINA_HOME=%cd%"
if exist "%CATALINA_HOME%\bin\tomcat.exe" goto okHome
rem CD to the upper dir
cd ..
set "CATALINA_HOME=%cd%"
:gotHome
if exist "%CATALINA_HOME%\bin\tomcat.exe" goto okHome
echo The tomcat.exe was not found...
echo The CATALINA_HOME environment variable is not defined correctly.
echo This environment variable is needed to run this program
goto failend
:okHome
rem Make sure prerequisite environment variables are set

rem Use cvjre (currently java 11)
set "CVJRE_HOME=%CATALINA_HOME%\..\jre"
rem !!! the JAVA10 var will need to be set to true here (or removed from the script entirely) once cvjre moves to java 10
set JAVA10=true
echo Using standard CVJRE_HOME for Apache install
echo CVJRE_HOME: %CVJRE_HOME%
set JAVA_HOME=%CVJRE_HOME%
set JRE_HOME=%CVJRE_HOME%

if not "%JAVA_HOME%" == "" goto gotJdkHome
if not "%JRE_HOME%" == "" goto gotJreHome
echo Neither the JAVA_HOME nor the JRE_HOME environment variable is defined
echo Service will try to guess them from the registry.
goto okJavaHome
:gotJreHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
if not exist "%JAVA_HOME%\bin\javaw.exe" goto noJavaHome
if not "%JRE_HOME%" == "" goto okJavaHome
set "JRE_HOME=%JAVA_HOME%\jre"
goto okJavaHome
:gotJdkHome
if not exist "%JAVA_HOME%\jre\bin\java.exe" goto gotJreHome
if not exist "%JAVA_HOME%\jre\bin\javaw.exe" goto gotJreHome
if not exist "%JAVA_HOME%\bin\javac.exe" goto gotJreHome
if not "%JRE_HOME%" == "" goto okJavaHome
set "JRE_HOME=%JAVA_HOME%\jre"
goto okJavaHome
:noJavaHome
echo The JAVA_HOME environment variable is not defined correctly
echo This environment variable is needed to run this program
echo NB: JAVA_HOME should point to a JDK not a JRE
goto failend
:okJavaHome
if not "%CATALINA_BASE%" == "" goto gotBase
set "CATALINA_BASE=%CATALINA_HOME%"
:gotBase

set "EXECUTABLE=%CATALINA_HOME%\bin\tomcat.exe"
set "WIN_EXECUTABLE=%CATALINA_HOME%\bin\tomcatw.exe"

rem Set default Service name
set "SERVICE_NAME=Tomcat8"
set "PR_DISPLAYNAME=Apache Tomcat 8"
set "OEM_DISPLAYNAME=CommVault"

if '%1' == '' goto displayUsage
if '%2' == '' goto displayUsage

set INSTANCE=%2
set OEM_DISPLAYNAME=%~3

set "SERVICE_NAME=GxTomcat%INSTANCE%"
set "PR_DISPLAYNAME=%OEM_DISPLAYNAME% Tomcat Service (%INSTANCE%)"

:setServiceName
if %1 == install goto doInstall
if %1 == remove goto doRemove
if %1 == uninstall goto doRemove
if %1 == edit goto doEdit
if %1 == update goto doUpdate
echo Unknown parameter "%1"
:displayUsage
echo.
echo "Usage: %0 <install/remove/uninstall/edit/update> <Commvault Instance> [OEMName(only for install)]"
goto end

:doRemove
rem Remove the service
"%EXECUTABLE%" //DS//%SERVICE_NAME%
if not errorlevel 1 goto removed
echo.
echo Failed uninstalling '%SERVICE_NAME%' service
goto failend
:removed
echo The service '%SERVICE_NAME%' has been removed
goto end

:doEdit
rem Edit the service
"%WIN_EXECUTABLE%" //ES//%SERVICE_NAME%
if not errorlevel 1 goto edited
echo.
echo Failed to edit '%SERVICE_NAME%' service
goto failend
:edited
echo.
echo The service '%SERVICE_NAME%' has been saved
goto end

:doInstall
rem Install the service
echo Installing the service '%SERVICE_NAME%' ...
echo Using CATALINA_HOME:    "%CATALINA_HOME%"
echo Using CATALINA_BASE:    "%CATALINA_BASE%"
echo Using JAVA_HOME:        "%JAVA_HOME%"

rem Use the environment variables as an example
rem Each command line option is prefixed with PR_
set PR_JVM_MIN_MEM_MB=128
set PR_JVM_MAX_MEM_MB=2048
set PR_DESCRIPTION=Apache Tomcat 8.5.31 Server
set "PR_INSTALL=%EXECUTABLE%"
set "PR_LOGPATH=%CATALINA_HOME%/../Log Files/Web"
set "PR_LOGFILE=Tomcat.log"
REM set PR_STDOUTPUT=auto
REM set PR_STDERROR=auto
set "PR_CLASSPATH=%CATALINA_BASE%\bin\tomcat-juli.jar;%CATALINA_HOME%\bin\tomcat-juli.jar;%CATALINA_HOME%\bin\bootstrap.jar"

rem Use cvjre if present
set "PR_JVM=%CVJRE_HOME%\bin\server\jvm.dll"
if exist "%PR_JVM%" goto foundJvm
rem Set the server jvm from JAVA_HOME
set "PR_JVM=%JAVA_HOME%\jre\bin\server\jvm.dll"
if exist "%PR_JVM%" goto foundJvm
rem Set the client jvm from JAVA_HOME
set "PR_JVM=%JAVA_HOME%\jre\bin\client\jvm.dll"
if exist "%PR_JVM%" goto foundJvm
set PR_JVM=auto
:foundJvm
echo Using JVM:              "%PR_JVM%"

"%EXECUTABLE%" //IS//%SERVICE_NAME% --StartClass org.apache.catalina.startup.Bootstrap --StopClass org.apache.catalina.startup.Bootstrap --StartParams start --StopParams stop
if not errorlevel 1 goto installed
echo.
echo Failed installing '%SERVICE_NAME%' service
goto failend

:installed
rem run service as Network Service
sc.exe config %SERVICE_NAME% obj= "NT Authority\NetworkService"
echo The service '%SERVICE_NAME%' has been installed.
rem Clear the environment variables. They are not needed any more.
set PR_DISPLAYNAME=
set PR_DESCRIPTION=
set PR_INSTALL=
set PR_CLASSPATH=
set PR_JVM=
rem Create Temp directory if tomcat service is properly installed.
echo Creating Temp Folder %CATALINA_HOME%\temp
mkdir "%CATALINA_HOME%\temp"

REM Update Tomcat with JVM Memory only at Install
"%EXECUTABLE%" //US//%SERVICE_NAME% --JvmMs=%PR_JVM_MIN_MEM_MB% --JvmMx=%PR_JVM_MAX_MEM_MB%

:doUpdate
SET GX_BASE_DIR=%CATALINA_HOME%\..\Base
set "PR_LOGPATH=%CATALINA_HOME%/../Log Files/Web"
set "PR_LOGFILE=Tomcat.log"
set PR_DISPLAYNAME=

rem Set extra parameters
SET CATALINA_OPTIONS=-Dcatalina.base=%CATALINA_BASE%;-Dcatalina.home=%CATALINA_HOME%;
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Dcatalina.logpath=%PR_LOGPATH%;
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Dcatalina.logfile=%PR_LOGFILE%;
if not "%JAVA10%" == "true" (
	echo Using endorsed dirs setting: %CATALINA_HOME%\endorsed
	SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Djava.endorsed.dirs=%CATALINA_HOME%\endorsed;
)
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Djava.io.tmpdir=%CATALINA_BASE%\temp;
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager;
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Djava.util.logging.config.file=%CATALINA_BASE%\conf\logging.properties;
REM make weld use Tomcat logging
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Dorg.jboss.logging.provider=jdk;
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Djdk.tls.ephemeralDHKeySize=2048;
REM Make tomcat use UTF-8 encoding instead of OS's default encoding.
SET CATALINA_OPTIONS=%CATALINA_OPTIONS%-Dfile.encoding=UTF8;

SET JMX_PORT=8888
SET CATALINA_REMOTE=-Dcom.sun.management.jmxremote;
SET CATALINA_REMOTE=%CATALINA_REMOTE%-Dcom.sun.management.jmxremote.port=%JMX_PORT%;
SET CATALINA_REMOTE=%CATALINA_REMOTE%-Dcom.sun.management.jmxremote.ssl=false;
SET CATALINA_REMOTE=%CATALINA_REMOTE%-Dcom.sun.management.jmxremote.authenticate=false

set JPDA_ADDRESS=8000
set JPDA_OPTIONS=-agentlib:jdwp=transport=dt_socket,address=%JPDA_ADDRESS%,server=y,suspend=n

set DESCRIPTION=Apache Tomcat
set VERSION=

REM Use CVJRE if present:
set "CVJVMLIB=%CVJRE_HOME%\bin\server\jvm.dll"
if exist %CVJVMLIB% (
	set "PR_JVM=%CVJVMLIB%"
	echo Using CVJRE JVM library: "%PR_JVM%"
)

REM Update Tomcat with JVM Options
"%EXECUTABLE%" //US//%SERVICE_NAME% --Startup=auto --StartMode=jvm --StopMode=jvm --JvmOptions "%CATALINA_OPTIONS%"

REM Update Tomcat with JVM Perm Size Memory
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:PermSize=64m
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:MaxPermSize=256m

REM Update Tomcat with JMX
REM "%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions="%CATALINA_REMOTE%"

REM Update Tomcat with Debug options
REM "%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions="%JPDA_OPTIONS%"

if not "%JAVA10%" == "true" (
	REM Update Tomcat with GC log options
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-Xloggc:"%PR_LOGPATH%/gc.log"
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+PrintGCDateStamps
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+PrintGCDetails
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+PrintGCCause
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+PrintTenuringDistribution
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+PrintGCApplicationStoppedTime
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+UseGCLogFileRotation
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:NumberOfGCLogFiles=5
	"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:GCLogFileSize=10M
)

REM Update Tomcat with heap dump options
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:+HeapDumpOnOutOfMemoryError
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions=-XX:HeapDumpPath="%PR_LOGPATH%"

echo Configuring start-up parameters for java 9+
"%EXECUTABLE%" //US//%SERVICE_NAME% --JvmOptions9=--add-opens=java.base/java.lang=ALL-UNNAMED
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions9=--add-opens=java.base/java.io=ALL-UNNAMED
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions9=--add-opens=java.rmi/sun.rmi.transport=ALL-UNNAMED
"%EXECUTABLE%" //US//%SERVICE_NAME% ++JvmOptions9=--illegal-access=permit

pushd "%CATALINA_HOME%/lib"

set "JRE_EXE=%CVJRE_HOME%\bin\java.exe"
if not exist "%JRE_EXE%" (
	set JAVA_EXE="%JAVA_HOME%\bin\java.exe"
	echo WARNING: CVJRE java executable not found; using JAVA_HOME
)
"%JRE_EXE%" -cp catalina.jar org.apache.catalina.util.ServerInfo > ApacheTomcatVersion.txt
for /f "tokens=3" %%a in ('find "Server number:" ApacheTomcatVersion.txt') do set VERSION=%%a

echo Apache Tomcat Binary: %EXECUTABLE%
echo Apache Tomcat Version: %VERSION%
echo Service Name: %instance%
echo Service Description: %DESCRIPTION% %VERSION% Server

if NOT '%VERSION%' == '' (
	"%EXECUTABLE%" //US//%SERVICE_NAME% --Description="%DESCRIPTION% %VERSION% Server"
	if %ERRORLEVEL% EQU 0 (
		popd
		echo Tomcat Service Version updated, Exit Code: %ERRORLEVEL%.
	) else (
		popd
		echo Failed to update Tomcat Service Version, Exit Code: %ERRORLEVEL%.
	)
) else (
	popd
	echo Tomcat Service Version Not Updated!!
)

REM Update the path for loading DLLs
"%EXECUTABLE%" //US//%SERVICE_NAME% --LibraryPath="%GX_BASE_DIR%"
if %ERRORLEVEL% EQU 0 (
		popd
		echo Tomcat Service LibraryPath updated, Exit Code: %ERRORLEVEL%.
		goto end
	) else (
		popd
		echo Failed to update Tomcat Service LibraryPath, Exit Code: %ERRORLEVEL%.
		goto failend
	)

:end
set PR_LOGPATH=
set PR_LOGFILE=
set PR_STDOUTPUT=
set PR_STDERROR=
cd /d %CURRENT_DIR%
EXIT /B 0

:failend
set PR_LOGPATH=
set PR_LOGFILE=
set PR_STDOUTPUT=
set PR_STDERROR=
cd /d %CURRENT_DIR%
EXIT /B 1