/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import workflow.types.SimpleType;
import workflow.types.XML;

public class XMLQuery {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(XMLQuery.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object query(String string, String string2, SimpleType simpleType, boolean bl) throws EvFailureException {
        List list;
        Object object = null;
        WorkflowElement workflowElement = WorkflowElement.parse(string);
        try {
            list = workflowElement.select(string2);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + string2 + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (list != null && list.size() > 0) {
            if (bl) {
                object = new ArrayList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e == null) continue;
                    if (simpleType == SimpleType.XML) {
                        if (e instanceof XML) {
                            ((XML)e).setAttribute("class", XML.class.getName());
                            ((List)object).add(e);
                            continue;
                        }
                        logger.error("query result [" + e + "] of type [" + e.getClass() + "] cannot be cast as XML");
                        throw new EvFailureException(new EvMessageContainer("query result [%s] of type [%s] cannot be cast as XML", e, e.getClass()));
                    }
                    String string3 = XMLQuery.toString(e);
                    try {
                        ((List)object).add(WorkflowUtils.convert(string3, simpleType.getJavaClass()));
                    }
                    catch (Exception exception) {
                        logger.error("failed to convert xpath result [" + string3 + "] to type [" + simpleType.toString() + "]", exception);
                        throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                    }
                }
                return object;
            }
            if (simpleType == SimpleType.XML) {
                Object e = list.get(0);
                if (e instanceof XML) {
                    ((XML)e).setAttribute("class", XML.class.getName());
                    return e;
                }
                logger.error("query result [" + e + "] of type [" + e.getClass() + "] cannot be cast as XML");
                throw new EvFailureException(new EvMessageContainer("query result [%s] of type [%s] cannot be cast as XML", e, e.getClass()));
            }
            String string4 = XMLQuery.toString(list.get(0));
            try {
                return WorkflowUtils.convert(string4, simpleType.getJavaClass());
            }
            catch (Exception exception) {
                logger.error("failed to convert xpath result [" + string4 + "] to type [" + simpleType.toString() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        logger.info("did not find any results for xpath query [%s] from of xml [%s]", string2, string);
        return object;
    }

    private static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof XML) {
            return ((XML)object).getText();
        }
        if (object instanceof Element) {
            return ((Element)object).getText();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getValue();
        }
        return String.valueOf(object);
    }
}

