/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.schema.util.SchemaEncoder;
import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.common.xml.JDOMStreamReader;
import commvault.cte.common.xml.JDOMStreamWriter;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.CommCellToken;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ExecuteException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.APP_CommCellInfo_t;
import commvault.cte.workflow.dom.WorkflowAttribute;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.schema.SchemaManager;
import commvault.cte.workflow.utils.Base64Encoder;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.StreamGobbler;
import commvault.msgs.App.InputControlType;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.CvEntities.ClientGroupEntity;
import commvault.msgs.CvEntities.CommCellEntity;
import commvault.msgs.CvEntities.CredentialEntity;
import commvault.msgs.CvEntities.EntityFlags;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.ExternalGroupEntity;
import commvault.msgs.CvEntities.LibraryEntity;
import commvault.msgs.CvEntities.MediaAgentEntity;
import commvault.msgs.CvEntities.SchedulePolicyEntity;
import commvault.msgs.CvEntities.StoragePolicyEntity;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.UserGroupEntity;
import commvault.msgs.CvEntities.WorkflowEntity;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.FormProperties;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.SchemaWrapper;
import commvault.qnet.sys.CVPassword;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.json.JSONObject;
import org.json.XML;
import workflow.types.SQLParameter;
import workflow.types.SQLType;
import workflow.types.Time;

public class WorkflowUtils {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowUtils.class);

    public static int getNow() {
        return Long.valueOf(WorkflowUtils.getUnixTime(new Date())).intValue();
    }

    public static long getUnixTime(Date date) {
        return date.getTime() / 1000L;
    }

    public static String getXMLFormattedString(String string) throws Exception {
        return WorkflowUtils.getXMLFormattedString(string, true);
    }

    public static String getXMLFormattedString(String string, boolean bl) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (bl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "ISO-8859-1");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(new StreamSource(new StringReader(string)), streamResult);
        return stringWriter.toString();
    }

    public static boolean isGuid(String string) {
        try {
            if (string.length() == 36) {
                UUID.fromString(string);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void removeSystemAttributes(WorkflowElement workflowElement) {
        workflowElement.removeAttribute("class");
        workflowElement.removeAttribute("_list_");
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            WorkflowUtils.removeSystemAttributes(workflowElement2);
        }
    }

    public static InputForm buildConfigForm(SchemaWrapper schemaWrapper) throws Exception {
        if (schemaWrapper.getSchema().getChildren().size() == 0) {
            return null;
        }
        Element element = JDOMUtil.parseXml(schemaWrapper.getXmlDefinition());
        if (element == null) {
            element = new Element("configuration");
        }
        return SchemaEncoder.encodeForm((XMLSchema)schemaWrapper.getSchema(), (Element)element);
    }

    public static String getWorkflowInputs(String string) {
        if (string != null && string.startsWith("{")) {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.opt("inputs");
            if (object != null && object instanceof JSONObject) {
                return XML.toString((Object)jSONObject);
            }
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("inputs", (Object)jSONObject);
            return XML.toString((Object)jSONObject2);
        }
        return string;
    }

    public static byte[] createChecksum(InputStream inputStream) throws Exception {
        int n;
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n);
        } while (n != -1);
        inputStream.close();
        return messageDigest.digest();
    }

    public static String getMD5Checksum(File file) throws Exception {
        return WorkflowUtils.getMD5Checksum(new FileInputStream(file));
    }

    public static String getMD5Checksum(InputStream inputStream) throws Exception {
        byte[] byArray = WorkflowUtils.createChecksum(inputStream);
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string;
    }

    public static Object convert(Object object, Class clazz) throws Exception {
        if (object == null) {
            return null;
        }
        return WorkflowUtils.convert(String.valueOf(object), clazz);
    }

    public static Object convert(String string, Class clazz) throws Exception {
        if (string == null) {
            return null;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return string;
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
            return Boolean.parseBoolean(string);
        }
        if (clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Character.TYPE)) {
            return Character.valueOf(string.charAt(0));
        }
        if (clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Byte.TYPE)) {
            return Byte.parseByte(string);
        }
        if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
            return Short.parseShort(string);
        }
        if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
            return Integer.parseInt(string);
        }
        if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
            return Long.parseLong(string);
        }
        if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
            return Double.parseDouble(string);
        }
        throw new Exception("cannot convert to type [" + clazz.getName() + "]");
    }

    public static boolean isPrimitiveType(Class clazz) {
        return clazz.isAssignableFrom(String.class) || clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Double.class) || clazz.isPrimitive();
    }

    public static boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object.getClass().isPrimitive();
    }

    public static Class getParameterizedType(Type type) throws Exception {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray != null && typeArray.length == 1) {
                return (Class)typeArray[0];
            }
            return Object.class;
        }
        return Object.class;
    }

    public static String readFile(String string) throws Exception {
        File file = new File(string);
        return WorkflowUtils.readFile(file);
    }

    public static String readFile(File file) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[(int)file.length()];
        bufferedInputStream.read(byArray);
        bufferedInputStream.close();
        return new String(byArray);
    }

    public static String readStream(InputStream inputStream) throws IOException {
        return IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
    }

    public static void copyEntry(InputStream inputStream, File file) throws Exception {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    public static String encodeXml(String string) throws EvFailureException {
        WorkflowElement workflowElement = WorkflowElement.parse(string);
        WorkflowUtils.encodeValues(workflowElement);
        return workflowElement.toString();
    }

    public static void encodeValues(WorkflowElement workflowElement) {
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            for (WorkflowAttribute workflowAttribute : workflowElement2.getAttributes()) {
                workflowAttribute.setText(EncoderUtil.encodeString((String)workflowAttribute.getText()));
            }
            if (workflowElement2.getChildren().size() > 0) {
                WorkflowUtils.encodeValues(workflowElement2);
                continue;
            }
            workflowElement2.setText(EncoderUtil.encodeString((String)workflowElement2.getText()));
        }
    }

    public static String encodeImage(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byteArrayOutputStream.reset();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        inputStream.close();
        Base64Encoder base64Encoder = new Base64Encoder();
        return base64Encoder.encode(byArray2);
    }

    public static byte[] getBytes(InputStream inputStream) throws Exception {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byteArrayOutputStream.reset();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String getFileExtenstion(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1, string.length());
    }

    public static String toRelativePath(File file, File file2) {
        String[] stringArray;
        String[] stringArray2 = file.getAbsolutePath().split("\\\\");
        int n = stringArray2.length < (stringArray = file2.getAbsolutePath().split("\\\\")).length ? stringArray2.length : stringArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n && stringArray2[n3].equalsIgnoreCase(stringArray[n3])) {
            n2 = n3++;
        }
        if (n2 == -1) {
            return file2.getAbsolutePath();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = n2 + 1; n3 < stringArray2.length; ++n3) {
            if (stringArray2[n3].length() <= 0) continue;
            stringBuilder.append("..\\");
        }
        for (n3 = n2 + 1; n3 < stringArray.length - 1; ++n3) {
            stringBuilder.append(stringArray[n3] + "\\");
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        return stringBuilder.toString();
    }

    public static String convertMessageToString(Object object) {
        if (object instanceof ClientEntity) {
            return ((ClientEntity)object).getClientName();
        }
        if (object instanceof UserEntity) {
            return ((UserEntity)object).getUserName();
        }
        if (object instanceof WorkflowEntity) {
            return ((WorkflowEntity)object).getWorkflowName();
        }
        if (object instanceof LibraryEntity) {
            return ((LibraryEntity)object).getLibraryName();
        }
        if (object instanceof CredentialEntity) {
            return ((CredentialEntity)object).getCredentialName();
        }
        if (object instanceof ClientGroupEntity) {
            return ((ClientGroupEntity)object).getClientGroupName();
        }
        if (object instanceof StoragePolicyEntity) {
            return ((StoragePolicyEntity)object).getStoragePolicyName();
        }
        if (object instanceof SchedulePolicyEntity) {
            return ((SchedulePolicyEntity)object).getSchedulePolicyName();
        }
        if (object instanceof UserGroupEntity) {
            return ((UserGroupEntity)object).getUserGroupName();
        }
        if (object instanceof MediaAgentEntity) {
            return ((MediaAgentEntity)object).getMediaAgentName();
        }
        if (object instanceof ExternalGroupEntity) {
            return ((ExternalGroupEntity)object).getExternalGroupName();
        }
        if (object instanceof CommCellEntity) {
            return ((CommCellEntity)object).getCommCellName();
        }
        logger.warn("convertMessageToString: unknown entity type [%s]", object.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getString(String string, String ... stringArray) {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            ResultSet resultSet;
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i]);
                }
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                String string2 = resultSet.getString(1);
                return string2;
            }
            logger.warn("could not find row from query [%s]", string);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getId(String string, String ... stringArray) {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            ResultSet resultSet;
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i]);
                }
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            logger.warn("could not find id row from query [%s]", string);
        }
        return 0;
    }

    public static Object updateMessageId(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EntityFlags) {
            return object;
        }
        if (object instanceof ClientEntity) {
            if (((ClientEntity)object).getClientId() == 0 && ((ClientEntity)object).getClientName().length() > 0) {
                ((ClientEntity)object).setClientId(WorkflowUtils.getId("select id from APP_Client where name = ?", ((ClientEntity)object).getClientName()));
                ((ClientEntity)object).setDisplayName(WorkflowUtils.getString("select displayName from APP_Client where name = ?", ((ClientEntity)object).getClientName()));
            }
        } else if (object instanceof UserEntity) {
            if (((UserEntity)object).getUserId() == 0 && ((UserEntity)object).getUserName().length() > 0) {
                ((UserEntity)object).setUserId(WorkflowUtils.getId("Select id From UMUsers where login = ?", ((UserEntity)object).getUserName()));
            }
        } else if (object instanceof WorkflowEntity) {
            if (((WorkflowEntity)object).getWorkflowId() == 0 && ((WorkflowEntity)object).getWorkflowName().length() > 0) {
                ((WorkflowEntity)object).setWorkflowId(WorkflowUtils.getId("select WorkflowId from WF_Definition where name = ?", ((WorkflowEntity)object).getWorkflowName()));
            }
        } else if (object instanceof LibraryEntity) {
            if (((LibraryEntity)object).getLibraryId() == 0 && ((LibraryEntity)object).getLibraryName().length() > 0) {
                ((LibraryEntity)object).setLibraryId(WorkflowUtils.getId("Select LibraryId From MMLibrary Where AliasName = ?", ((LibraryEntity)object).getLibraryName()));
            }
        } else if (!(object instanceof CredentialEntity)) {
            if (object instanceof ClientGroupEntity) {
                if (((ClientGroupEntity)object).getClientGroupId() == 0 && ((ClientGroupEntity)object).getClientGroupName().length() > 0) {
                    ((ClientGroupEntity)object).setClientGroupId(WorkflowUtils.getId("Select id from APP_ClientGroup Where name = ?", ((ClientGroupEntity)object).getClientGroupName()));
                }
            } else if (object instanceof StoragePolicyEntity) {
                if (((StoragePolicyEntity)object).getStoragePolicyId() == 0 && ((StoragePolicyEntity)object).getStoragePolicyName().length() > 0) {
                    ((StoragePolicyEntity)object).setStoragePolicyId(WorkflowUtils.getId("Select id from archGroup where name = ?", ((StoragePolicyEntity)object).getStoragePolicyName()));
                }
            } else if (object instanceof SchedulePolicyEntity) {
                if (((SchedulePolicyEntity)object).getSchedulePolicyId() == 0 && ((SchedulePolicyEntity)object).getSchedulePolicyName().length() > 0) {
                    ((SchedulePolicyEntity)object).setSchedulePolicyId(WorkflowUtils.getId("Select taskId from TM_Task where taskName = ?", ((SchedulePolicyEntity)object).getSchedulePolicyName()));
                }
            } else if (object instanceof UserGroupEntity) {
                if (((UserGroupEntity)object).getUserGroupId() == 0 && ((UserGroupEntity)object).getUserGroupName().length() > 0) {
                    String string = ((UserGroupEntity)object).getUserGroupName();
                    int n = string.indexOf("\\");
                    if (n > -1) {
                        String string2 = string.substring(0, n);
                        string = string.substring(n + 1);
                        ((UserGroupEntity)object).setUserGroupId(WorkflowUtils.getId("Select id from UMGroups where name = ? and umdsProviderId in (Select id from UMDSProviders Where domainName = ?)", string, string2));
                    } else {
                        ((UserGroupEntity)object).setUserGroupId(WorkflowUtils.getId("Select id From UMGroups where name = ?", string));
                    }
                }
            } else if (object instanceof MediaAgentEntity) {
                if (((MediaAgentEntity)object).getMediaAgentId() == 0 && ((MediaAgentEntity)object).getMediaAgentName().length() > 0) {
                    ((MediaAgentEntity)object).setMediaAgentId(WorkflowUtils.getId("select id from APP_Client where name = ?", ((MediaAgentEntity)object).getMediaAgentName()));
                }
            } else if (object instanceof ExternalGroupEntity) {
                if (((ExternalGroupEntity)object).getGroupId() == 0 && ((ExternalGroupEntity)object).getExternalGroupName().length() > 0) {
                    ((ExternalGroupEntity)object).setGroupId(WorkflowUtils.getId("SELECT UG.id FROM UMDSgroups UG INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id WHERE UP.domainName + '\\' + UG.name = ?", ((ExternalGroupEntity)object).getExternalGroupName()));
                }
            } else if (object instanceof CommCellEntity) {
                if (((CommCellEntity)object).getCommCellId() == 0 && ((CommCellEntity)object).getCommCellName().length() > 0) {
                    ((CommCellEntity)object).setCommCellId(WorkflowUtils.getId("SELECT id FROM APP_CommCell Where aliasName = ?", ((CommCellEntity)object).getCommCellName()));
                }
            } else {
                logger.debug("updateMessageId: unknown entity type [%s]", object.getClass().getName());
            }
        }
        return object;
    }

    public static Object convertStringToMessage(Class clazz, String string) {
        logger.xml("converting string value [%s] to type [%s]", string, clazz);
        if (clazz.isAssignableFrom(EntityFlags.class)) {
            return new EntityFlags();
        }
        if (clazz.isAssignableFrom(CommCellEntity.class)) {
            CommCellEntity commCellEntity = new CommCellEntity();
            commCellEntity.setCommCellName(string);
            return WorkflowUtils.updateMessageId(commCellEntity);
        }
        if (clazz.isAssignableFrom(ClientEntity.class)) {
            ClientEntity clientEntity = new ClientEntity();
            clientEntity.setClientName(string);
            clientEntity.set_type_(EntityType.CLIENT_ENTITY);
            return WorkflowUtils.updateMessageId(clientEntity);
        }
        if (clazz.isAssignableFrom(UserEntity.class)) {
            UserEntity userEntity = new UserEntity();
            userEntity.setUserName(string);
            userEntity.set_type_(EntityType.USER_ENTITY);
            return WorkflowUtils.updateMessageId(userEntity);
        }
        if (clazz.isAssignableFrom(WorkflowEntity.class)) {
            WorkflowEntity workflowEntity = new WorkflowEntity();
            workflowEntity.setWorkflowName(string);
            workflowEntity.set_type_(EntityType.WORKFLOW_ENTITY);
            return WorkflowUtils.updateMessageId(workflowEntity);
        }
        if (clazz.isAssignableFrom(LibraryEntity.class)) {
            LibraryEntity libraryEntity = new LibraryEntity();
            libraryEntity.setLibraryName(string);
            libraryEntity.set_type_(EntityType.LIBRARY_ENTITY);
            return WorkflowUtils.updateMessageId(libraryEntity);
        }
        if (clazz.isAssignableFrom(CredentialEntity.class)) {
            CredentialEntity credentialEntity = new CredentialEntity();
            credentialEntity.setCredentialName(string);
            credentialEntity.set_type_(EntityType.CREDENTIAL_ENTITY);
            return WorkflowUtils.updateMessageId(credentialEntity);
        }
        if (clazz.isAssignableFrom(ClientGroupEntity.class)) {
            ClientGroupEntity clientGroupEntity = new ClientGroupEntity();
            clientGroupEntity.setClientGroupName(string);
            clientGroupEntity.set_type_(EntityType.CLIENT_GROUP_ENTITY);
            return WorkflowUtils.updateMessageId(clientGroupEntity);
        }
        if (clazz.isAssignableFrom(StoragePolicyEntity.class)) {
            StoragePolicyEntity storagePolicyEntity = new StoragePolicyEntity();
            storagePolicyEntity.setStoragePolicyName(string);
            storagePolicyEntity.set_type_(EntityType.STORAGE_POLICY_ENTITY);
            return WorkflowUtils.updateMessageId(storagePolicyEntity);
        }
        if (clazz.isAssignableFrom(SchedulePolicyEntity.class)) {
            SchedulePolicyEntity schedulePolicyEntity = new SchedulePolicyEntity();
            schedulePolicyEntity.setSchedulePolicyName(string);
            schedulePolicyEntity.set_type_(EntityType.SCHEDULE_POLICY_ENTITY);
            return WorkflowUtils.updateMessageId(schedulePolicyEntity);
        }
        if (clazz.isAssignableFrom(UserGroupEntity.class)) {
            UserGroupEntity userGroupEntity = new UserGroupEntity();
            userGroupEntity.setUserGroupName(string);
            userGroupEntity.set_type_(EntityType.USERGROUP_ENTITY);
            return WorkflowUtils.updateMessageId(userGroupEntity);
        }
        if (clazz.isAssignableFrom(MediaAgentEntity.class)) {
            MediaAgentEntity mediaAgentEntity = new MediaAgentEntity();
            mediaAgentEntity.setMediaAgentName(string);
            mediaAgentEntity.set_type_(EntityType.MEDIAAGENT_ENTITY);
            return WorkflowUtils.updateMessageId(mediaAgentEntity);
        }
        if (clazz.isAssignableFrom(ExternalGroupEntity.class)) {
            ExternalGroupEntity externalGroupEntity = new ExternalGroupEntity();
            externalGroupEntity.setExternalGroupName(string);
            externalGroupEntity.set_type_(EntityType.EXTERNAL_GROUP_ENTITY);
            return WorkflowUtils.updateMessageId(externalGroupEntity);
        }
        logger.warn("convertStringToMessage: unknown entity type [%s]", clazz.getName());
        return null;
    }

    public static double getManifestVersion(File file) {
        try {
            return WorkflowUtils.getManifestVersion(new JarFile(file));
        }
        catch (IOException iOException) {
            logger.error("getManifestVersion() - cannot load jar file [" + file.getAbsolutePath() + "]", iOException);
            return 0.0;
        }
    }

    public static double getManifestVersion(JarFile jarFile) {
        int n;
        String string;
        int n2;
        String string2;
        try {
            string2 = jarFile.getManifest().getMainAttributes().getValue("Specification-Version");
        }
        catch (IOException iOException) {
            logger.error("getManifestVersion() - cannot read Specification-Version from Manifest file in jar [" + jarFile.getName() + "]", iOException);
            return 0.0;
        }
        if (string2 == null) {
            return 0.0;
        }
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("getManifestVersion() - cannot convert Specification-Version [%s] to integer", numberFormatException);
            return 0.0;
        }
        try {
            string = jarFile.getManifest().getMainAttributes().getValue("UpdateNumber");
        }
        catch (IOException iOException) {
            logger.error("getManifestVersion() - cannot read UpdateNumber from Manifest file in jar [" + jarFile.getName() + "]", iOException);
            return n2;
        }
        if (string == null) {
            return n2;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("getManifestVersion() - cannot convert UpdateNumber [%s] to integer", numberFormatException);
            return n2;
        }
        return Double.parseDouble(String.valueOf(n2) + "." + StringUtils.leftPad((String)String.valueOf(n), (int)5, (String)"0"));
    }

    public static CTEDBConnInfo getDatabaseConnection(APP_CommCellInfo_t aPP_CommCellInfo_t) {
        CTEDBConnInfo cTEDBConnInfo = new CTEDBConnInfo();
        if (aPP_CommCellInfo_t.ProxyPortNumber.get() > 0) {
            if (aPP_CommCellInfo_t.ProxyHostName.get().length() > 0) {
                cTEDBConnInfo.setInstance(aPP_CommCellInfo_t.ProxyHostName.get() + ":" + aPP_CommCellInfo_t.ProxyPortNumber.get());
            } else {
                cTEDBConnInfo.setInstance(aPP_CommCellInfo_t.CCHostName.get() + ":" + aPP_CommCellInfo_t.ProxyPortNumber.get());
            }
        } else if (aPP_CommCellInfo_t.ProxyHostName.get().length() > 0) {
            cTEDBConnInfo.setInstance(aPP_CommCellInfo_t.ProxyHostName.get() + "\\" + aPP_CommCellInfo_t.sqlInstance.get());
        } else {
            cTEDBConnInfo.setInstance(aPP_CommCellInfo_t.CCHostName.get() + "\\" + aPP_CommCellInfo_t.sqlInstance.get());
        }
        String[] stringArray = WorkflowUtils.getAccessCredentials(aPP_CommCellInfo_t.sqlAccessInfo.get());
        cTEDBConnInfo.setUserId(stringArray[0]);
        cTEDBConnInfo.setPassword(stringArray[1]);
        return cTEDBConnInfo;
    }

    public static String[] getAccessCredentials(String string) {
        CVPassword cVPassword = new CVPassword();
        String string2 = cVPassword.decrypt(string);
        int n = Integer.parseInt(string2.substring(0, 2));
        return new String[]{string2.substring(2, 2 + n), string2.substring(2 + n)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivitySchema convertSchema(String string, String string2) throws Exception {
        ActivitySchema activitySchema;
        logger.debug("building Workflow::ActivitySchema for activity [%s], schema [%s]", string2, string);
        try (SchemaManager schemaManager = SchemaManager.newInstance();){
            activitySchema = SchemaUtils.getActivitySchema((String)string, (String)string2, (SchemaTypeSystem)schemaManager);
        }
        logger.debug("built Workflow::ActivitySchema for activity [%s], xml [%s]", string2, XMLEncoder.encode((Object)activitySchema));
        return activitySchema;
    }

    public static void setSQLParameters(PreparedStatement preparedStatement, List<SQLParameter> list) throws Exception {
        if (list == null || preparedStatement == null) {
            return;
        }
        int n = 0;
        block14: for (SQLParameter sQLParameter : list) {
            ++n;
            if (sQLParameter.value == null) {
                preparedStatement.setNull(n, sQLParameter.type.getSqlType());
                continue;
            }
            if (sQLParameter.type == SQLType.OBJECT) {
                preparedStatement.setObject(n, sQLParameter.value);
                continue;
            }
            String string = String.valueOf(sQLParameter.value);
            switch (sQLParameter.type) {
                case BOOLEAN: {
                    preparedStatement.setBoolean(n, Boolean.parseBoolean(string));
                    continue block14;
                }
                case DATE: {
                    java.sql.Date date;
                    Comparable<Date> comparable2;
                    if (sQLParameter.value instanceof Date) {
                        comparable2 = (Date)sQLParameter.value;
                        date = new java.sql.Date(((Date)comparable2).getTime());
                    } else if (sQLParameter.value instanceof Calendar) {
                        comparable2 = (Calendar)sQLParameter.value;
                        date = new java.sql.Date(((Calendar)comparable2).getTimeInMillis());
                    } else {
                        throw new Exception("sql parameter value [%s] is not of type java.util.Date or java.util.Calendar");
                    }
                    preparedStatement.setDate(n, date);
                    continue block14;
                }
                case TIMESTAMP: {
                    Comparable<Date> comparable3;
                    Comparable<Date> comparable2;
                    if (sQLParameter.value instanceof Date) {
                        comparable3 = (Date)sQLParameter.value;
                        comparable2 = new Timestamp(((Date)comparable3).getTime());
                    } else if (sQLParameter.value instanceof Calendar) {
                        comparable3 = (Calendar)sQLParameter.value;
                        comparable2 = new Timestamp(((Calendar)comparable3).getTimeInMillis());
                    } else {
                        throw new Exception("sql parameter value [%s] is not of type java.util.Date or java.util.Calendar");
                    }
                    preparedStatement.setTimestamp(n, (Timestamp)comparable2);
                    continue block14;
                }
                case DOUBLE: {
                    preparedStatement.setDouble(n, Double.parseDouble(string));
                    continue block14;
                }
                case FLOAT: {
                    preparedStatement.setFloat(n, Float.parseFloat(string));
                    continue block14;
                }
                case INTEGER: {
                    preparedStatement.setInt(n, Integer.parseInt(string));
                    continue block14;
                }
                case LONG: {
                    preparedStatement.setLong(n, Long.parseLong(string));
                    continue block14;
                }
                case NSTRING: {
                    preparedStatement.setNString(n, string);
                    continue block14;
                }
                case SHORT: {
                    preparedStatement.setShort(n, Short.parseShort(string));
                    continue block14;
                }
                case STRING: {
                    preparedStatement.setString(n, string);
                    continue block14;
                }
                case TIME: {
                    Comparable<Date> comparable;
                    Comparable<Date> comparable3;
                    if (sQLParameter.value instanceof Date) {
                        comparable = (Date)sQLParameter.value;
                        comparable3 = new java.sql.Time(((Date)comparable).getTime());
                    } else if (sQLParameter.value instanceof Calendar) {
                        comparable = (Calendar)sQLParameter.value;
                        comparable3 = new java.sql.Time(((Calendar)comparable).getTimeInMillis());
                    } else if (sQLParameter.value instanceof Time) {
                        comparable = (Time)sQLParameter.value;
                        comparable3 = new java.sql.Time(comparable.getDate().getTime());
                    } else {
                        throw new Exception("sql parameter value [%s] is not of type Time, Date or Calendar");
                    }
                    preparedStatement.setTime(n, (java.sql.Time)comparable3);
                    continue block14;
                }
                case XML: {
                    preparedStatement.setString(n, string);
                    continue block14;
                }
            }
            throw new Exception("unknown type [" + sQLParameter.type + "]");
        }
    }

    public static List<String> split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ';' || cArray[i] == ',') {
                if (stringBuffer.toString().length() > 0) {
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.toString().length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static InputForm getUserInputForm(ActivityContext activityContext, workflow.types.XML xML, String string) throws EvFailureException {
        InputForm inputForm = SchemaEncoder.encodeForm((XMLSchema)activityContext.getSchema().getInputs(), (workflow.types.XML)xML);
        inputForm.setActivity(activityContext.getUniqueName());
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        for (XMLSchema xMLSchema : inputForm.getEntries()) {
            Object object;
            Object object22;
            xMLSchema.setDisplayName(workflowEvaluator.parseString(xMLSchema.getDisplayName()));
            xMLSchema.setDocumentation(workflowEvaluator.parseString(xMLSchema.getDocumentation()));
            if (xMLSchema.getControlType() == null && xMLSchema.getInputType().startsWith("commvault.msgs.CVEntities")) {
                xMLSchema.setControlType(InputControlType.DROPDOWN);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object22 : xMLSchema.getOptions()) {
                if (((String)object22).matches("(?i)(xpath:|java:|groovy:|js:|jython:|csdb:|\\{)\\{[\\S\\s]*(}}|}|}:java|}:groovy|}:js|}:jython)")) {
                    object = activityContext.getEvaluator().evaluate((String)object22);
                    if (object != null) {
                        if (object instanceof Collection) {
                            logger.debug(activityContext.getJobId(), "adding all results from expression [%s] to options [%s]", object22, object);
                            arrayList.addAll((Collection)object);
                            continue;
                        }
                        logger.debug(activityContext.getJobId(), "adding result of expression [%s] to options [%s]", object22, object);
                        arrayList.add(String.valueOf(object));
                        continue;
                    }
                    logger.warn(activityContext.getJobId(), "option expression [%s] returned null", object22);
                    continue;
                }
                arrayList.add((String)object22);
            }
            xMLSchema.setOptions(arrayList);
            ArrayList arrayList2 = new ArrayList();
            object22 = xMLSchema.getLabelsForOptions().iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                if (((String)object).matches("(?i)(xpath:|java:|groovy:|js:|jython:|csdb:|\\{)\\{[\\S\\s]*(}}|}|}:java|}:groovy|}:js|}:jython)")) {
                    Object object3 = activityContext.getEvaluator().evaluate((String)object);
                    if (object3 != null) {
                        if (object3 instanceof Collection) {
                            logger.debug(activityContext.getJobId(), "adding all results from expression [%s] to labels for options [%s]", object, object3);
                            arrayList2.addAll((Collection)object3);
                            continue;
                        }
                        logger.debug(activityContext.getJobId(), "adding result of expression [%s] to labels for options [%s]", object, object3);
                        arrayList2.add(String.valueOf(object3));
                        continue;
                    }
                    logger.warn(activityContext.getJobId(), "label for option expression [%s] returned null", object);
                    continue;
                }
                arrayList2.add(object);
            }
            xMLSchema.setLabelsForOptions((List)arrayList2);
        }
        inputForm.setDestPath(WorkflowProperties.getInstance().getJobResultsDir());
        inputForm.setProperties(WorkflowUtils.getFormProperties(activityContext, workflowEvaluator, string));
        return inputForm;
    }

    public static FormProperties getFormProperties(ActivityContext activityContext, String string) throws EvFailureException {
        WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
        return WorkflowUtils.getFormProperties(activityContext, workflowEvaluator, string);
    }

    public static FormProperties getFormProperties(ActivityContext activityContext, WorkflowEvaluator workflowEvaluator, String string) throws EvFailureException {
        FormProperties formProperties = null;
        if (activityContext.getFormProperties() != null) {
            formProperties = activityContext.getFormProperties();
        } else if (string != null && string.length() > 0) {
            try {
                formProperties = (FormProperties)XMLDecoder.decode((String)string);
            }
            catch (Exception exception) {
                logger.error("failed to build form properties, xml [" + string + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (formProperties != null) {
            formProperties.setCss(workflowEvaluator.parseString(formProperties.getCss()));
            formProperties.setJavaScript(workflowEvaluator.parseString(formProperties.getJavaScript()));
            return formProperties;
        }
        return new FormProperties();
    }

    public static String maskString(String string, String string2) {
        if (string != null && string2 != null) {
            return StringUtils.replace((String)string, (String)string2, (String)"******");
        }
        return string;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static String executeXml(String string, CommCellToken commCellToken, long l) throws ExecuteException, EvFailureException, InterruptedException {
        return WorkflowUtils.executeXml(string, commCellToken, l, null);
    }

    public static String executeXml(String string, CommCellToken commCellToken, long l, String string2) throws ExecuteException, EvFailureException, InterruptedException {
        Object object;
        File file = null;
        if (string != null && string.length() > 0) {
            try {
                string = WorkflowUtils.encodeXml(string);
            }
            catch (EvFailureException evFailureException) {
                logger.error(l, "failed to encode xml [" + WorkflowUtils.maskString(string, string2) + "]");
                throw evFailureException;
            }
        }
        String string3 = UUID.randomUUID().toString() + ".xml";
        logger.debug(l, "creating file [%s] to place the inputted xml contents into", string3);
        file = new File(WorkflowRegistry.getInstance().getGalaxyTempDir(), string3);
        try {
            object = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            if (string != null) {
                ((Writer)object).write(string);
            }
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            logger.error(l, "failed to write xml to file [" + file.getAbsolutePath() + "]", iOException);
            throw new ExecuteException(iOException.getMessage(), 1);
        }
        object = "qoperation";
        String string4 = String.format("execute -af '%s' -cs '%s' -tk %s", file.getAbsolutePath(), commCellToken.getCommServHost(), commCellToken.getToken());
        try {
            String string5 = WorkflowUtils.executeCommand((String)object, string4, string2);
            return string5;
        }
        catch (IOException iOException) {
            logger.error(l, "error executing command [" + (String)object + "]", iOException);
            throw new EvFailureException(new EvMessageContainer(iOException.getMessage()));
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static String executeCommand(String string, String string2) throws ExecuteException, IOException, InterruptedException {
        return WorkflowUtils.executeCommand(string, string2, null);
    }

    private static String executeCommand(String string, String string2, String string3) throws ExecuteException, IOException, InterruptedException {
        File file = new File(WorkflowRegistry.getInstance().getGalaxyHome(), "Base");
        File file2 = new File(file, string);
        String string4 = WorkflowUtils.isWindows() ? "\"" + file2.getAbsolutePath() + "\" " + string2 : file2.getAbsolutePath() + " " + string2;
        logger.trace("executing command [" + string4 + "]");
        Process process = Runtime.getRuntime().exec(string4);
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "ERROR");
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "OUTPUT");
        streamGobbler.start();
        streamGobbler2.start();
        int n = process.waitFor();
        streamGobbler.join();
        streamGobbler2.join();
        if (n == 0) {
            String string5 = streamGobbler2.getBuffer().toString().trim();
            logger.debug("command succeeded with result [%s]", WorkflowUtils.maskString(string5, string3));
            WorkflowUtils.closeProcess(process);
            return string5;
        }
        String string6 = streamGobbler.getBuffer().toString().trim();
        if (string6.length() == 0) {
            string6 = streamGobbler2.getBuffer().toString().trim();
        }
        logger.error("executing xml return error code [" + n + "], error message [" + string6 + "]");
        WorkflowUtils.closeProcess(process);
        throw new ExecuteException(string6, n);
    }

    public static void closeProcess(Process process) {
        try {
            process.getErrorStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            process.getInputStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            process.getOutputStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String buildFailureReason(Collection<EvFailureReason> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (EvFailureReason evFailureReason : collection) {
            String string = evFailureReason.getFailureId();
            if (stringBuffer.length() + string.length() < 256) {
                stringBuffer.append(string);
                continue;
            }
            logger.warn("max failure reason length reached [256] from total number of failures [%s]", collection.size());
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    public static Object decodeMessage(String string, Object object) throws Exception {
        return XMLDecoder.decode((String)string, (Object)object);
    }

    public static Object decodeMessage(Element element, Object object) throws Exception {
        JDOMStreamReader jDOMStreamReader = new JDOMStreamReader(element);
        return XMLDecoder.decode((XMLStreamReader)jDOMStreamReader, (Object)object);
    }

    public static Element encodeMessage(Object object) throws EvFailureException {
        JDOMStreamWriter jDOMStreamWriter = new JDOMStreamWriter();
        try {
            XMLEncoder.encode((Object)object, (XMLStreamWriter)jDOMStreamWriter);
        }
        catch (Exception exception) {
            logger.error("failed to encode message [" + object.getClass().getName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        return jDOMStreamWriter.getDocument().getRootElement();
    }

    public static Element encodeMessage(Object object, String string) throws EvFailureException {
        Element element = WorkflowUtils.encodeMessage(object);
        element.setName(string);
        return element;
    }

    public static String encodeMessageAsString(Object object, String string) throws EvFailureException {
        Element element = WorkflowUtils.encodeMessage(object, string);
        return JDOMUtil.serialize(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String string, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = WorkflowUtils.openOutputStream(file, bl);
            IOUtils.write((String)string, (OutputStream)fileOutputStream, (String)"UTF-8");
            ((OutputStream)fileOutputStream).close();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public static FileOutputStream openOutputStream(File file, boolean bl) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.mkdirs() && !file2.isDirectory()) {
                throw new IOException("Directory '" + file2 + "' could not be created");
            }
        }
        return new FileOutputStream(file, bl);
    }
}

