/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.common.xml.JDOMStreamWriter;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.PackageManager;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.ActivityPackage;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.WorkflowPackage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Scanner;
import javax.xml.stream.XMLStreamWriter;
import org.jdom2.Element;

public class ScriptBuilder {
    private static final String ICON_LINE_0 = "SET @icon = null";
    private static final String ICON_LINE_1 = "SET @icon = '%s'";
    private static final String ICON_LINE_2 = "SET @icon = @icon + '%s'";
    private static final String ICON_LINE_END = " + CHAR(10)\n";
    private File templateLocation;
    private WorkflowPackage workflowPackage;
    private String activityTemplate;
    private StringBuffer bActivities = new StringBuffer();
    private XMLStream stream = new XMLStream();

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        if (stringArray.length > 0) {
            string2 = stringArray[0];
            string = stringArray[1];
        } else {
            string2 = "C:\\Release11\\vaultcx\\Source\\CommServer\\CVWorkflowEngine";
            string = "c:\\temp";
        }
        ScriptBuilder scriptBuilder = new ScriptBuilder(string2);
        scriptBuilder.parse();
        scriptBuilder.writeFiles(string);
    }

    public ScriptBuilder(String string) throws Exception {
        this.templateLocation = new File(string, "resource\\commvault\\cte\\workflow");
        File file = new File(string, "resource\\commvault\\cte\\workflow\\activities\\activities.xml");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.workflowPackage = (WorkflowPackage)XMLDecoder.decode((InputStream)fileInputStream, (Object)new WorkflowPackage());
        fileInputStream.close();
        this.bActivities.append(WorkflowUtils.readFile(new File(this.templateLocation, "ActivityHeader.txt")));
        this.activityTemplate = WorkflowUtils.readFile(new File(this.templateLocation, "ActivityTemplate.txt"));
    }

    private void parse() throws Exception {
        for (ActivityPackage activityPackage : this.workflowPackage.getActivity()) {
            this.processActivity(activityPackage);
        }
    }

    private void processActivity(ActivityPackage activityPackage) throws Exception {
        Class<?> clazz = Class.forName(activityPackage.getClassName());
        ActivitySchema activitySchema = activityPackage.getActivitySchema(false) == null ? this.stream.generateActivitySchema(clazz) : activityPackage.getActivitySchema();
        JDOMStreamWriter jDOMStreamWriter = new JDOMStreamWriter();
        XMLEncoder.encode((Object)activitySchema, (XMLStreamWriter)jDOMStreamWriter);
        Element element = jDOMStreamWriter.getDocument().getRootElement();
        element.setName("activitySchema");
        String string = String.format(this.activityTemplate, this.getSqlWrapper(activityPackage.getName()), this.getSqlWrapper(activityPackage.getDisplayName(false)), this.getSqlWrapper(activityPackage.getDescription(false)), this.getSqlWrapper(clazz.getName()), this.getImage(activityPackage.getIcon(false)), this.getSqlWrapper(activityPackage.getCellClass(false)), this.getSqlWrapper(activityPackage.getInputEditor(false)), this.getSqlWrapper(activityPackage.getGroup(false)), this.formatBoolean(activityPackage.getOutbound(false)), this.formatBoolean(activityPackage.getInbound(false)), PackageManager.buildFlags(activityPackage), this.getSqlWrapper(JDOMUtil.serialize(element)), this.getSqlWrapper(clazz.getPackage().getName()), this.getSqlWrapper(activityPackage.getDefinition()));
        this.bActivities.append(string);
    }

    private String formatBoolean(Boolean bl) {
        if (bl == null || bl.booleanValue()) {
            return "1";
        }
        return "0";
    }

    private String getImage(String string) throws Exception {
        String string2 = null;
        if (string == null || string.length() <= 0) {
            return ICON_LINE_0;
        }
        Comparable<File> comparable = new File(this.templateLocation, "activities\\" + string);
        Closeable closeable = new FileInputStream((File)comparable);
        string2 = WorkflowUtils.encodeImage((InputStream)closeable);
        ((FileInputStream)closeable).close();
        comparable = new StringBuffer();
        closeable = new Scanner(string2);
        int n = 0;
        while (((Scanner)closeable).hasNext()) {
            if (++n == 1) {
                ((StringBuffer)comparable).append(String.format(ICON_LINE_1, ((Scanner)closeable).next()));
            } else {
                ((StringBuffer)comparable).append(String.format(ICON_LINE_2, ((Scanner)closeable).next()));
            }
            if (!((Scanner)closeable).hasNext()) continue;
            ((StringBuffer)comparable).append(ICON_LINE_END);
        }
        ((Scanner)closeable).close();
        return ((StringBuffer)comparable).toString();
    }

    private String getSqlWrapper(String string) {
        if (string == null) {
            return "null";
        }
        return "'" + this.formatSql(string) + "'";
    }

    private String formatSql(String string) {
        return string.replaceAll("'", "''");
    }

    private void writeFiles(String string) throws Exception {
        this.writeActivities(string);
    }

    private void writeActivities(String string) throws Exception {
        FileWriter fileWriter = new FileWriter(new File(string, "WF_Activity.script"));
        fileWriter.write(this.bActivities.toString());
        fileWriter.close();
    }
}

