/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import workflow.types.XML;

public class ImportUtils {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ImportUtils.class);

    public XML fromUrl(String string) {
        return this.fromUrl(string, false);
    }

    public XML fromUrl(String string, boolean bl) {
        try {
            logger.info("importing xml from [%s]", string);
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            return this.importXml(uRLConnection.getInputStream(), bl);
        }
        catch (Exception exception) {
            logger.error("error importing xml from [" + string + "]", exception);
            return null;
        }
    }

    public XML fromFile(String string) {
        return this.fromFile(string, false);
    }

    public XML fromFile(String string, boolean bl) {
        try {
            logger.info("importing xml from [%s]", string);
            return this.importXml(new FileInputStream(string), bl);
        }
        catch (Exception exception) {
            logger.error("error importing xml from [" + string + "]", exception);
            return null;
        }
    }

    private XML importXml(InputStream inputStream, boolean bl) throws Exception {
        WorkflowElement workflowElement = WorkflowElement.parse(inputStream);
        logger.info("retrieved xml [%s]", workflowElement);
        return workflowElement;
    }
}

