/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ScheduleView;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.APP_Client_t;
import commvault.cte.workflow.db.cs.APP_ComponentProp_t;
import commvault.cte.workflow.db.cs.GXGlobalParam_t;
import commvault.cte.workflow.db.cs.WF_Definition_t;
import commvault.cte.workflow.db.cs.WF_Deploy_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.WorkflowEntity;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class CommServUtils {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommServUtils.class);

    public static int getCommCellTimeUnix() {
        long l = CommServUtils.getCommCellTime();
        return (int)(l / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCommCellTime() {
        if (WorkflowRegistry.getInstance().isCommServ()) {
            return Calendar.getInstance().getTimeInMillis();
        }
        logger.trace("retrieving time from commcell since we are on a remote client");
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("DECLARE @now datetime = GETUTCDATE() \n select convert(numeric(30),datediff(dd,'1970-01-01 00:00:00.000',@now)) * 24 * 60 * 60 * 1000 + datediff(ms,convert(datetime,convert(date,@now)),@now)");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInteractionApprover(int n, int n2) throws Exception {
        logger.trace("checking if user [%s] is approver of interaction id [%s]", n2, n);
        String string = "SELECT * FROM dbo.GetUserInteractions(" + n2 + ", 1) WHERE InteractionId = " + n;
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebConsoleUrlFromClientProp() throws Exception {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("select attrVal from APP_ClientProp where attrName = 'WebURL' and attrVal <> '' and modified=0 order by created desc");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActivtyIdForWorkflow(String string) throws Exception {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            int n;
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("Select ActivityId From WF_Definition Where Name = ?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) > 0) {
                int n2 = n;
                return n2;
            }
        }
        throw new Exception("cannot find activity id for workflow [" + string + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebConsoleUrl() throws Exception {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("select value from GXGlobalParam where name = 'WebConsoleURL' and modified=0");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string != null && string.length() > 0) {
                    int n = string.toLowerCase().indexOf("webconsole");
                    if (n > 0) {
                        String string2 = string.substring(0, n + 10);
                        return string2;
                    }
                    n = string.toLowerCase().indexOf("clientdetails");
                    if (n > 0) {
                        String string3 = string.substring(0, n - 1);
                        return string3;
                    }
                    String string4 = string;
                    return string4;
                }
                String string5 = null;
                return string5;
            }
            String string = CommServUtils.getWebConsoleUrlFromClientProp();
            return string;
        }
    }

    public static void updateJobVersion(WF_Process_t wF_Process_t, WF_Deployments_t wF_Deployments_t, WF_Deployments_t wF_Deployments_t2) throws EvFailureException {
        List<WF_ProcessSteps_t> list;
        String string = String.format("jobId = %s AND wfJobId = 0 AND State = %s", wF_Process_t.jobId.get(), ExecutionState.RUNNING.toInt());
        try {
            list = WF_ProcessSteps_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(wF_Process_t.jobId.get(), "failed to retrieve running steps for job id [" + wF_Process_t.jobId.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        for (WF_ProcessSteps_t wF_ProcessSteps_t : list) {
            WF_Steps_t wF_Steps_t = new WF_Steps_t();
            String string2 = String.format("UniqueName = '%s' AND DeploymentId = %s", wF_ProcessSteps_t.Name.get(), wF_Deployments_t2.DeploymentId.get());
            try {
                if (!wF_Steps_t.fill(string2)) {
                    logger.error(wF_Process_t.jobId.get(), "failed to retrieve step for workflow id [" + wF_Deployments_t.WorkflowId.get() + "], step [" + wF_ProcessSteps_t.Name.get() + "]");
                    EvMessageContainer evMessageContainer = new EvMessageContainer("step [%s] does not exist in workflow [%s]", wF_ProcessSteps_t.Name.get(), wF_Deployments_t2.WorkflowName.get());
                    throw new EvFailureException(evMessageContainer);
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error(wF_Process_t.jobId.get(), "failed to retrieve step for workflow id [" + wF_Deployments_t.WorkflowId.get() + "], step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            wF_ProcessSteps_t.StepId.set(wF_Steps_t.StepId.get());
        }
        wF_Process_t.DeploymentId.set(wF_Deployments_t2.DeploymentId.get());
        try {
            wF_Process_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(wF_Process_t.jobId.get(), "failed to update deployment information for job Id [" + wF_Process_t.jobId.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        for (WF_ProcessSteps_t wF_ProcessSteps_t : list) {
            try {
                wF_ProcessSteps_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(wF_Process_t.jobId.get(), "failed to update process step [" + wF_ProcessSteps_t.ProcessStepId.get() + "], unique name [" + wF_ProcessSteps_t.Name.get() + "] with new deployed step id [" + wF_ProcessSteps_t.StepId.get() + "]", cTEDBException);
            }
        }
        CommServUtils.checkEmbeddedWorkflows(wF_Process_t.jobId.get());
    }

    public static void checkEmbeddedWorkflows(long l) throws EvFailureException {
        List<WF_SuperProcess_t> list;
        String string = String.format("jobId = %s AND DeploymentId IS NOT NULL AND State = %s", l, ExecutionState.RUNNING.toInt());
        try {
            list = WF_SuperProcess_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(l, "failed to retrieve embedded workflows for job id [" + l + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        logger.debug("EMBEDDED WORKFLOWS: [" + list.size() + "], where: [" + string + "]");
        for (WF_SuperProcess_t wF_SuperProcess_t : list) {
            Object object;
            WF_Deployments_t wF_Deployments_t = new WF_Deployments_t();
            String string2 = String.format("DeploymentId = %s", wF_SuperProcess_t.DeploymentId.get());
            try {
                if (!wF_Deployments_t.fill(string2)) {
                    logger.error("could not find deployment information for super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "], deployment id [" + wF_SuperProcess_t.DeploymentId.get() + "]");
                    object = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_DEPLOYMENT", new Object[0]);
                    throw new EvFailureException((EvMessageContainer)object);
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error("error looking up deployment for super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "], deployment id [" + wF_SuperProcess_t.DeploymentId.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            object = CommServUtils.getWorkflowDeployment(wF_Deployments_t.WorkflowId.get(), 0);
            CommServUtils.updateEmbeddedWorkflows(wF_SuperProcess_t, wF_Deployments_t, object);
        }
    }

    public static void updateEmbeddedWorkflows(WF_SuperProcess_t wF_SuperProcess_t, WF_Deployments_t wF_Deployments_t, WF_Deployments_t wF_Deployments_t2) throws EvFailureException {
        List<WF_ProcessSteps_t> list;
        if (wF_Deployments_t2.Version.get() <= wF_Deployments_t.Version.get()) {
            logger.debug("not upgrading embedded workflow super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "] since it's up to date");
        }
        logger.info("upgrading embedded workflow [" + wF_Deployments_t.WorkflowName.get() + "] super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "] to version [" + wF_Deployments_t2.Version.get() + "]");
        String string = String.format("jobId = %s AND wfJobId = %s AND State = %s", wF_SuperProcess_t.jobId.get(), wF_SuperProcess_t.SuperProcessId.get(), ExecutionState.RUNNING.toInt());
        try {
            list = WF_ProcessSteps_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(wF_SuperProcess_t.jobId.get(), "failed to retrieve running steps for super process id [" + wF_SuperProcess_t.SuperProcessId.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        for (WF_ProcessSteps_t wF_ProcessSteps_t : list) {
            WF_Steps_t wF_Steps_t = new WF_Steps_t();
            String string2 = String.format("UniqueName = '%s' AND DeploymentId = %s", wF_ProcessSteps_t.Name.get(), wF_Deployments_t2.DeploymentId.get());
            try {
                if (!wF_Steps_t.fill(string2)) {
                    logger.error(wF_SuperProcess_t.jobId.get(), "failed to retrieve step for workflow id [" + wF_Deployments_t.WorkflowId.get() + "], step [" + wF_ProcessSteps_t.Name.get() + "]");
                    EvMessageContainer evMessageContainer = new EvMessageContainer("step [%s] does not exist in workflow [%s]", wF_ProcessSteps_t.Name.get(), wF_Deployments_t2.WorkflowName.get());
                    throw new EvFailureException(evMessageContainer);
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error(wF_SuperProcess_t.jobId.get(), "failed to retrieve step for workflow id [" + wF_Deployments_t.WorkflowId.get() + "], step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            wF_ProcessSteps_t.StepId.set(wF_Steps_t.StepId.get());
        }
        wF_SuperProcess_t.DeploymentId.set(wF_Deployments_t2.DeploymentId.get());
        try {
            wF_SuperProcess_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(wF_SuperProcess_t.jobId.get(), "failed to update deployment information for job Id [" + wF_SuperProcess_t.jobId.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        for (WF_ProcessSteps_t wF_ProcessSteps_t : list) {
            try {
                wF_ProcessSteps_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(wF_SuperProcess_t.jobId.get(), "failed to update process step [" + wF_ProcessSteps_t.ProcessStepId.get() + "], unique name [" + wF_ProcessSteps_t.Name.get() + "] with new deployed step id [" + wF_ProcessSteps_t.StepId.get() + "]", cTEDBException);
            }
        }
    }

    public static String getGlobalParameterValue(String string) {
        GXGlobalParam_t gXGlobalParam_t = new GXGlobalParam_t();
        String string2 = String.format("name = '%s'", string);
        try {
            if (gXGlobalParam_t.fill(string2)) {
                return gXGlobalParam_t.value.get();
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve GxGlobal Parameter [" + string + "]", cTEDBException);
        }
        return null;
    }

    public static String getWorkflowNameFromGUID(String string) throws EvFailureException {
        WF_Definition_t wF_Definition_t = new WF_Definition_t();
        try {
            logger.trace("retrieving workflow definition from commcell");
            String string2 = String.format("uniqueGuid = '%s'", string);
            if (!wF_Definition_t.fill(string2)) {
                logger.error("unable to find workflow name from guid [" + string + "]");
                EvMessageContainer evMessageContainer = new EvMessageContainer("invalid workflow guid [" + string + "]");
                throw new EvFailureException(evMessageContainer);
            }
            return wF_Definition_t.Name.get();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve workflow name from guid [" + string + "]", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
    }

    public static WF_Deployments_t getWorkflowDeployment(int n, int n2) throws EvFailureException {
        WorkflowEntity workflowEntity = new WorkflowEntity();
        workflowEntity.setWorkflowId(n);
        return CommServUtils.getWorkflowDeployment(workflowEntity, n2);
    }

    public static WF_Deployments_t getWorkflowDeployment(WorkflowEntity workflowEntity, int n) throws EvFailureException {
        Object object;
        String string;
        if (workflowEntity.getWorkflowId() > 0) {
            string = String.format("WorkflowId = %s AND Status = 1", workflowEntity.getWorkflowId());
        } else if (workflowEntity.getWorkflowName().length() > 0) {
            object = null;
            object = WorkflowUtils.isGuid(workflowEntity.getWorkflowName()) ? CommServUtils.getWorkflowNameFromGUID(workflowEntity.getWorkflowName()) : workflowEntity.getWorkflowName();
            string = String.format("WorkflowName = '%s' AND Status = 1", object);
        } else {
            throw new EvFailureException(new EvMessageContainer("invalid workflow entity"));
        }
        if (n > 0) {
            string = string + String.format(" AND Version = %s", n);
        }
        object = new WF_Deployments_t();
        try {
            if (!object.fill(string, "DeploymentId desc")) {
                logger.error("failed to retrieve workflow deployment information via where clause [" + string + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_DEPLOYMENT", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve workflow deployment information via where clause [" + string + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (((WF_Deployments_t)((Object)object)).DeployedRel.isNull() || ((WF_Deployments_t)((Object)object)).DeployedRel.get() < WorkflowProperties.getInstance().getVersion() || ((WF_Deployments_t)((Object)object)).SchemaDefinition.isNull()) {
            logger.info("re-deploying workflow [%s] since that deployment record is from a prior release", ((WF_Deployments_t)((Object)object)).WorkflowName.get());
            object = DeploymentManager.redeploy((WF_Deployments_t)((Object)object));
        }
        return object;
    }

    public static WF_Definition_t getCommCellDefinition(WF_Deployments_t wF_Deployments_t) throws EvFailureException {
        WF_Definition_t wF_Definition_t = new WF_Definition_t();
        try {
            logger.trace("retrieving workflow definition from commcell");
            String string = String.format("WorkflowId = %s", wF_Deployments_t.WorkflowId.get());
            if (!wF_Definition_t.fill(string)) {
                logger.error("the definition for workflow [" + wF_Deployments_t.WorkflowName.get() + "] was removed from the commcell");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_DEPLOYMENT", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
            return wF_Definition_t;
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to load WF_Definition row for workflow [" + wF_Deployments_t.WorkflowName.get() + "]", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
    }

    public static WF_Deploy_t getCommCellDeployment(WF_Deployments_t wF_Deployments_t) throws EvFailureException {
        WF_Deploy_t wF_Deploy_t = new WF_Deploy_t();
        try {
            logger.trace("retrieving deployment from commcell");
            String string = String.format("DeployId = %s", wF_Deployments_t.DeployId.get());
            if (!wF_Deploy_t.fill(string)) {
                logger.error("the deployment information for deploy id [" + wF_Deployments_t.DeployId.get() + "] was removed from the commcell");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_DEPLOYMENT", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
            return wF_Deploy_t;
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to load WF_Deploy row for workflow [" + wF_Deployments_t.WorkflowName.get() + "]", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
    }

    public static boolean canManageWorkflow(int n, String string, UserEntity userEntity) {
        try {
            return CommServUtils.isWorkflowCapability(userEntity.getUserId(), n, Capability.MANAGE_OPERATION);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error retrieving workflow capabilities for user id [" + userEntity.getUserId() + "]", cTEDBException);
            return false;
        }
    }

    public static List<ClientEntity> getInstalledEngines() throws Exception {
        ArrayList<ClientEntity> arrayList = new ArrayList<ClientEntity>();
        String string = String.format("id IN (SELECT ClientId FROM dbo.simInstalledPackages WHERE simPackageID in (808))", new Object[0]);
        List<APP_Client_t> list = APP_Client_t.select(string);
        for (APP_Client_t aPP_Client_t : list) {
            arrayList.add(CommServUtils.getEntity(aPP_Client_t));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduleView getScheduleView(int n) throws Exception {
        if (n == 0) {
            return null;
        }
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("select schedpattern, schedinterval, schedday, schedTime, schednexttime from CommCellAdminSchedule Where scheduleId = ?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleView scheduleView = new ScheduleView(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getDate(5));
                return scheduleView;
            }
            ScheduleView scheduleView = null;
            return scheduleView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateInteractionClientId(int n, int n2) throws Exception {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("Update WF_Interaction Set clientId = ? Where clientId = ?");
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
        }
    }

    public static String getConfigurationSettings(int n) throws Exception {
        APP_ComponentProp_t aPP_ComponentProp_t = new APP_ComponentProp_t();
        String string = String.format("componentType = 13 and componentId = %s and propertyTypeId = 18", n);
        if (!aPP_ComponentProp_t.fill(string)) {
            return null;
        }
        return aPP_ComponentProp_t.stringVal.get();
    }

    public static ClientEntity getClientFromGUID(String string) throws Exception {
        APP_Client_t aPP_Client_t = new APP_Client_t();
        String string2 = String.format("GUID = '%s'", string);
        if (!aPP_Client_t.fill(string2)) {
            throw new Exception("failed to find client information for guid [" + string + "] from CommCell");
        }
        return CommServUtils.getEntity(aPP_Client_t);
    }

    public static ClientEntity getClientEntity(String string) throws Exception {
        return CommServUtils.getClientEntity(string, WorkflowProperties.getInstance().getCommCellConnection());
    }

    public static ClientEntity getClientEntity(int n) throws Exception {
        return CommServUtils.getClientEntity(n, WorkflowProperties.getInstance().getCommCellConnection());
    }

    public static ClientEntity getClientEntity(int n, CTEDBConnection cTEDBConnection) throws Exception {
        return CommServUtils.getClientEntity("Select * from APP_Client Where id = ?", n, cTEDBConnection);
    }

    public static ClientEntity getClientEntity(String string, CTEDBConnection cTEDBConnection) throws Exception {
        return CommServUtils.getClientEntity("Select * from APP_Client Where name = ?", string, cTEDBConnection);
    }

    public static ClientEntity getClientEntity(String string, Object object, CTEDBConnection cTEDBConnection) throws Exception {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            preparedStatement.setObject(1, object);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ClientEntity clientEntity = CommServUtils.getEntity(resultSet);
                return clientEntity;
            }
            throw new Exception("failed to find client information for [" + object + "] from CommCell");
        }
    }

    private static ClientEntity getEntity(APP_Client_t aPP_Client_t) {
        ClientEntity clientEntity = new ClientEntity();
        clientEntity.setClientGUID(aPP_Client_t.GUID.get());
        clientEntity.setClientId(aPP_Client_t.id.get().intValue());
        clientEntity.setClientName(aPP_Client_t.name.get());
        clientEntity.setCommCellId(aPP_Client_t.origCCId.get().intValue());
        clientEntity.setHostName(aPP_Client_t.net_hostname.get());
        clientEntity.set_type_(EntityType.CLIENT_ENTITY);
        return clientEntity;
    }

    private static ClientEntity getEntity(ResultSet resultSet) throws Exception {
        ClientEntity clientEntity = new ClientEntity();
        clientEntity.setClientGUID(resultSet.getString("GUID"));
        clientEntity.setClientId(resultSet.getInt("id"));
        clientEntity.setClientName(resultSet.getString("name"));
        clientEntity.setCommCellId(resultSet.getInt("origCCId"));
        clientEntity.setHostName(resultSet.getString("net_hostname"));
        clientEntity.set_type_(EntityType.CLIENT_ENTITY);
        return clientEntity;
    }

    public static boolean isWorkflowCapability(int n, int n2, Capability capability) throws CTEDBException {
        return CommServUtils.checkPermissionOnEntity(n, EntityType.WORKFLOW_ENTITY.getEnumValue(), n2, capability);
    }

    public static boolean canEditWorkflow(int n, int n2) throws CTEDBException {
        return CommServUtils.checkPermissionOnEntity(n, EntityType.WORKFLOW_ENTITY.getEnumValue(), n2, Capability.EDIT_OPERATION);
    }

    public static boolean checkPermissionOnEntity(int n, int n2, int n3, Capability capability) throws CTEDBException {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            CallableStatement callableStatement = cTEDBReservation.createCallableStatement("{call sec_checkPermissionOnEntity(?,?,?,?,?)}");
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, capability.getBitIndex());
            callableStatement.registerOutParameter(3, 4);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, n3);
            callableStatement.execute();
            boolean bl = callableStatement.getInt(3) == 1;
            return bl;
        }
    }

    public static String generateQSDKToken(UserEntity userEntity, CTEDBConnection cTEDBConnection) throws Exception {
        String string = "SET NOCOUNT ON \nDECLARE @curTime int \ndeclare @qsdkSessionId int \nSET @curTime  = (SELECT [CommServ].[dbo].[GetUnixTime](GETUTCDATE())) \nInsert into UMQSDKSessions(userId,evmgrsSessionId,userName,password,created,lastAccessedTime,referenceCount,encryptedToken,sessionFileLocation,hostName,consoleType,timeout) \nvalues (?,0,?,'2AZdUUxUUyUUz',@curTime,@curTime,1,'','','',18,?) \nset @qsdkSessionId = @@IDENTITY \nselect convert(varchar(255),UMQSDKSessions.GUId) from UMQSDKSessions where UMQSDKSessions.id = @qsdkSessionId \nSET NOCOUNT OFF";
        try (CTEDBReservation cTEDBReservation = cTEDBConnection.createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            preparedStatement.setInt(1, userEntity.getUserId());
            preparedStatement.setString(2, userEntity.getUserName());
            preparedStatement.setInt(3, WorkflowRegistry.getInstance().getQSDKSessionTimeout());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                return string2;
            }
            throw new Exception("failed to generate qsdk token for user [" + userEntity.getUserName() + "]");
        }
    }
}

