/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.utils;

import commvault.cte.workflow.logger.CTELogger;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassPathUtil {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ClassPathUtil.class);
    private static ClassPathUtil instance;
    private final Map<String, File> classPath = new ConcurrentHashMap<String, File>();
    private static final Class[] parameters;

    public static ClassPathUtil getInstance() {
        if (instance == null) {
            instance = new ClassPathUtil();
        }
        return instance;
    }

    public boolean contains(File file) {
        return this.classPath.containsKey(file.getAbsolutePath().toLowerCase());
    }

    public File get(File file) {
        return this.classPath.get(file.getAbsolutePath().toLowerCase());
    }

    public synchronized void add(File file) throws Exception {
        logger.debug("adding package [%s] to class path", file.getName());
        ClassPathUtil.addURL(file.toURI().toURL());
        this.classPath.put(file.getAbsolutePath().toLowerCase(), file);
    }

    private static void addURL(URL uRL) throws Exception {
        InputStream inputStream = uRL.openStream();
        inputStream.close();
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", parameters);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }

    static {
        parameters = new Class[]{URL.class};
    }
}

