/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.SingleValueConverter;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;

public class StringConverter
extends SingleValueConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(StringConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(String.class);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        WorkflowElement workflowElement = unmarshallingContext.getElementHolder().getElement();
        String string = workflowElement.getAttributeValue("_nil_");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            return null;
        }
        String string2 = workflowElement.getAttributeValue("class");
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (!clazz.equals(String.class)) {
                    Object object = unmarshallingContext.unmarshalAnother(new ObjectType(clazz), unmarshallingContext.getElementHolder());
                    return this.convertToString(object);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("failed to instantiate type [" + string2 + "] to convert to String", classNotFoundException);
            }
        } else {
            logger.xml("source element [%s] does not contain a type", workflowElement.getName());
        }
        return this.fromString(workflowElement.getText());
    }

    private String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CTEProcessingModel) {
            return WorkflowUtils.convertMessageToString(object);
        }
        return String.valueOf(object);
    }

    @Override
    public Object fromString(String string) {
        return string;
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return SchemaUtils.getSchema(String.class);
    }
}

