/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.CollectionConverter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.XMLStream;
import java.lang.reflect.Type;
import java.util.Set;

public class SetConverter
extends CollectionConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SetConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return Set.class.isAssignableFrom(clazz);
    }

    private Object unmarshalGroup(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Set set;
        ObjectType objectType = unmarshallingContext.getType().getParameters().size() > 0 ? unmarshallingContext.getType().getParameters().get(0) : new ObjectType((Type)((Object)Object.class));
        Class clazz = unmarshallingContext.getType().isInterface() ? XMLStream.DEFAULT_SET_CLASS : unmarshallingContext.getType().getRawType();
        try {
            set = (Set)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.error("cannot instantiate type [" + clazz + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        for (WorkflowElement workflowElement : unmarshallingContext.getElementHolder().getElements()) {
            String string = workflowElement.getAttributeValue("_nil_");
            if (string != null && Boolean.valueOf(string).booleanValue()) continue;
            set.add(unmarshallingContext.unmarshalAnother(objectType, new SingleElement(workflowElement)));
        }
        return set;
    }

    private Object unmarshalSet(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Class clazz = unmarshallingContext.getType().isInterface() ? XMLStream.DEFAULT_LIST_CLASS : unmarshallingContext.getType().getRawType();
        try {
            Set set = (Set)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.error("cannot instantiate type [" + clazz + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        return unmarshallingContext.unmarshalAnother(new ObjectType(clazz), new GroupedElements(unmarshallingContext.getElementHolder().getElement().getChildren()));
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        if (unmarshallingContext.getElementHolder() instanceof SingleElement && Set.class.isAssignableFrom(unmarshallingContext.getElementHolder().getType())) {
            return this.unmarshalSet(unmarshallingContext);
        }
        return this.unmarshalGroup(unmarshallingContext);
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        return super.buildElements(marshallingContext, marshallingContext.getElementName(), ((Set)marshallingContext.getSource()).iterator());
    }
}

