/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.AbstractConverter;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;

public class ObjectConverter
extends AbstractConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ObjectConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(Object.class);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        WorkflowElement workflowElement = unmarshallingContext.getElementHolder().getElement();
        String string = workflowElement.getAttributeValue("_nil_");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            return null;
        }
        if (workflowElement.getChildren().size() > 0) {
            return workflowElement;
        }
        return workflowElement.getText();
    }

    @Override
    public void write(XMLStream.MarshallingContext marshallingContext, WorkflowElement workflowElement) throws EvFailureException {
        workflowElement.setText(this.toString(marshallingContext.getSource()));
    }

    public String toString(Object object) {
        return String.valueOf(object);
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return SchemaUtils.getSchema(Object.class);
    }
}

