/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.CollectionConverter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.XMLStream;
import java.lang.reflect.Type;
import java.util.List;

public class ListConverter
extends CollectionConverter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    private Object unmarshalGroup(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        List list;
        ObjectType objectType = unmarshallingContext.getType().getParameters().size() > 0 ? unmarshallingContext.getType().getParameters().get(0) : new ObjectType((Type)((Object)Object.class));
        Class clazz = unmarshallingContext.getType().isInterface() ? XMLStream.DEFAULT_LIST_CLASS : unmarshallingContext.getType().getRawType();
        try {
            list = (List)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.error("cannot instantiate type [" + clazz + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        for (WorkflowElement workflowElement : unmarshallingContext.getElementHolder().getElements()) {
            Object object;
            String string = workflowElement.getAttributeValue("_nil_");
            if (string != null && Boolean.valueOf(string).booleanValue() || !this.validItem(object = unmarshallingContext.unmarshalAnother(objectType, new SingleElement(workflowElement)))) continue;
            list.add(object);
        }
        return list;
    }

    private boolean validItem(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return String.valueOf(object).length() > 0;
            }
            return true;
        }
        return false;
    }

    private Object unmarshalList(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Class clazz = unmarshallingContext.getType().isInterface() ? XMLStream.DEFAULT_LIST_CLASS : unmarshallingContext.getType().getRawType();
        try {
            List list = (List)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.error("cannot instantiate type [" + clazz + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        return unmarshallingContext.unmarshalAnother(new ObjectType(clazz), new GroupedElements(unmarshallingContext.getElementHolder().getElement().getChildren()));
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        if (unmarshallingContext.getElementHolder() instanceof SingleElement && List.class.isAssignableFrom(unmarshallingContext.getElementHolder().getType())) {
            return this.unmarshalList(unmarshallingContext);
        }
        return this.unmarshalGroup(unmarshallingContext);
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        return super.buildElements(marshallingContext, marshallingContext.getElementName(), ((List)marshallingContext.getSource()).iterator());
    }
}

