/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.stream.AbstractConverter;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import java.lang.reflect.Field;

public class EnumConverter
extends AbstractConverter {
    @Override
    public boolean canConvert(Class clazz) {
        return clazz.isEnum() || Enum.class.isAssignableFrom(clazz);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        WorkflowElement workflowElement = unmarshallingContext.getElementHolder().getElement();
        String string = workflowElement.getAttributeValue("_nil_");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            return null;
        }
        if (workflowElement.getText().length() == 0) {
            return null;
        }
        return Enum.valueOf(unmarshallingContext.getType().getRawType(), workflowElement.getText());
    }

    @Override
    public void write(XMLStream.MarshallingContext marshallingContext, WorkflowElement workflowElement) throws EvFailureException {
        workflowElement.setText(((Enum)marshallingContext.getSource()).name());
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        XMLSchema xMLSchema = SchemaUtils.getSchema((Class)schemaContext.getFieldClass());
        for (Field field : schemaContext.getFieldClass().getFields()) {
            xMLSchema.getOptions().add(field.getName());
        }
        return xMLSchema;
    }
}

