/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.ReflectionConverter;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.CommCellEntity;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import workflow.types.data.DataSet;

public class DataSetConverter
extends ReflectionConverter {
    private static final String ROW_NAME_ATTRIBUTE = "row";
    private static final String ROWCOUNT_ELEMENT_NAME = "rowCount";
    private static final String COLCOUNT_ELEMENT_NAME = "columnCount";
    private static final String COMMCELL_ELEMENT_NAME = "commCell";

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(DataSet.class);
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        GroupedElements groupedElements = new GroupedElements(unmarshallingContext.getElementHolder().getElement().getChildren(ROW_NAME_ATTRIBUTE));
        List list = (List)unmarshallingContext.unmarshalAnother(new ObjectType((Type)((Object)ArrayList.class)), groupedElements);
        ArrayList<CommCellEntity> arrayList = new ArrayList<CommCellEntity>();
        List list2 = unmarshallingContext.getElementHolder().getElement().getChildren(COMMCELL_ELEMENT_NAME);
        if (list2 != null) {
            for (WorkflowElement workflowElement : list2) {
                SingleElement singleElement = new SingleElement(workflowElement);
                arrayList.add((CommCellEntity)unmarshallingContext.unmarshalAnother(new ObjectType((Type)((Object)CommCellEntity.class)), singleElement));
            }
        }
        return new DataSet(list, arrayList);
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        ElementHolder elementHolder;
        DataSet dataSet = (DataSet)marshallingContext.getSource();
        WorkflowElement workflowElement = new WorkflowElement(marshallingContext.getElementName());
        workflowElement.setAttribute("class", DataSet.class.getName());
        ElementHolder elementHolder2 = marshallingContext.marshalAnother(ROWCOUNT_ELEMENT_NAME, dataSet.size());
        workflowElement.addContent(elementHolder2.getElement());
        ElementHolder elementHolder3 = marshallingContext.marshalAnother(COLCOUNT_ELEMENT_NAME, dataSet.getColumnCount());
        workflowElement.addContent(elementHolder3.getElement());
        if (dataSet.getCommCells() != null) {
            elementHolder = marshallingContext.marshalAnother(COMMCELL_ELEMENT_NAME, dataSet.getCommCells());
            workflowElement.addContent(elementHolder.getElements());
        }
        elementHolder = marshallingContext.marshalAnother(ROW_NAME_ATTRIBUTE, dataSet.getRows());
        workflowElement.addContent(elementHolder.getElements());
        return new SingleElement(workflowElement);
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        return super.getSchema(schemaContext);
    }
}

