/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream.converters;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.stream.CollectionConverter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.XMLStream;
import commvault.msgs.App.XMLSchema;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ArrayConverter
extends CollectionConverter {
    @Override
    public boolean canConvert(Class clazz) {
        return clazz.isArray();
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Object object;
        ArrayList<WorkflowElement> arrayList = new ArrayList<WorkflowElement>();
        List list = unmarshallingContext.getElementHolder() instanceof SingleElement && unmarshallingContext.getType().getRawType().isArray() ? unmarshallingContext.getElementHolder().getElement().getChildren() : unmarshallingContext.getElementHolder().getElements();
        for (WorkflowElement workflowElement : list) {
            object = workflowElement.getAttributeValue("_nil_");
            if (object != null && Boolean.valueOf((String)object).booleanValue()) continue;
            arrayList.add(workflowElement);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Object object2 = Array.newInstance(unmarshallingContext.getType().getComponentType(), arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            object = new SingleElement((WorkflowElement)arrayList.get(i));
            Object object3 = unmarshallingContext.unmarshalAnother(new ObjectType(unmarshallingContext.getType().getComponentType()), (ElementHolder)object);
            Array.set(object2, i, object3);
        }
        return object2;
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        Vector<WorkflowElement> vector = new Vector<WorkflowElement>();
        int n = Array.getLength(marshallingContext.getSource());
        for (int i = 0; i < n; ++i) {
            Object object = Array.get(marshallingContext.getSource(), i);
            ElementHolder elementHolder = marshallingContext.marshalAnother(marshallingContext.getElementName(), object);
            if (elementHolder == null || elementHolder.size() <= 0) continue;
            if (elementHolder.size() == 1) {
                vector.add(elementHolder.getElement());
                continue;
            }
            vector.add(this.buildChildArray(marshallingContext.getElementName(), object.getClass(), elementHolder.getElements()));
        }
        return new GroupedElements(vector);
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        XMLSchema xMLSchema = schemaContext.generateAnother(schemaContext.getParent(), schemaContext.getFieldClass().getComponentType(), null);
        xMLSchema.setListType(true);
        return xMLSchema;
    }
}

