/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.workflow.annotations.Input;
import commvault.cte.common.workflow.annotations.XmlField;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import commvault.cte.workflow.stream.ClassContainer;
import commvault.cte.workflow.stream.CollectionConverter;
import commvault.cte.workflow.stream.Container;
import commvault.cte.workflow.stream.Converter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.FieldType;
import commvault.cte.workflow.stream.GroupedElements;
import commvault.cte.workflow.stream.Marshaller;
import commvault.cte.workflow.stream.MessageConverter;
import commvault.cte.workflow.stream.ObjectType;
import commvault.cte.workflow.stream.ReflectionConverter;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.StreamField;
import commvault.cte.workflow.stream.converters.ArrayConverter;
import commvault.cte.workflow.stream.converters.BigDecimalConverter;
import commvault.cte.workflow.stream.converters.BigIntegerConverter;
import commvault.cte.workflow.stream.converters.BinaryConverter;
import commvault.cte.workflow.stream.converters.BitSetConverter;
import commvault.cte.workflow.stream.converters.BooleanConverter;
import commvault.cte.workflow.stream.converters.ByteConverter;
import commvault.cte.workflow.stream.converters.CalendarConverter;
import commvault.cte.workflow.stream.converters.CharArrayConverter;
import commvault.cte.workflow.stream.converters.CharConverter;
import commvault.cte.workflow.stream.converters.CharSetConverter;
import commvault.cte.workflow.stream.converters.DataRowConverter;
import commvault.cte.workflow.stream.converters.DataSetConverter;
import commvault.cte.workflow.stream.converters.DateConverter;
import commvault.cte.workflow.stream.converters.DoubleConverter;
import commvault.cte.workflow.stream.converters.DurationConverter;
import commvault.cte.workflow.stream.converters.ElementConverter;
import commvault.cte.workflow.stream.converters.EncryptedStringConverter;
import commvault.cte.workflow.stream.converters.EnumConverter;
import commvault.cte.workflow.stream.converters.FileConverter;
import commvault.cte.workflow.stream.converters.FloatConverter;
import commvault.cte.workflow.stream.converters.IntConverter;
import commvault.cte.workflow.stream.converters.ListConverter;
import commvault.cte.workflow.stream.converters.LocaleConverter;
import commvault.cte.workflow.stream.converters.LongConverter;
import commvault.cte.workflow.stream.converters.MapConverter;
import commvault.cte.workflow.stream.converters.NullConverter;
import commvault.cte.workflow.stream.converters.ObjectConverter;
import commvault.cte.workflow.stream.converters.RegexPatternConverter;
import commvault.cte.workflow.stream.converters.SetConverter;
import commvault.cte.workflow.stream.converters.ShortConverter;
import commvault.cte.workflow.stream.converters.SqlDateConverter;
import commvault.cte.workflow.stream.converters.SqlTimeConverter;
import commvault.cte.workflow.stream.converters.SqlTimestampConverter;
import commvault.cte.workflow.stream.converters.StringBufferConverter;
import commvault.cte.workflow.stream.converters.StringConverter;
import commvault.cte.workflow.stream.converters.TimeConverter;
import commvault.cte.workflow.stream.converters.URLConverter;
import commvault.cte.workflow.stream.converters.UUIDConverter;
import commvault.cte.workflow.stream.converters.WorkflowFileConverter;
import commvault.cte.workflow.utils.ReflectionUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.Workflow.ActivitySchema;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class XMLStream
implements Marshaller {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(XMLStream.class);
    public static final Class DEFAULT_LIST_CLASS = Vector.class;
    public static final Class DEFAULT_SET_CLASS = HashSet.class;
    public static final Class DEFAULT_MAP_CLASS = HashMap.class;
    private final Vector<Converter> converters = new Vector();
    private final CollectionConverter listConverter = new ListConverter();

    public XMLStream() {
        this.registerConverters();
    }

    private void registerConverters() {
        this.converters.add(new NullConverter());
        this.converters.add(new ObjectConverter());
        this.converters.add(new StringConverter());
        this.converters.add(new IntConverter());
        this.converters.add(new BigDecimalConverter());
        this.converters.add(new BigIntegerConverter());
        this.converters.add(new BooleanConverter());
        this.converters.add(new ByteConverter());
        this.converters.add(new CharConverter());
        this.converters.add(new DoubleConverter());
        this.converters.add(new EnumConverter());
        this.converters.add(new FloatConverter());
        this.converters.add(new LongConverter());
        this.converters.add(new ShortConverter());
        this.converters.add(new StringBufferConverter());
        this.converters.add(new URLConverter());
        this.converters.add(new UUIDConverter());
        this.converters.add(new BitSetConverter());
        this.converters.add(new FileConverter());
        this.converters.add(new CharSetConverter());
        this.converters.add(new DurationConverter());
        this.converters.add(new LocaleConverter());
        this.converters.add(new RegexPatternConverter(new ReflectionConverter()));
        this.converters.add(new EncryptedStringConverter());
        this.converters.add(new ElementConverter());
        this.converters.add(new DataSetConverter());
        this.converters.add(new DataRowConverter());
        this.converters.add(new WorkflowFileConverter());
        this.converters.add(new MessageConverter());
        this.converters.add(new SqlDateConverter());
        this.converters.add(new SqlTimeConverter());
        this.converters.add(new SqlTimestampConverter());
        this.converters.add(new DateConverter());
        this.converters.add(new TimeConverter());
        this.converters.add(new CalendarConverter());
        this.converters.add(new CharArrayConverter());
        this.converters.add(new BinaryConverter());
        this.converters.add(new ArrayConverter());
        this.converters.add(this.listConverter);
        this.converters.add(new SetConverter());
        this.converters.add(new MapConverter());
    }

    public ActivitySchema generateActivitySchema(Class clazz) {
        ActivitySchema activitySchema = new ActivitySchema();
        List<Field> list = ReflectionUtils.getAccessibleFields(clazz, false);
        for (Field field : list) {
            if (ReflectionUtils.isInputField(field)) {
                activitySchema.getInputs().getChildren().add(this.getFieldSchema(activitySchema.getInputs(), field));
            }
            if (!ReflectionUtils.isOutputField(field)) continue;
            activitySchema.getOutputs().getChildren().add(this.getFieldSchema(activitySchema.getOutputs(), field));
        }
        SchemaUtils.clearParent((XMLSchema)activitySchema.getInputs());
        SchemaUtils.clearParent((XMLSchema)activitySchema.getOutputs());
        return activitySchema;
    }

    private XMLSchema getFieldSchema(XMLSchema xMLSchema, Field field) {
        String string = null;
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        boolean bl2 = false;
        boolean bl3 = true;
        if (field.getAnnotation(Output.class) != null) {
            string2 = field.getAnnotation(Output.class).documentation();
        } else if (field.getAnnotation(commvault.cte.common.workflow.annotations.Output.class) != null) {
            string2 = field.getAnnotation(commvault.cte.common.workflow.annotations.Output.class).documentation();
        }
        if (field.getAnnotation(commvault.cte.workflow.annotations.Input.class) != null) {
            bl = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).required();
            string2 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).documentation();
            string3 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).defaultValue();
            bl2 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).disableList();
            bl3 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).visible();
        } else if (field.getAnnotation(Input.class) != null) {
            bl = field.getAnnotation(Input.class).required();
            string2 = field.getAnnotation(Input.class).documentation();
            string3 = field.getAnnotation(Input.class).defaultValue();
            bl2 = field.getAnnotation(Input.class).disableList();
            bl3 = field.getAnnotation(Input.class).visible();
        }
        if (field.getAnnotation(InputOutput.class) != null) {
            bl = field.getAnnotation(InputOutput.class).required();
            string2 = field.getAnnotation(InputOutput.class).documentation();
            string3 = field.getAnnotation(InputOutput.class).defaultValue();
            bl2 = field.getAnnotation(InputOutput.class).disableList();
            bl3 = field.getAnnotation(InputOutput.class).visible();
        } else if (field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class) != null) {
            bl = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).required();
            string2 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).documentation();
            string3 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).defaultValue();
            bl2 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).disableList();
            bl3 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).visible();
        }
        if (field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class) != null) {
            bl = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).required();
            string2 = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).documentation();
            string3 = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).defaultValue();
            bl2 = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).disableList();
            if (field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).name() != null && field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).name().length() > 0) {
                string = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).name();
            }
        } else if (field.getAnnotation(XmlField.class) != null) {
            bl = field.getAnnotation(XmlField.class).required();
            string2 = field.getAnnotation(XmlField.class).documentation();
            string3 = field.getAnnotation(XmlField.class).defaultValue();
            bl2 = field.getAnnotation(XmlField.class).disableList();
            if (field.getAnnotation(XmlField.class).name() != null && field.getAnnotation(XmlField.class).name().length() > 0) {
                string = field.getAnnotation(XmlField.class).name();
            }
        }
        XMLSchema xMLSchema2 = this.getClassSchema(xMLSchema, field.getType(), field.getGenericType());
        if (string != null) {
            xMLSchema2.setName(string);
        } else {
            xMLSchema2.setName(field.getName());
        }
        if (xMLSchema2.getRequired(false) == null && bl) {
            xMLSchema2.setRequired(bl);
        }
        if (bl2) {
            xMLSchema2.setListType(false);
        }
        if (string2 != null && string2.length() > 0) {
            xMLSchema2.setDocumentation(string2);
        }
        if (string3 != null && string3.length() > 0) {
            xMLSchema2.setDefaultValue(string3);
        }
        if (!bl3) {
            xMLSchema2.setHidden(true);
        }
        if (xMLSchema.getRecursiveTypes().contains(xMLSchema2)) {
            return null;
        }
        return xMLSchema2;
    }

    private XMLSchema getClassSchema(XMLSchema xMLSchema, Class clazz, Type type) {
        Converter converter = this.getConverter(clazz);
        SchemaContext schemaContext = new SchemaContext(xMLSchema, clazz, type);
        return converter.getSchema(schemaContext);
    }

    private Converter getConverter(Class clazz) {
        for (Converter converter : this.converters) {
            if (!converter.canConvert(clazz)) continue;
            return converter;
        }
        return new ReflectionConverter();
    }

    @Override
    public void marshal(Object object, WorkflowElement workflowElement) throws EvFailureException {
        this.marshal(object, workflowElement, FieldType.OUTPUTS);
    }

    @Override
    public void marshal(Object object, WorkflowElement workflowElement, FieldType fieldType) throws EvFailureException {
        logger.debug("begin encoding outputs of class [%s]", object.getClass());
        ClassContainer classContainer = new ClassContainer(object);
        StreamField[] streamFieldArray = fieldType == FieldType.INPUTS ? classContainer.getInputFields() : classContainer.getOutputFields();
        this.marshal(workflowElement, streamFieldArray);
    }

    @Override
    public void unmarshal(WorkflowElement workflowElement, Object object) throws EvFailureException {
        logger.debug("begin decoding inputs into class [%s]", object.getClass());
        this.unmarshal(workflowElement, new ClassContainer(object));
    }

    @Override
    public Object decode(WorkflowElement workflowElement) throws EvFailureException {
        return this.decode(workflowElement, Object.class);
    }

    @Override
    public Object decode(WorkflowElement workflowElement, Class clazz) throws EvFailureException {
        if (workflowElement != null) {
            return this.decode(new SingleElement(workflowElement), new ObjectType(clazz));
        }
        return null;
    }

    @Override
    public Object decode(List<WorkflowElement> list) throws EvFailureException {
        return this.decode(list, Object.class);
    }

    @Override
    public Object decode(List<WorkflowElement> list, Class clazz) throws EvFailureException {
        if (list != null && list.size() > 0) {
            return this.decode(new GroupedElements(list), new ObjectType(clazz));
        }
        return null;
    }

    @Override
    public List decodeList(List<WorkflowElement> list) throws EvFailureException {
        return this.decodeList(list, Object.class);
    }

    @Override
    public List decodeList(List<WorkflowElement> list, Class clazz) throws EvFailureException {
        if (list != null && list.size() > 0) {
            GroupedElements groupedElements = new GroupedElements(list);
            ObjectType objectType = new ObjectType(DEFAULT_LIST_CLASS);
            objectType.getParameters().add(new ObjectType(clazz));
            Object object = this.decode(groupedElements, objectType);
            if (object instanceof List) {
                return (List)object;
            }
            logger.warn("failed to create list object from elements [" + groupedElements.getXml() + "]");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            return arrayList;
        }
        return null;
    }

    @Override
    public List<WorkflowElement> encode(String string, Object object) throws EvFailureException {
        ElementHolder elementHolder = this.encodeObj(string, object);
        if (elementHolder == null) {
            return null;
        }
        return elementHolder.getElements();
    }

    private Object decode(ElementHolder elementHolder, ObjectType objectType) throws EvFailureException {
        Converter converter = null;
        if (objectType.isObject()) {
            objectType = elementHolder.isList() ? new ObjectType(DEFAULT_LIST_CLASS) : new ObjectType(elementHolder.getType());
        }
        converter = this.getConverter(objectType.getRawType());
        try {
            if (logger.getLevel().toInt() >= LoggerLevel.XML.toInt()) {
                logger.xml("decoding type [%s], converter [%s], XML [%s]", objectType.getName(), converter.getClass().getName(), elementHolder.getXml());
            }
            if (elementHolder.isList() && !(converter instanceof CollectionConverter)) {
                logger.debug("WARNING: list of elements not being converted by a CollectionConverter [%s]", elementHolder.getXml());
            }
            Object object = converter.unmarshal(new UnmarshallingContext(objectType, elementHolder));
            return object;
        }
        catch (EvFailureException evFailureException) {
            logger.error("error decoding type [" + objectType.getName() + "], converter [" + converter.getClass().getName() + "], xml [" + elementHolder.getXml() + "]");
            throw evFailureException;
        }
    }

    private void unmarshal(WorkflowElement workflowElement, Container container) throws EvFailureException {
        Set<String> set = workflowElement.getDistinctChildNames();
        for (String string : set) {
            StreamField streamField = container.getFieldByElementName(string);
            if (streamField != null) {
                Object object;
                List list = workflowElement.getChildren(string);
                if (list.size() == 0) {
                    logger.debug("element [%s] contains no child members to unmarshal into [%s]", workflowElement.getName(), container.getType().getName());
                    return;
                }
                GroupedElements groupedElements = new GroupedElements(list);
                try {
                    object = this.decode(groupedElements, streamField.getType());
                }
                catch (EvFailureException evFailureException) {
                    logger.error("failed to decode field [" + streamField.getName() + "]");
                    throw evFailureException;
                }
                logger.debug("decoded field [%s], type [%s], value [%s], xml [%s]", streamField.getName(), streamField.getType().getName(), String.valueOf(object), groupedElements.getXml());
                streamField.set(object);
                continue;
            }
            logger.debug("found element(s) with name [%s] but no matching field was found in class [%s]", string, container.getType().getName());
        }
    }

    private void marshal(WorkflowElement workflowElement, StreamField[] streamFieldArray) throws EvFailureException {
        for (StreamField streamField : streamFieldArray) {
            Object object = streamField.get();
            if (object != null) {
                ElementHolder elementHolder;
                try {
                    elementHolder = this.encodeObj(streamField.getName(), object);
                }
                catch (EvFailureException evFailureException) {
                    logger.error("error marshalling field [" + streamField.getName() + "], value [" + String.valueOf(object) + "], type [" + object.getClass().getName() + "]");
                    throw evFailureException;
                }
                if (elementHolder == null) continue;
                workflowElement.addContent(elementHolder.getElements());
                continue;
            }
            logger.debug("skipping marshalling field [%s], value is null", streamField.getName());
        }
    }

    private ElementHolder encodeObj(String string, Object object) throws EvFailureException {
        if (object == null) {
            logger.debug("encoded object [%s] is null", string);
            return null;
        }
        Converter converter = this.getConverter(object.getClass());
        try {
            ElementHolder elementHolder = converter.marshal(new MarshallingContext(string, object));
            logger.debug("encoded object [%s], value [%s], type [%s], converter [%s], XML: [%s]", string, String.valueOf(object), object.getClass().getName(), converter.getClass().getName(), elementHolder.getXml());
            return elementHolder;
        }
        catch (EvFailureException evFailureException) {
            logger.error("failed to encode object [" + string + "], value [" + String.valueOf(object) + "], type [" + object.getClass().getName() + "], converter [" + converter.getClass().getName() + "]");
            throw evFailureException;
        }
    }

    public class SchemaContext {
        private Class fieldClass;
        private Type fieldType;
        private XMLSchema parent;

        private SchemaContext(XMLSchema xMLSchema, Class clazz, Type type) {
            this.fieldClass = clazz;
            this.fieldType = type;
            this.parent = xMLSchema;
        }

        public XMLSchema generateAnother(XMLSchema xMLSchema, Field field) {
            return XMLStream.this.getFieldSchema(xMLSchema, field);
        }

        public XMLSchema generateAnother(XMLSchema xMLSchema, Class clazz, Type type) {
            return XMLStream.this.getClassSchema(xMLSchema, clazz, type);
        }

        public Class getFieldClass() {
            return this.fieldClass;
        }

        public Type getFieldType() {
            return this.fieldType;
        }

        public XMLSchema getParent() {
            return this.parent;
        }
    }

    public class UnmarshallingContext {
        private final ObjectType type;
        private final ElementHolder elementHolder;

        private UnmarshallingContext(ObjectType objectType, ElementHolder elementHolder) {
            this.type = objectType;
            this.elementHolder = elementHolder;
        }

        public Object unmarshalAnother(ObjectType objectType, ElementHolder elementHolder) throws EvFailureException {
            return XMLStream.this.decode(elementHolder, objectType);
        }

        public void unmarshal(WorkflowElement workflowElement, Container container) throws EvFailureException {
            XMLStream.this.unmarshal(workflowElement, container);
        }

        public ObjectType getType() {
            return this.type;
        }

        public ElementHolder getElementHolder() {
            return this.elementHolder;
        }
    }

    public class MarshallingContext {
        private final String elementName;
        private final Object source;

        public MarshallingContext(String string, Object object) {
            this.elementName = string;
            this.source = object;
        }

        public ElementHolder marshalAnother(String string, Object object) throws EvFailureException {
            return XMLStream.this.encodeObj(string, object);
        }

        public void marshal(WorkflowElement workflowElement, StreamField[] streamFieldArray) throws EvFailureException {
            XMLStream.this.marshal(workflowElement, streamFieldArray);
        }

        public String getElementName() {
            return this.elementName;
        }

        public Object getSource() {
            return this.source;
        }
    }
}

