/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.stream;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.ClassContainer;
import commvault.cte.workflow.stream.Container;
import commvault.cte.workflow.stream.Converter;
import commvault.cte.workflow.stream.ElementHolder;
import commvault.cte.workflow.stream.SingleElement;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.ReflectionUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.EntityType;
import java.lang.reflect.Field;

public class ReflectionConverter
implements Converter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ReflectionConverter.class);

    @Override
    public boolean canConvert(Class clazz) {
        return false;
    }

    @Override
    public Object unmarshal(XMLStream.UnmarshallingContext unmarshallingContext) throws EvFailureException {
        Object object;
        if (unmarshallingContext.getType().isInterface()) {
            throw new Error("cannot unmarshal interface [" + unmarshallingContext.getType().getName() + "]");
        }
        if (unmarshallingContext.getElementHolder().getElement().getChildren().size() == 0) {
            return this.createFromString(unmarshallingContext.getType().getRawType(), unmarshallingContext.getElementHolder().getElement().getText());
        }
        try {
            object = ReflectionUtils.newInstance(unmarshallingContext.getType().getRawType());
        }
        catch (Exception exception) {
            logger.error("cannot instantiate type [" + unmarshallingContext.getType().getRawType() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        Container container = this.getContainer(object);
        unmarshallingContext.unmarshal(unmarshallingContext.getElementHolder().getElement(), container);
        return object;
    }

    protected Object createFromString(Class clazz, String string) {
        return null;
    }

    @Override
    public ElementHolder marshal(XMLStream.MarshallingContext marshallingContext) throws EvFailureException {
        WorkflowElement workflowElement = new WorkflowElement(marshallingContext.getElementName());
        workflowElement.setAttribute("class", marshallingContext.getSource().getClass().getName());
        Container container = this.getContainer(marshallingContext.getSource());
        marshallingContext.marshal(workflowElement, container.getFields());
        return new SingleElement(workflowElement);
    }

    public Container getContainer(Object object) {
        return new ClassContainer(object);
    }

    @Override
    public XMLSchema getSchema(XMLStream.SchemaContext schemaContext) {
        XMLSchema xMLSchema = SchemaUtils.getSchema((Class)schemaContext.getFieldClass());
        if (SchemaUtils.containsParentType((String)xMLSchema.getType(), (XMLSchema)schemaContext.getParent())) {
            xMLSchema.getParent().getRecursiveTypes().add(xMLSchema);
            return xMLSchema;
        }
        xMLSchema.setParent(schemaContext.getParent());
        for (Field field : ReflectionUtils.getAccessibleFields(schemaContext.getFieldClass(), false)) {
            XMLSchema xMLSchema2;
            if (field.getType() == EntityType.class || (xMLSchema2 = schemaContext.generateAnother(xMLSchema, field)) == null) continue;
            xMLSchema.getChildren().add(xMLSchema2);
        }
        return xMLSchema;
    }
}

