/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.schema;

import commvault.cte.common.schema.ComplexType;
import commvault.cte.common.schema.GenericTypes;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.workflow.annotations.Input;
import commvault.cte.common.workflow.annotations.XmlField;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.annotations.XmlType;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.ReflectionUtils;
import commvault.msgs.CvEntities.EntityLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jdom2.input.SAXBuilder;
import workflow.types.XML;

public class SchemaGenerator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SchemaGenerator.class);
    private SchemaTypeSystem sts;
    private String entitySchemaLoc;

    public static void generate(String string, Class clazz, SchemaTypeSystem schemaTypeSystem) throws Exception {
        SchemaGenerator schemaGenerator = new SchemaGenerator(string, clazz, schemaTypeSystem, null);
    }

    public static void generate(String string, Class clazz, SchemaTypeSystem schemaTypeSystem, String string2) throws Exception {
        SchemaGenerator schemaGenerator = new SchemaGenerator(string, clazz, schemaTypeSystem, string2);
    }

    public static SchemaTypeSystem generate(String string, Class clazz) throws Exception {
        SchemaGenerator schemaGenerator = new SchemaGenerator(string, clazz);
        return schemaGenerator.sts;
    }

    private SchemaGenerator(String string, Class clazz) throws Exception {
        this.sts = new SchemaTypeSystem();
        this.buildType(string, clazz);
    }

    private SchemaGenerator(String string, Class clazz, SchemaTypeSystem schemaTypeSystem, String string2) throws Exception {
        this.sts = schemaTypeSystem;
        this.entitySchemaLoc = string2;
        this.buildType(string, clazz);
    }

    private SchemaType buildType(String string, Class clazz) throws Exception {
        return this.buildType(string, clazz, false);
    }

    private SchemaType buildType(String string, Class clazz, boolean bl) throws Exception {
        Object object;
        Object object2;
        String string2;
        Object object3;
        logger.debug("creating type [%s] for class [%s]", string, clazz.getName());
        if (clazz.isInterface()) {
            throw new Exception("cannot generate type from interface - [" + clazz.getName() + "]");
        }
        if (clazz.getPackage() == null) {
            throw new Exception("cannot build a schema type for a non package type [" + clazz.getName() + "]");
        }
        SchemaDocument schemaDocument = this.sts.getNamespace(clazz.getPackage().getName());
        if (schemaDocument == null) {
            if (CTEProcessingModel.class.isAssignableFrom(clazz)) {
                object3 = null;
                string2 = clazz.getPackage().getName() + ".xsd";
                if (this.entitySchemaLoc != null) {
                    object3 = new FileInputStream(new File(this.entitySchemaLoc, string2));
                } else {
                    object2 = new JarFile(new File(WorkflowRegistry.getInstance().getInstallFolder(), "workflowEngine.jar"));
                    object = ((JarFile)object2).getEntry(string2);
                    if (object != null) {
                        object3 = ((JarFile)object2).getInputStream((ZipEntry)object);
                    }
                }
                if (object3 != null) {
                    object2 = new SAXBuilder();
                    object = object2.build((InputStream)object3);
                    logger.debug("retrieving schema for class [%s] from internal schema file [%s]", clazz.getName(), string2);
                    schemaDocument = this.sts.importSchema(object.getRootElement());
                } else {
                    logger.debug("could not find local schema file for internal class [%s] from file [%s], dynamically building a schema for it", clazz.getName(), string2);
                    schemaDocument = this.sts.createSchema(clazz.getPackage().getName());
                }
            } else {
                logger.debug("creating a new schema for namespace [%s]", clazz.getPackage().getName());
                schemaDocument = this.sts.createSchema(clazz.getPackage().getName());
            }
        }
        if ((object3 = schemaDocument.getType(string)) != null) {
            logger.debug("found existing type declaration [%s]", object3.toString());
            return object3;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            logger.debug("class [%s] appears to be an enumeration, creating a simple type", clazz.getName());
            string2 = schemaDocument.addSimpleType(string, GenericTypes.STRING.getType());
            for (Field field : clazz.getFields()) {
                string2.addEnumeration((Object)field.getName());
            }
            return string2;
        }
        string2 = null;
        if (!(clazz.getSuperclass() == null || clazz.getSuperclass().equals(Object.class) || clazz.getSuperclass().equals(EntityLevel.class) || clazz.getSuperclass().equals(CTEProcessingModel.class))) {
            logger.debug("class [%s] has a superclass [%s], create an abstract type for it", clazz.getName(), clazz.getSuperclass().getName());
            string2 = this.buildType(clazz.getSuperclass().getSimpleName(), clazz.getSuperclass(), true);
        }
        object2 = schemaDocument.addComplexType((SchemaType)string2, string, bl);
        if (clazz.getAnnotation(XmlType.class) != null) {
            object = clazz.getAnnotation(XmlType.class);
            object2.getAnnotation().getAppInfo().setUserType(object.userType());
        } else if (clazz.getAnnotation(commvault.cte.common.workflow.annotations.XmlType.class) != null) {
            object = clazz.getAnnotation(commvault.cte.common.workflow.annotations.XmlType.class);
            object2.getAnnotation().getAppInfo().setUserType(object.userType());
        } else {
            object2.getAnnotation().getAppInfo().setUserType(true);
        }
        this.buildComplexMembers((ComplexType)object2, clazz);
        return object2;
    }

    private void buildComplexMembers(ComplexType complexType, Class clazz) throws Exception {
        if (Activity.class.isAssignableFrom(clazz)) {
            Field field2;
            SchemaElement schemaElement = complexType.addElement("inputs");
            ComplexType complexType2 = schemaElement.createComplexType();
            for (Field field2 : this.getInputFields(clazz)) {
                this.buildActivityProperty(complexType2, field2);
            }
            SchemaElement schemaElement2 = complexType.addElement("outputs");
            field2 = schemaElement2.createComplexType();
            for (Field field3 : this.getOutputFields(clazz)) {
                this.buildActivityProperty((ComplexType)field2, field3);
            }
        } else {
            for (Field field : ReflectionUtils.getAccessibleFields(clazz, false)) {
                this.buildNormalProperty(complexType, field);
            }
        }
    }

    private void buildActivityProperty(ComplexType complexType, Field field) throws Exception {
        boolean bl = false;
        String string = "";
        String string2 = "";
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        if (field.getAnnotation(Output.class) != null) {
            string = field.getAnnotation(Output.class).documentation();
        } else if (field.getAnnotation(commvault.cte.common.workflow.annotations.Output.class) != null) {
            string = field.getAnnotation(commvault.cte.common.workflow.annotations.Output.class).documentation();
        }
        if (field.getAnnotation(commvault.cte.workflow.annotations.Input.class) != null) {
            bl = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).required();
            string = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).documentation();
            string2 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).defaultValue();
            bl2 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).autoLink();
            bl3 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).linkDisabled();
            bl4 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).disableList();
            bl5 = field.getAnnotation(commvault.cte.workflow.annotations.Input.class).visible();
        } else if (field.getAnnotation(Input.class) != null) {
            bl = field.getAnnotation(Input.class).required();
            string = field.getAnnotation(Input.class).documentation();
            string2 = field.getAnnotation(Input.class).defaultValue();
            bl2 = field.getAnnotation(Input.class).autoLink();
            bl3 = field.getAnnotation(Input.class).linkDisabled();
            bl4 = field.getAnnotation(Input.class).disableList();
            bl5 = field.getAnnotation(Input.class).visible();
        }
        if (field.getAnnotation(InputOutput.class) != null) {
            bl = field.getAnnotation(InputOutput.class).required();
            string = field.getAnnotation(InputOutput.class).documentation();
            string2 = field.getAnnotation(InputOutput.class).defaultValue();
            bl2 = field.getAnnotation(InputOutput.class).autoLink();
            bl3 = field.getAnnotation(InputOutput.class).linkDisabled();
            bl4 = field.getAnnotation(InputOutput.class).disableList();
            bl5 = field.getAnnotation(InputOutput.class).visible();
        } else if (field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class) != null) {
            bl = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).required();
            string = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).documentation();
            string2 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).defaultValue();
            bl2 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).autoLink();
            bl3 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).linkDisabled();
            bl4 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).disableList();
            bl5 = field.getAnnotation(commvault.cte.common.workflow.annotations.InputOutput.class).visible();
        }
        this.buildProperty(complexType, field, field.getName(), string2, bl, string, bl2, bl3, bl4, bl5);
    }

    private void buildNormalProperty(ComplexType complexType, Field field) throws Exception {
        boolean bl = false;
        String string = "";
        String string2 = "";
        String string3 = field.getName();
        boolean bl2 = false;
        if (field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class) != null) {
            bl = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).required();
            string = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).documentation();
            string2 = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).defaultValue();
            bl2 = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).disableList();
            if (field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).name() != null && field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).name().length() > 0) {
                string3 = field.getAnnotation(commvault.cte.workflow.annotations.XmlField.class).name();
            }
        } else if (field.getAnnotation(XmlField.class) != null) {
            bl = field.getAnnotation(XmlField.class).required();
            string = field.getAnnotation(XmlField.class).documentation();
            string2 = field.getAnnotation(XmlField.class).defaultValue();
            bl2 = field.getAnnotation(XmlField.class).disableList();
            if (field.getAnnotation(XmlField.class).name() != null && field.getAnnotation(XmlField.class).name().length() > 0) {
                string3 = field.getAnnotation(XmlField.class).name();
            }
        }
        this.buildProperty(complexType, field, string3, string2, bl, string, true, false, bl2, true);
    }

    private void buildProperty(ComplexType complexType, Field field, String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        SchemaElement schemaElement = complexType.addElement(string);
        this.buildProperty((SchemaProperty)schemaElement, field.getType(), field.getGenericType());
        if (bl4) {
            schemaElement.setList(false);
        }
        schemaElement.setDefaultValue(string2);
        schemaElement.setRequired(bl);
        schemaElement.getAnnotation().setDocumentation(string3);
        schemaElement.getAnnotation().getAppInfo().setAutoLink(bl2);
        schemaElement.getAnnotation().getAppInfo().setLinkDisabled(bl3);
        schemaElement.getAnnotation().getAppInfo().setVisible(bl5);
    }

    private void buildProperty(SchemaProperty schemaProperty, Class clazz, Type type) throws Exception {
        this.buildProperty(schemaProperty, clazz, type, false);
    }

    private void buildProperty(SchemaProperty schemaProperty, Class clazz, Type type, boolean bl) throws Exception {
        SchemaType schemaType = null;
        boolean bl2 = false;
        if (Collection.class.isAssignableFrom(clazz)) {
            bl = true;
            Type type2 = this.getParameterizedList(type);
            if (type2 instanceof ParameterizedType) {
                this.buildProperty(schemaProperty, (Class)((ParameterizedType)type2).getRawType(), type2, true);
                return;
            }
            clazz = (Class)type2;
        }
        if (clazz.isArray()) {
            bl = true;
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            bl2 = true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (schemaProperty instanceof SchemaElement) {
                this.buildMapType((SchemaElement)schemaProperty, type);
                return;
            }
            throw new Exception("cannot create an attribute of type MAP");
        }
        if (clazz.equals(Object.class) || XML.class.isAssignableFrom(clazz)) {
            schemaType = GenericTypes.ANYTYPE.getType();
        } else if (clazz.equals(String.class)) {
            schemaType = GenericTypes.STRING.getType();
        } else if (clazz.equals(Byte.TYPE)) {
            if (bl) {
                bl = false;
                bl2 = false;
                schemaType = GenericTypes.BASE64BINARY.getType();
            } else {
                schemaType = GenericTypes.BYTE.getType();
            }
        } else {
            schemaType = clazz.equals(Byte.class) ? GenericTypes.BYTE.getType() : (clazz.equals(Date.class) ? GenericTypes.DATE.getType() : (clazz.equals(Calendar.class) ? GenericTypes.DATETIME.getType() : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? GenericTypes.BOOLEAN.getType() : (clazz.equals(Long.class) || clazz.equals(Long.TYPE) ? GenericTypes.LONG.getType() : (clazz.equals(Double.class) || clazz.equals(Double.TYPE) ? GenericTypes.DOUBLE.getType() : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? GenericTypes.INTEGER.getType() : (clazz.equals(Float.class) || clazz.equals(Float.TYPE) ? GenericTypes.FLOAT.getType() : (clazz.equals(Short.class) || clazz.equals(Short.TYPE) ? GenericTypes.SHORT.getType() : (clazz.equals(Character.class) || clazz.equals(Character.TYPE) ? GenericTypes.CHARACTER.getType() : this.buildType(clazz.getSimpleName(), clazz))))))))));
        }
        schemaProperty.setType(schemaType);
        schemaProperty.setList(bl);
        schemaProperty.setRequired(bl2);
    }

    private void buildMapType(SchemaElement schemaElement, Type type) throws Exception {
        Object object;
        Object object2;
        SchemaElement schemaElement2;
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)type;
            schemaElement2 = parameterizedType.getActualTypeArguments();
            object2 = schemaElement2[0];
            object = schemaElement2[1];
        } else {
            object2 = Object.class;
            object = Object.class;
        }
        Object object3 = object2 instanceof ParameterizedType ? (Class)((ParameterizedType)object2).getRawType() : object2;
        Class clazz = object instanceof ParameterizedType ? (Class)((ParameterizedType)object).getRawType() : (Class)object;
        parameterizedType = schemaElement.createComplexType();
        schemaElement2 = parameterizedType.addElement("entry");
        schemaElement2.setList(true);
        schemaElement2.setRequired(false);
        ComplexType complexType = schemaElement2.createComplexType();
        SchemaElement schemaElement3 = complexType.addElement("key");
        this.buildProperty((SchemaProperty)schemaElement3, (Class)object3, (Type)object2);
        SchemaElement schemaElement4 = complexType.addElement("value");
        this.buildProperty((SchemaProperty)schemaElement4, clazz, (Type)object);
    }

    private Type getParameterizedList(Type type) throws Exception {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    private List<Field> getInputFields(Class clazz) {
        List<Field> list = ReflectionUtils.getAccessibleFields(clazz, false);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : list) {
            if (!ReflectionUtils.isInputField(field)) continue;
            arrayList.add(field);
        }
        return arrayList;
    }

    private List<Field> getOutputFields(Class clazz) {
        List<Field> list = ReflectionUtils.getAccessibleFields(clazz, false);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : list) {
            if (!ReflectionUtils.isOutputField(field)) continue;
            arrayList.add(field);
        }
        return arrayList;
    }
}

