/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.queue;

import commvault.cte.workflow.ActivityContext;
import java.util.Calendar;

public class TimedActivity {
    private ActivityContext activity;
    private long jobId;
    private long inTime;
    private int processStepId;
    private boolean resume = false;
    private Integer restartInterval;
    private String uniqueName;

    protected TimedActivity(ActivityContext activityContext, Integer n) {
        this.activity = activityContext;
        this.inTime = Calendar.getInstance().getTimeInMillis() / 1000L;
        this.restartInterval = n;
        this.processStepId = activityContext.getProcessStepId();
        this.jobId = activityContext.getJobId();
        this.uniqueName = activityContext.getUniqueName();
    }

    public ActivityContext getActivity() {
        return this.activity;
    }

    public long getInTime() {
        return this.inTime;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void setResume(boolean bl) {
        this.resume = bl;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public long getJobId() {
        return this.jobId;
    }

    public int getProcessStepId() {
        return this.processStepId;
    }

    public int getRestartInterval() {
        if (this.restartInterval != null) {
            return this.restartInterval;
        }
        return this.activity.getJobSettings().getRestartInterval();
    }
}

