/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.python;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.python.PythonClass;
import commvault.cte.workflow.python.PythonProperty;
import commvault.cte.workflow.python.ScriptTask;
import commvault.cte.workflow.utils.StreamGobbler;
import commvault.tools.python.ExecutionResults;
import commvault.tools.python.PythonUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import workflow.types.EncryptedString;

public abstract class PythonActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(PythonActivity.class);
    @Output
    public Object returnValue;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        Object object;
        ExecutionResults executionResults;
        File file;
        File file2;
        File file3;
        block29: {
            String string;
            int n;
            Object object2;
            block28: {
                String string2;
                Object object3;
                Object object4;
                Object object5;
                String string3;
                if (!activityContext.getContext().isEngineAdmin()) {
                    logger.error(activityContext.getJobId(), "user [" + activityContext.getContext().getUserName() + "] requires administrative access to execute python modules");
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", activityContext.getContext().getUserName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                    activityContext.setFailureReason(evMessageContainer);
                    return AttemptStatus.FAILED;
                }
                try {
                    string3 = this.getScript();
                }
                catch (IOException iOException) {
                    logger.error(activityContext.getJobId(), "failed to build python script", iOException);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_BUILD_SCRIPT", new Object[0]);
                    activityContext.setFailureReason(evMessageContainer);
                    return AttemptStatus.FAILED;
                }
                String string4 = UUID.randomUUID().toString();
                file3 = new File(PythonUtil.getBaseDirectory() + string4 + ".py");
                file2 = new File(PythonUtil.getBaseDirectory() + string4 + ".out");
                file = new File(PythonUtil.getBaseDirectory() + string4 + ".clz");
                try {
                    PythonUtil.writeFile((File)file3, (String)string3);
                    logger.debug(activityContext.getJobId(), String.format("built python script [%s]:", file3.getAbsolutePath()), string3);
                }
                catch (IOException iOException) {
                    logger.error(activityContext.getJobId(), "failed to write python script to file [" + file3.getAbsolutePath() + "]", iOException);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_BUILD_SCRIPT", new Object[0]);
                    activityContext.setFailureReason(evMessageContainer);
                    return AttemptStatus.FAILED;
                }
                if (this.getPythonClass() != null) {
                    try {
                        if (this.getPythonClass().serializedData != null && this.getPythonClass().serializedData.length() > 0) {
                            FileWriter fileWriter = new FileWriter(file);
                            fileWriter.write(this.getPythonClass().serializedData);
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.error(activityContext.getJobId(), "failed to write python class serialization data to file [" + file.getAbsolutePath() + "]", iOException);
                        EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_BUILD_SCRIPT", new Object[0]);
                        activityContext.setFailureReason(evMessageContainer);
                        return AttemptStatus.FAILED;
                    }
                }
                executionResults = new ExecutionResults();
                try {
                    object2 = "python.exe " + file3.getAbsolutePath();
                    logger.info(activityContext.getJobId(), "executing python command [%s]", object2);
                    object = Runtime.getRuntime();
                    object5 = ((Runtime)object).exec((String)object2);
                    object4 = new StreamGobbler(((Process)object5).getErrorStream(), "ERROR");
                    object3 = new StreamGobbler(((Process)object5).getInputStream(), "OUTPUT");
                    ((Thread)object4).start();
                    ((Thread)object3).start();
                    n = ((Process)object5).waitFor();
                    ((Thread)object4).join();
                    ((Thread)object3).join();
                    string2 = ((StreamGobbler)object3).getBuffer().toString();
                    string = ((StreamGobbler)object4).getBuffer().toString();
                }
                catch (IOException iOException) {
                    logger.error(activityContext.getJobId(), "failed to execute python script [" + file3.getAbsolutePath() + "]", iOException);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_EXECUTE_SCRIPT", file3.getAbsolutePath());
                    activityContext.setFailureReason(evMessageContainer);
                    return AttemptStatus.FAILED;
                }
                logger.debug(activityContext.getJobId(), "python command execution output [%s]", string2);
                if (n != 0) break block28;
                try {
                    PythonUtil.populateResults((ExecutionResults)executionResults, (File)file2);
                }
                catch (Exception exception) {
                    logger.error(activityContext.getJobId(), "error retrieving results from python script [" + file3.getAbsolutePath() + "]", exception);
                    object = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_RESULTS", file3.getAbsolutePath());
                    activityContext.setFailureReason((EvMessageContainer)object);
                    return AttemptStatus.FAILED;
                }
                if (this.getPythonClass() != null) {
                    Object object6;
                    if (!file.exists()) {
                        logger.error(activityContext.getJobId(), "python class result file [" + file.getAbsolutePath() + "] does not exist");
                        object2 = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_RESULTS", file.getAbsolutePath());
                        activityContext.setFailureReason((EvMessageContainer)object2);
                        return AttemptStatus.FAILED;
                    }
                    object2 = DocumentBuilderFactory.newInstance();
                    try {
                        object5 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                        object = ((DocumentBuilder)object5).parse(file);
                    }
                    catch (Exception exception) {
                        logger.error(activityContext.getJobId(), "time out occurred executing python script [" + file3.getAbsolutePath() + "]", exception);
                        object4 = EventMessage.getContainer("JM_WORKFLOW_FAILED_PARSE_FILE", file.getAbsolutePath());
                        activityContext.setFailureReason((EvMessageContainer)object4);
                        return AttemptStatus.FAILED;
                    }
                    object5 = PythonUtil.getFirstElementByName((Element)object.getDocumentElement(), (String)"data");
                    object4 = PythonUtil.getChildElements((Node)object5);
                    executionResults.fieldValues = new HashMap();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object6 = (Element)object3.next();
                        String string5 = object6.getAttribute("name");
                        Object object7 = PythonUtil.parseValueElement((Element)object6);
                        executionResults.fieldValues.put(string5, object7);
                    }
                    object3 = PythonUtil.getFirstElementByName((Element)object.getDocumentElement(), (String)"pickle");
                    if (object3 == null) {
                        logger.error(activityContext.getJobId(), "python result file [" + file.getAbsolutePath() + "] is missing serialization element [" + "pickle" + "]");
                        object6 = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_RESULTS", file.getAbsolutePath());
                        activityContext.setFailureReason((EvMessageContainer)object6);
                        return AttemptStatus.FAILED;
                    }
                    executionResults.serializationData = object3.getNodeValue();
                }
                break block29;
            }
            try {
                object = PythonUtil.parsePythonError((String)string);
                logger.error(activityContext.getJobId(), "python script returned failure, value [" + n + "], message [" + (String)object + "]");
                object2 = new EvMessageContainer((String)object);
            }
            catch (IOException iOException) {
                logger.error(activityContext.getJobId(), "python script returned failure value [" + n + "], message [" + string + "]");
                object2 = new EvMessageContainer(iOException.getMessage());
            }
            activityContext.setFailureReason((EvMessageContainer)object2);
            return AttemptStatus.FAILED;
        }
        if (WorkflowRegistry.getInstance().getPythonCleanup() == ScriptTask.DELETE_ALL.toInt() || WorkflowRegistry.getInstance().getPythonCleanup() == ScriptTask.DELETE_SUCCESS.toInt()) {
            if (file3.exists()) {
                file3.delete();
            }
            if (file2.exists()) {
                file2.delete();
            }
            if (file.exists()) {
                file.delete();
            }
        }
        this.returnValue = executionResults.returnObject;
        if (this.getPythonClass() != null) {
            try {
                this.getPythonClass().update(executionResults.fieldValues);
            }
            catch (Exception exception) {
                logger.error(activityContext.getJobId(), "failed to update field in python class [%s]" + this.getPythonClass());
                object = new EvMessageContainer(exception.getMessage());
                activityContext.setFailureReason((EvMessageContainer)object);
                return AttemptStatus.FAILED;
            }
            this.getPythonClass().serializedData = executionResults.serializationData;
        }
        return AttemptStatus.SUCCESS;
    }

    public String getScript() throws IOException {
        String string;
        int n;
        StringBuffer stringBuffer;
        PythonProperty[] pythonPropertyArray;
        String string2 = "_YY_obj";
        String string3 = "_XX_";
        String string4 = "_YY_value";
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("from AutomationUtils import WorkflowUtils\n");
        stringBuffer2.append(String.format("from %s import %s\n", this.getPythonPackage(), this.getPythonModule()));
        stringBuffer2.append("from AutomationUtils import loghelper\n");
        stringBuffer2.append("from AutomationUtils.loghelper import initializeLogger_new, getLog, setLog\n");
        stringBuffer2.append(String.format("logdir, logFile, log = initializeLogger_new(\"%s\")\n", this.getPythonModule()));
        stringBuffer2.append("setLog(log)\n");
        if (this.getPythonClass() != null) {
            if (this.getPythonClass().serializedData == null || this.getPythonClass().serializedData.length() == 0) {
                pythonPropertyArray = this.getPythonClass().getProperties();
                stringBuffer = new StringBuffer();
                for (n = 0; n < pythonPropertyArray.length; ++n) {
                    string = this.getPythonValue(pythonPropertyArray[n].getProperty());
                    String string5 = string3 + pythonPropertyArray[n].getName();
                    stringBuffer2.append(String.format("%s = %s\n", string5, string));
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string5);
                }
                stringBuffer2.append(String.format("%s = %s.%s(%s)\n", string2, this.getPythonClass().getPythonModule(), this.getPythonClass().getClassName(), stringBuffer.toString()));
            } else {
                stringBuffer2.append(String.format("%s = WorkflowUtils.importKlazz(__file__)\n", string2));
            }
        }
        pythonPropertyArray = this.getProperties();
        stringBuffer = new StringBuffer();
        for (n = 0; n < pythonPropertyArray.length; ++n) {
            string = this.getPythonValue(pythonPropertyArray[n].getProperty());
            stringBuffer2.append(String.format("%s = %s\n", pythonPropertyArray[n].getName(), string));
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(pythonPropertyArray[n].getName());
        }
        if (this.getPythonClass() != null) {
            stringBuffer2.append(String.format("%s = %s.%s(%s)\n", string4, string2, this.getPythonMethod(), stringBuffer.toString()));
            stringBuffer2.append(String.format("WorkflowUtils.exportKlazz(__file__,%s)\n", string2));
        } else {
            stringBuffer2.append(String.format("%s = %s.%s(%s)\n", string4, this.getPythonModule(), this.getPythonMethod(), stringBuffer.toString()));
        }
        stringBuffer2.append(String.format("WorkflowUtils.exportvalue(__file__,%s)\n", string4));
        return stringBuffer2.toString();
    }

    public abstract PythonProperty[] getProperties();

    public abstract String getPythonPackage();

    public abstract String getPythonModule();

    public abstract String getPythonMethod();

    public abstract PythonClass getPythonClass();

    public String getPythonValue(Object object) throws IOException {
        if (object instanceof EncryptedString) {
            return "\"" + PythonUtil.escapeString((String)((EncryptedString)object).getEncryptedText()) + "\"";
        }
        return PythonUtil.java2Python((Object)object);
    }
}

