/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.message;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import commvault.cte.workflow.message.WorkflowMessage;
import commvault.msgs.App.WorkflowRequest;
import commvault.msgs.Workflow.InteractiveRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class SocketMessage
implements WorkflowMessage {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SocketMessage.class);
    private static final int ALERT_TIME = WorkflowRegistry.getInstance().getAlertResponseTime();
    private Socket socket;
    private WorkflowRequest request = null;
    private CTEProcessingModel actualRequest = null;
    private int recievedTime = DateUtilities.getNow();
    private Long jobId;

    public SocketMessage(Socket socket) {
        this.socket = socket;
    }

    public void read() throws Exception {
        this.request = (WorkflowRequest)XMLDecoder.decode((InputStream)this.socket.getInputStream(), null);
        this.socket.shutdownInput();
        this.actualRequest = (CTEProcessingModel)XMLDecoder.decode((String)this.request.getXmlRequest());
        if (this.actualRequest instanceof InteractiveRequest) {
            this.jobId = ((InteractiveRequest)this.actualRequest).getJobId();
        }
        if (logger.getLevel().toInt() > LoggerLevel.INFO.toInt()) {
            logger.info("received request message: %s", XMLEncoder.encode((Object)this.request));
        }
    }

    @Override
    public synchronized boolean setResponse(CTEProcessingModel cTEProcessingModel) {
        if (this.writeable()) {
            try {
                int n;
                if (logger.getLevel().toInt() > LoggerLevel.INFO.toInt()) {
                    try {
                        logger.info("sending response message: %s", XMLEncoder.encode((Object)cTEProcessingModel));
                    }
                    catch (Exception exception) {
                        logger.error("failed to serialize response message [%s] " + cTEProcessingModel.getClass().getName());
                    }
                }
                if ((n = DateUtilities.getNow() - this.recievedTime) >= ALERT_TIME) {
                    logger.info(this.jobId, "user response time=[%s] seconds", n);
                }
                XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(this.socket.getOutputStream());
                XMLEncoder.encode((Object)cTEProcessingModel, (XMLStreamWriter)xMLStreamWriter);
                xMLStreamWriter.close();
                this.socket.shutdownOutput();
                return true;
            }
            catch (Exception exception) {
                logger.error("failed to respond to socket with message type " + cTEProcessingModel.getClass().getName(), exception);
            }
        } else {
            logger.debug("cannot send response as socket is not writable");
        }
        this.close();
        this.notifyAll();
        return false;
    }

    private void close() {
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                logger.error("failed to close socket", iOException);
            }
        }
    }

    @Override
    public CTEProcessingModel getRequest() throws Exception {
        return this.actualRequest;
    }

    @Override
    public void setProcessing() {
    }

    @Override
    public int getUserId() {
        return this.request.getProcessingInstructionInfo().getUser().getUserId();
    }

    public int getTimeOut() {
        if (this.request.getTimeout() > 0) {
            return this.request.getTimeout();
        }
        return 2;
    }

    public boolean writeable() {
        return !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isOutputShutdown();
    }
}

