/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.message;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.BreakpointHandler;
import commvault.cte.workflow.message.CheckEngineHandler;
import commvault.cte.workflow.message.DataAgingHandler;
import commvault.cte.workflow.message.DebugSetActivityHandler;
import commvault.cte.workflow.message.DeployRequestHandler;
import commvault.cte.workflow.message.GetExecutionHandler;
import commvault.cte.workflow.message.GetInputFormHandler;
import commvault.cte.workflow.message.GetOnDemandInputFormHandler;
import commvault.cte.workflow.message.ImportActivitiesHandler;
import commvault.cte.workflow.message.ImportSOAPRequestHandler;
import commvault.cte.workflow.message.InteractionRequestHandler;
import commvault.cte.workflow.message.InteractiveHandler;
import commvault.cte.workflow.message.JobControlHandler;
import commvault.cte.workflow.message.ModifyDebugJobHandler;
import commvault.cte.workflow.message.ModifyVersionRequestHandler;
import commvault.cte.workflow.message.OnDemandHandler;
import commvault.cte.workflow.message.RefreshLocationRequestHandler;
import commvault.cte.workflow.message.RemoveLocationRequestHandler;
import commvault.cte.workflow.message.RequestHandler;
import commvault.cte.workflow.message.SetCurrentActivityHandler;
import commvault.cte.workflow.message.SetExecutionHandler;
import commvault.cte.workflow.message.SetWorkflowVariablesHandler;
import commvault.cte.workflow.message.StartRequestHandler;
import commvault.cte.workflow.message.WorkflowMessage;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.GenericResp;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.CheckEngineRequest;
import commvault.msgs.Workflow.DebugBreakpointRequest;
import commvault.msgs.Workflow.DebugGenericResp;
import commvault.msgs.Workflow.DebugSetActivityRequest;
import commvault.msgs.Workflow.DeployWorkflow;
import commvault.msgs.Workflow.GetOnDemandWorkflowInputsReq;
import commvault.msgs.Workflow.GetWorkflowExecutionReq;
import commvault.msgs.Workflow.GetWorkflowInputsReq;
import commvault.msgs.Workflow.ImportActivities;
import commvault.msgs.Workflow.ImportSOAPService;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.InteractiveResponse;
import commvault.msgs.Workflow.ModifyOnDemandRequest;
import commvault.msgs.Workflow.ModifyVersionReq;
import commvault.msgs.Workflow.OnDemandWorkflow;
import commvault.msgs.Workflow.OutputFormat;
import commvault.msgs.Workflow.RefreshSchemaLocationRequest;
import commvault.msgs.Workflow.RemoveSchemaLocationRequest;
import commvault.msgs.Workflow.SetCurrentStepReq;
import commvault.msgs.Workflow.SetWebFormInteractionRequest;
import commvault.msgs.Workflow.SetWorkflowExecutionReq;
import commvault.msgs.Workflow.SetWorkflowVariablesReq;
import commvault.msgs.Workflow.StartDataAging;
import commvault.msgs.Workflow.StartWorkflow;
import commvault.msgs.Workflow.WorkflowCompletionResponse;
import commvault.msgs.Workflow.WorkflowJobControl;
import commvault.msgs.Workflow.WorkflowRequest;
import commvault.msgs.Workflow.WorkflowResponse;
import java.util.HashMap;
import java.util.Map;

public class RequestManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RequestManager.class);
    private static RequestManager instance = new RequestManager();
    private Map<Class<? extends WorkflowRequest>, RequestHandler> handlers = new HashMap<Class<? extends WorkflowRequest>, RequestHandler>();

    public static RequestManager getInstance() {
        return instance;
    }

    private RequestManager() {
        this.handlers.put(StartWorkflow.class, new StartRequestHandler());
        this.handlers.put(CheckEngineRequest.class, new CheckEngineHandler());
        this.handlers.put(DeployWorkflow.class, new DeployRequestHandler());
        this.handlers.put(GetWorkflowExecutionReq.class, new GetExecutionHandler());
        this.handlers.put(ImportActivities.class, new ImportActivitiesHandler());
        this.handlers.put(ImportSOAPService.class, new ImportSOAPRequestHandler());
        this.handlers.put(WorkflowJobControl.class, new JobControlHandler());
        this.handlers.put(RefreshSchemaLocationRequest.class, new RefreshLocationRequestHandler());
        this.handlers.put(RemoveSchemaLocationRequest.class, new RemoveLocationRequestHandler());
        this.handlers.put(SetWorkflowExecutionReq.class, new SetExecutionHandler());
        this.handlers.put(SetWorkflowVariablesReq.class, new SetWorkflowVariablesHandler());
        this.handlers.put(ModifyVersionReq.class, new ModifyVersionRequestHandler());
        this.handlers.put(OnDemandWorkflow.class, new OnDemandHandler());
        this.handlers.put(DebugBreakpointRequest.class, new BreakpointHandler());
        this.handlers.put(DebugSetActivityRequest.class, new DebugSetActivityHandler());
        this.handlers.put(SetCurrentStepReq.class, new SetCurrentActivityHandler());
        this.handlers.put(ModifyOnDemandRequest.class, new ModifyDebugJobHandler());
        this.handlers.put(GetWorkflowInputsReq.class, new GetInputFormHandler());
        this.handlers.put(GetOnDemandWorkflowInputsReq.class, new GetOnDemandInputFormHandler());
        this.handlers.put(StartDataAging.class, new DataAgingHandler());
    }

    public static GenericResp getGenericResponse() {
        return RequestManager.getGenericResponse(0, "Success");
    }

    public static GenericResp getGenericResponse(EvMessageContainer evMessageContainer, int n) {
        return RequestManager.getGenericResponse(evMessageContainer.getErrorCode(), EventMessage.getInstance().formatMessage(evMessageContainer, n));
    }

    public static DebugGenericResp getDebugGenericResponse(EvMessageContainer evMessageContainer, int n, WorkflowContext workflowContext) {
        return RequestManager.getDebugGenericResponse(evMessageContainer.getErrorCode(), EventMessage.getInstance().formatMessage(evMessageContainer, n), workflowContext);
    }

    public static GenericResp getGenericResponse(int n, String string) {
        GenericResp genericResp = new GenericResp();
        genericResp.setErrorCode(n);
        genericResp.setErrorMessage(string);
        return genericResp;
    }

    public static DebugGenericResp getDebugGenericResponse(int n, String string, WorkflowContext workflowContext) {
        DebugGenericResp debugGenericResp = new DebugGenericResp();
        debugGenericResp.setErrorCode(n);
        debugGenericResp.setErrorMessage(string);
        RequestManager.populateInteractiveResponse((InteractiveResponse)debugGenericResp, workflowContext);
        return debugGenericResp;
    }

    public static WorkflowCompletionResponse buildCompletionResponse(WorkflowProcess workflowProcess) {
        WorkflowCompletionResponse workflowCompletionResponse = new WorkflowCompletionResponse();
        workflowCompletionResponse.getWorkflow().setWorkflowId(workflowProcess.getWorkflowId());
        workflowCompletionResponse.getWorkflow().setWorkflowName(workflowProcess.getWorkflowName());
        workflowCompletionResponse.setVersion(workflowProcess.getVersion());
        workflowCompletionResponse.setStatus(workflowProcess.getStatus().toInt());
        workflowCompletionResponse.setStartTime((int)(workflowProcess.getStartTime().getTime() / 1000L));
        if (workflowProcess.getEndTime() != null) {
            workflowCompletionResponse.setEndTime((int)(workflowProcess.getEndTime().getTime() / 1000L));
        } else {
            workflowCompletionResponse.setEndTime(DateUtilities.getNow());
        }
        if (workflowProcess.getOutputFormat() == OutputFormat.XML) {
            if (workflowProcess.getOutputs() != null && workflowProcess.getOutputs().length() > 0) {
                try {
                    WorkflowElement workflowElement = WorkflowElement.parse(workflowProcess.getOutputs());
                    WorkflowUtils.removeSystemAttributes(workflowElement);
                    workflowCompletionResponse.setOutputs(workflowElement.toString());
                }
                catch (EvFailureException evFailureException) {
                    logger.warn("failed to set outputs in completion response");
                }
            }
        } else {
            workflowCompletionResponse.setOutputs(workflowProcess.getOutputs());
        }
        if (workflowProcess.getStatus() == ProcessStatus.COMPLETED) {
            workflowCompletionResponse.setErrorCode(0);
            workflowCompletionResponse.setErrorMessage("");
        } else {
            workflowCompletionResponse.setErrorCode(workflowProcess.getStatus().toInt());
            if (workflowProcess.getLastFailure() != null) {
                workflowCompletionResponse.setErrorMessage(EventMessage.getInstance().formatMessage(workflowProcess.getLastFailure().getMessageContainer(), 0));
            }
        }
        RequestManager.populateWorkflowResponse((WorkflowResponse)workflowCompletionResponse, workflowProcess);
        return workflowCompletionResponse;
    }

    public static void populateInteractiveResponse(InteractiveResponse interactiveResponse, WorkflowContext workflowContext) {
        interactiveResponse.getWorkflow().setWorkflowId(workflowContext.getWorkflowId());
        interactiveResponse.getWorkflow().setWorkflowName(workflowContext.getWorkflowName());
        interactiveResponse.setClient(WorkflowProperties.getInstance().getClient());
        interactiveResponse.setCommCell(WorkflowProperties.getInstance().getCommCell());
        if (workflowContext.getProcessStepId() != null) {
            interactiveResponse.setProcessStepId(workflowContext.getProcessStepId().intValue());
        }
        interactiveResponse.setSessionId(workflowContext.getSessionId());
        RequestManager.populateWorkflowResponse((WorkflowResponse)interactiveResponse, workflowContext);
    }

    public static void populateWorkflowResponse(WorkflowResponse workflowResponse, WorkflowContext workflowContext) {
        workflowResponse.setJobId(workflowContext.getJobId());
        workflowResponse.setContextId(workflowContext.getProcessId());
    }

    private RequestHandler getHandler(WorkflowRequest workflowRequest) {
        if (workflowRequest instanceof InteractiveRequest) {
            if (workflowRequest instanceof SetWebFormInteractionRequest && ((InteractiveRequest)workflowRequest).getSessionId().length() == 0) {
                return new InteractionRequestHandler();
            }
            return new InteractiveHandler();
        }
        return this.handlers.get(workflowRequest.getClass());
    }

    public void handle(WorkflowMessage workflowMessage) {
        RequestHandler requestHandler;
        CTEProcessingModel cTEProcessingModel;
        try {
            cTEProcessingModel = workflowMessage.getRequest();
        }
        catch (Exception exception) {
            logger.error("error decoding message", exception);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_INITIALIZE_REQUEST", new Object[0]);
            workflowMessage.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(evMessageContainer, 0));
            return;
        }
        if (!(cTEProcessingModel instanceof WorkflowRequest)) {
            logger.error("request object [" + cTEProcessingModel.getClass() + "] not a valid workflow request");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_INITIALIZE_REQUEST", new Object[0]);
            workflowMessage.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(evMessageContainer, 0));
            return;
        }
        WorkflowRequest workflowRequest = (WorkflowRequest)cTEProcessingModel;
        int n = workflowRequest.getProcessingInstructionInfo().getLocale().getLocaleId();
        if (workflowRequest.getProcessingInstructionInfo().getUser().getUserId() == 0 && workflowMessage.getUserId() > 0) {
            logger.debug("did not find user id in processing instruction information, setting it from WF_MessageQuery row");
            workflowRequest.getProcessingInstructionInfo().getUser().setUserId(workflowMessage.getUserId());
        }
        if ((requestHandler = this.getHandler(workflowRequest)) == null) {
            String string = String.format("request [%s] not implemented", workflowRequest.getClass().getName());
            logger.error(string);
            workflowMessage.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(-1, string));
            return;
        }
        UserEntity userEntity = this.getRequester(workflowRequest);
        workflowRequest.getProcessingInstructionInfo().setUser(userEntity);
        workflowMessage.setProcessing();
        try {
            requestHandler.handle(workflowRequest, workflowMessage);
        }
        catch (EvFailureException evFailureException) {
            evFailureException.setLocaleId(n);
            workflowMessage.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(evFailureException.getMessageContainer(), n));
        }
    }

    private UserEntity getRequester(WorkflowRequest workflowRequest) {
        UserEntity userEntity = new UserEntity();
        String string = null;
        if (workflowRequest.getProcessingInstructionInfo().getUser().getUserId() > 0) {
            logger.debug("using user id [%s] from ProcessingInstructionInfo of the message", workflowRequest.getProcessingInstructionInfo().getUser().getUserId());
            string = String.format("id = %s", workflowRequest.getProcessingInstructionInfo().getUser().getUserId());
        } else if (workflowRequest.getSubmittedBy().getUserId() > 0) {
            logger.debug("using user id [%s] from submitted by property of the message", workflowRequest.getSubmittedBy().getUserId());
            string = String.format("id = %s", workflowRequest.getSubmittedBy().getUserId());
        } else {
            logger.warn("no user information was recieved with request");
            userEntity.setUserId(0);
            userEntity.setUserName("Unknown");
            return userEntity;
        }
        UMUsers_t uMUsers_t = new UMUsers_t();
        try {
            if (uMUsers_t.fill(string)) {
                userEntity.setUserId(uMUsers_t.id.get().intValue());
                userEntity.setUserName(uMUsers_t.login.get());
                return userEntity;
            }
            logger.error("could not retrieve user information using where clause [" + string + "]");
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to read UMUsers table", cTEDBException);
        }
        userEntity.setUserId(0);
        userEntity.setUserName("Unknown");
        return userEntity;
    }
}

