/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.message;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.AsyncWorkflowResponse;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestHandler;
import commvault.cte.workflow.message.RequestManager;
import commvault.msgs.Workflow.RemoveSchemaLocationRequest;
import commvault.msgs.Workflow.WorkflowRequest;

public class RemoveLocationRequestHandler
implements RequestHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RemoveLocationRequestHandler.class);

    private CTEProcessingModel handle(WorkflowRequest workflowRequest) throws EvFailureException {
        RemoveSchemaLocationRequest removeSchemaLocationRequest = (RemoveSchemaLocationRequest)workflowRequest;
        logger.info("removing imported location [%s]", removeSchemaLocationRequest.getSchemaLocation().getSchemaLocationUrl());
        try {
            WF_SchemaLocation_t wF_SchemaLocation_t = new WF_SchemaLocation_t();
            String string = String.format("LocationId = %s", removeSchemaLocationRequest.getSchemaLocation().getSchemaLocationId());
            if (wF_SchemaLocation_t.fill(string)) {
                wF_SchemaLocation_t.delete();
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error removing import location id [" + removeSchemaLocationRequest.getSchemaLocation().getSchemaLocationId() + "]", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_REMOVE_IMPORT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        return RequestManager.getGenericResponse();
    }

    @Override
    public void handle(WorkflowRequest workflowRequest, AsyncWorkflowResponse asyncWorkflowResponse) throws EvFailureException {
        asyncWorkflowResponse.setResponse(this.handle(workflowRequest));
    }
}

