/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.logger;

import commvault.cte.workflow.logger.HeaderProperty;
import commvault.cte.workflow.logger.LoggerFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class CVFileHandler
implements LoggerFile {
    private static final String WHITE_SPACE = " ";
    static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final String EXTENSION = ".log";
    private static final String ROTATE_DATE_FORMAT = "yyyy'_'MM'_'dd'_'HH'_'mm'_'ss";
    private String ROTATE_FORMAT = "%s_%s.log";
    private volatile int limit;
    private volatile int count;
    private String fileName;
    private List<File> rotatedLogs = new ArrayList<File>();
    private SimpleDateFormat rotateFormat = new SimpleDateFormat("yyyy'_'MM'_'dd'_'HH'_'mm'_'ss");
    private List<HeaderProperty> headerProperties;
    private MeteredStream stream;
    private OutputStreamWriter writer;
    private static Comparator<File> logFileComparator = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return new Long(file.lastModified()).compareTo(file2.lastModified());
        }
    };

    public CVFileHandler(String string, int n, int n2, boolean bl, List<HeaderProperty> list) {
        if (n < 0 || n2 < 1 || string.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.headerProperties = list;
        this.fileName = string;
        this.limit = n;
        this.count = n2;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getLogFile() {
        return new File(this.getFileName() + EXTENSION);
    }

    private void writeFileHeader() throws IOException {
        int n = -1;
        int n2 = -1;
        for (HeaderProperty headerProperty : this.headerProperties) {
            if (headerProperty.isDate()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                headerProperty.value = simpleDateFormat.format(Calendar.getInstance().getTime());
            }
            if (headerProperty.getColumnName().length() > n) {
                n = headerProperty.getColumnName().length();
            }
            if (headerProperty.getValue().length() <= n2) continue;
            n2 = headerProperty.getValue().length();
        }
        this.repeat(this.writer, "*", n + n2 + 7);
        this.writer.write(LINE_SEPERATOR);
        for (HeaderProperty headerProperty : this.headerProperties) {
            this.writer.write("* ");
            this.writer.write(headerProperty.getColumnName());
            this.repeat(this.writer, WHITE_SPACE, n - headerProperty.getColumnName().length() + 1);
            this.writer.write(": ");
            this.writer.write(headerProperty.getValue());
            this.repeat(this.writer, WHITE_SPACE, n2 - headerProperty.getValue().length() + 1);
            this.writer.write("*");
            this.writer.write(LINE_SEPERATOR);
        }
        this.repeat(this.writer, "*", n + n2 + 7);
        this.writer.write(LINE_SEPERATOR);
        this.writer.write(LINE_SEPERATOR);
        this.writer.flush();
    }

    public void repeat(OutputStreamWriter outputStreamWriter, String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            outputStreamWriter.write(string);
        }
    }

    private void open() throws IOException {
        File file = this.getLogFile();
        boolean bl = !file.exists();
        this.stream = new MeteredStream(new FileOutputStream(file.toString(), true), file.length());
        this.writer = new OutputStreamWriter((OutputStream)this.stream, "UTF-8");
        if (bl) {
            this.writeFileHeader();
        }
    }

    public void openFiles() throws IOException {
        File[] fileArray;
        final File file = new File(this.getFileName());
        for (File file2 : fileArray = file.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file2) {
                return file2.getName().toLowerCase().startsWith(file.getName().toLowerCase()) && file2.getName().toLowerCase().endsWith(CVFileHandler.EXTENSION.toLowerCase()) && !file2.equals(CVFileHandler.this.getLogFile());
            }
        })) {
            this.rotatedLogs.add(file2);
        }
        Collections.sort(this.rotatedLogs, logFileComparator);
        this.open();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.stream.close();
        this.stream = null;
    }

    public synchronized void rotate() throws Exception {
        String string = String.format(this.ROTATE_FORMAT, this.getFileName(), this.rotateFormat.format(new Date()));
        File file = new File(string);
        if (this.getLogFile().renameTo(file)) {
            this.rotatedLogs.add(file);
        }
        while (this.rotatedLogs.size() > this.getCount()) {
            File file2 = this.rotatedLogs.get(0);
            file2.delete();
            this.rotatedLogs.remove(file2);
        }
        this.open();
    }

    @Override
    public synchronized void publish(String string) throws Exception {
        if (this.stream == null) {
            this.open();
        }
        this.writer.write(string);
        this.writer.flush();
        if (this.stream.written >= (long)this.getLimit()) {
            this.close();
            this.rotate();
        }
    }

    private static class MeteredStream
    extends OutputStream {
        OutputStream out;
        long written;

        private MeteredStream(OutputStream outputStream, long l) {
            this.out = outputStream;
            this.written = l;
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.written;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
            this.written += (long)byArray.length;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.written += (long)n2;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

