/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.logger;

import commvault.cte.workflow.logger.CTERecord;
import commvault.cte.workflow.logger.ColumnFormatter;
import commvault.cte.workflow.logger.LoggerLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.SimpleFormatter;

public class CTEDebugFormat
extends SimpleFormatter {
    private static final String SPACE_CHAR = " ";
    private static final char LEFT_BRAKET = '[';
    private static final char RIGHT_BRAKET = ']';
    private static final String SUB_PROCESS = "->";
    static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final int MAX_MESSAGE_LENGTH = 32768;
    private final ColumnFormatter fThread = new ColumnFormatter();
    private final ColumnFormatter fFunction = new ColumnFormatter(24);

    public synchronized String format(CTERecord cTERecord) {
        return this.format(cTERecord, LINE_SEPERATOR);
    }

    public synchronized String format(CTERecord cTERecord, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (cTERecord.getThrown() == null) {
            stringBuffer.append(this.fThread.format(cTERecord.getThreadId()));
            stringBuffer.append(SPACE_CHAR);
            if (cTERecord.getLocation() == null) {
                stringBuffer.append(this.fFunction.format("###"));
            } else {
                stringBuffer.append(this.fFunction.format(cTERecord.getLocation()));
            }
            stringBuffer.append(":");
            stringBuffer.append(SPACE_CHAR);
            if (cTERecord.getProcessList() != null && cTERecord.getProcessList().size() > 0) {
                stringBuffer.append('[');
                for (int i = 0; i < cTERecord.getProcessList().size(); ++i) {
                    if (i > 0) {
                        stringBuffer.append(SUB_PROCESS);
                    }
                    stringBuffer.append(cTERecord.getProcessList().get(i));
                }
                stringBuffer.append(']');
                stringBuffer.append(SPACE_CHAR);
            }
            if (cTERecord.getLoggerLevel() == LoggerLevel.WARNING || cTERecord.getLoggerLevel() == LoggerLevel.ERROR) {
                stringBuffer.append(cTERecord.getLevel().getName());
                stringBuffer.append(":");
                stringBuffer.append(SPACE_CHAR);
            }
            if (cTERecord.getMessage().length() > 32768) {
                stringBuffer.append(cTERecord.getMessage().substring(0, 32768));
            } else {
                stringBuffer.append(cTERecord.getMessage());
            }
            stringBuffer.append(string);
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            cTERecord.getThrown().printStackTrace(printWriter);
            stringBuffer.append(stringWriter.toString()).append(string);
        }
        return stringBuffer.toString();
    }
}

