/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activity.XMLOutput;
import commvault.cte.workflow.dom.OutputElement;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;

public class RetrieveOutputs
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RetrieveOutputs.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        OutputElement outputElement = null;
        if (activityContext.getActivity() instanceof XMLOutput) {
            String string = ((XMLOutput)((Object)activityContext.getActivity())).getOutputs();
            logger.debug(activityContext.getJobId(), "retrieved xml outputs from XMLActivity [%s]", string);
            if (string != null && string.length() > 0) {
                logger.trace(activityContext.getJobId(), "localizing xml");
                try {
                    outputElement = OutputElement.parse(string);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(activityContext.getJobId(), "failed to parse xml from activity outputs");
                    activityContext.setFailureReason(evFailureException.getMessageContainer());
                    activityContext.setStatus(ProcessStatus.PENDING);
                    return;
                }
                outputElement.setName(activityContext.getUniqueName());
            }
        }
        if (outputElement == null) {
            outputElement = new OutputElement(activityContext.getUniqueName());
            try {
                activityContext.getMarshaller().marshal(activityContext.getActivity(), outputElement);
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error retriving activity outputs", evFailureException);
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
        }
        activityContext.setActivityOutputs(outputElement);
        logger.debug(activityContext.getJobId(), "activity completed with outputs [%s]", outputElement);
    }
}

