/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.FieldType;

public class ProcessOnEnter
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ProcessOnEnter.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getOnEnter() != null && activityContext.getOnEnter().getScript().length() > 0) {
            logger.info(activityContext.getJobId(), "processing onEnter script [%s]", activityContext.getOnEnter().getScript());
            try {
                activityContext.getEvaluator().evaluate(activityContext.getOnEnter());
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error evaluating onEnter script");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            WorkflowElement workflowElement = new WorkflowElement("inputs");
            try {
                activityContext.getMarshaller().marshal(activityContext.getActivity(), workflowElement, FieldType.INPUTS);
                activityContext.setActivityInputs(workflowElement);
            }
            catch (EvFailureException evFailureException) {
                logger.error(activityContext.getJobId(), "error retrieving inputs after on-start script", evFailureException);
            }
        }
    }
}

