/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.handler;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.logger.CTELogger;

public class ExecuteActivity
implements ProcessHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExecuteActivity.class);

    @Override
    public void executeHandler(ActivityContext activityContext) throws InterruptedException {
        if (activityContext.getStatus() != ProcessStatus.RUNNING) {
            logger.info(activityContext.getJobId(), "skipping execution because it has a status of [%s]", activityContext.getStatus().toString());
            return;
        }
        if (activityContext.getStatus() == ProcessStatus.RUNNING) {
            logger.debug(activityContext.getJobId(), "begin calling execute() funtion in class [%s]", activityContext.getActivity().getClass().getName());
            AttemptStatus attemptStatus = activityContext.getActivity().execute(activityContext);
            logger.debug(activityContext.getJobId(), "finished calling execute() function in class [%s]", activityContext.getActivity().getClass().getName());
            if (attemptStatus == AttemptStatus.FAILED) {
                if (activityContext.getStatus() == ProcessStatus.RUNNING || activityContext.getStatus() == ProcessStatus.SUSPEND_PENDING || activityContext.getStatus() == ProcessStatus.WAITING) {
                    logger.warn(activityContext.getJobId(), "execution of activity returned a status of [FAILED]");
                    activityContext.setStatus(ProcessStatus.PENDING);
                } else {
                    logger.warn(activityContext.getJobId(), "execution of activity returned a status of [FAILED] but activity already has a status of [%s]", activityContext.getStatus());
                }
            }
        }
    }
}

