/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.executor;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.executor.AttemptExecutor;
import commvault.cte.workflow.executor.StepExecutor;
import commvault.cte.workflow.logger.CTELogger;
import java.util.Calendar;

public class RestartExecutor
extends StepExecutor {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(AttemptExecutor.class);

    public RestartExecutor(ActivityContext activityContext, ProcessManager processManager) {
        super(activityContext, processManager, null);
    }

    public RestartExecutor(ActivityContext activityContext, ProcessManager processManager, WorkflowThread workflowThread) {
        super(activityContext, processManager, workflowThread);
    }

    @Override
    protected void execute() {
        this.activity.setCurrentPhase(0);
        this.activity.setAttemptCount(this.activity.getAttemptCount() + 1);
        this.activity.setAttemptStart(Calendar.getInstance().getTimeInMillis());
        this.activity.setRestarts(this.activity.getRestarts() + 1);
        logger.debug(this.activity.getJobId(), "restarting activity, number [%s] of [%s]", this.activity.getRestarts(), this.activity.getMaxRestarts());
        super.execute();
    }
}

