/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.workflow;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.events.WorkflowEndHandler;
import commvault.cte.workflow.logger.CTELogger;
import java.io.File;
import java.util.HashSet;
import java.util.List;

public class UploadCleanup
implements WorkflowEndHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UploadCleanup.class);

    @Override
    public void onWorkflowEnd(WorkflowProcess workflowProcess) {
        List<String> list;
        logger.trace(workflowProcess.getJobId(), "checking for any upload files to cleanup");
        try {
            list = workflowProcess.getWorkflowExecution().getUploadedFiles();
        }
        catch (EvFailureException evFailureException) {
            logger.warn(workflowProcess.getJobId(), "failed to cleanup uploaded files");
            return;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (String object : list) {
            if (object == null || object.length() <= 0) continue;
            File file = new File(object);
            if (file.exists()) {
                hashSet.add(file.getParentFile());
                if (file.delete()) {
                    logger.debug(workflowProcess.getJobId(), "uploaded file [%s] successfully removed", file.getAbsolutePath());
                    continue;
                }
                logger.warn(workflowProcess.getJobId(), "could not remove uploaded file [%s]", file.getAbsolutePath());
                continue;
            }
            logger.debug(workflowProcess.getJobId(), "uploaded file [%s] does not exist or has already been removed", file.getAbsolutePath());
        }
        for (File file : hashSet) {
            if (!file.exists()) continue;
            if (file.isDirectory() && file.listFiles().length == 0) {
                logger.debug(workflowProcess.getJobId(), "removing upload base folder [%s]", file.getAbsolutePath());
                file.delete();
                continue;
            }
            logger.debug(workflowProcess.getJobId(), "could not remove uploaded base folder [%s] since there are files underneath it", file.getAbsolutePath());
        }
    }
}

