/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.SecurityToken;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.db.engine.WF_Token_t;
import commvault.cte.workflow.events.WorkflowEndHandler;
import commvault.cte.workflow.events.WorkflowStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class TokenSecurity
implements WorkflowStartHandler,
WorkflowEndHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(TokenSecurity.class);

    @Override
    public void onWorkflowStart(WorkflowProcess workflowProcess) {
        try {
            workflowProcess.impersonateExecutor();
        }
        catch (EvFailureException evFailureException) {
            logger.error(workflowProcess.getJobId(), "failed to login executor [" + workflowProcess.getExecutor() + "]");
            workflowProcess.setFailureReason(evFailureException.getMessageContainer());
            workflowProcess.setStatus(ProcessStatus.FAILED);
        }
    }

    @Override
    public void onWorkflowEnd(WorkflowProcess workflowProcess) {
        List<WF_Token_t> list = null;
        try {
            list = workflowProcess.getDataAccess().getTokens(workflowProcess.getJobId(), workflowProcess.getCommCellId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowProcess.getJobId(), "failed to retrieve tokens for job", cTEDBException);
            return;
        }
        if (list.size() == 0) {
            logger.debug(workflowProcess.getJobId(), "no logged in tokens found for job");
            return;
        }
        for (WF_Token_t wF_Token_t : list) {
            logger.debug(workflowProcess.getJobId(), "logging out user token [%s]", wF_Token_t.userName.get());
            SecurityToken.logout(wF_Token_t);
        }
    }
}

