/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.SchemaWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UpdateConfigForm
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(UpdateConfigForm.class);

    @Override
    public void onEngineStart() {
        ThreadManager.getInstance().execute(new UpdateTask());
    }

    private static class UpdateTask
    implements Runnable {
        private UpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<Integer> list = this.getWorkflowsWithConfiguration();
            if (list.size() == 0) {
                return;
            }
            String string = StringUtils.join(list, (String)",");
            try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
                PreparedStatement preparedStatement = cTEDBReservation.createStatement("Select d.DeployId, d.WorkflowId, d.InputSchema FROM (Select d.DeployId, d.WorkflowId, d.InputSchema, d.ConfigForm From WF_Deploy d INNER JOIN (select WorkflowId, Max(Version) As Version from WF_Deploy Group by WorkflowId) a ON d.WorkflowId = a.WorkflowId AND d.Version = a.Version Where clientId = 2) d Where d.WorkflowId in (select data from dbo.split(?, ',')) AND d.ConfigForm IS NULL");
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt("DeployId");
                    try {
                        this.updateConfigForm(resultSet.getInt("DeployId"), resultSet.getInt("WorkflowId"), resultSet.getString("InputSchema"));
                    }
                    catch (Exception exception) {
                        logger.error("failed to update config form deploy id [" + n + "]", exception);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfigForm(int n, int n2, String string) throws Exception {
            SchemaWrapper schemaWrapper = (SchemaWrapper)XMLDecoder.decode((String)string, (Object)new SchemaWrapper());
            InputForm inputForm = WorkflowUtils.buildConfigForm(schemaWrapper);
            String string2 = WorkflowUtils.encodeMessageAsString(inputForm, "configForm");
            String string3 = "Update WF_Deploy Set ConfigForm = ? Where DeployId = ?";
            try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
                PreparedStatement preparedStatement = cTEDBReservation.createStatement(string3);
                preparedStatement.setString(1, string2);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Integer> getWorkflowsWithConfiguration() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
                PreparedStatement preparedStatement = cTEDBReservation.createStatement("Select d.WorkflowId From WF_Deployments d INNER JOIN (Select Max(DeploymentId) As DeploymentId, WorkflowId From WF_Deployments Group By WorkflowId) m ON d.DeploymentId = m.DeploymentId Where d.Configuration <> '<configuration />'");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getInt(1));
                }
            }
            return arrayList;
        }
    }
}

