/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EngineProperties;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.db.cs.WF_Definition_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class RedeploymentCheck
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RedeploymentCheck.class);

    @Override
    public void onEngineStart() {
        List<WF_Definition_t> list;
        Integer n = EngineProperties.getInstance().getReDeployment();
        if (n == null) {
            EngineProperties.getInstance().setReDeployment(0);
            return;
        }
        if (n == 0) {
            return;
        }
        logger.info("redeploying the latest deployed version of all workflows");
        try {
            list = WF_Definition_t.select();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve workflows from WF_Definition table", cTEDBException);
            return;
        }
        for (WF_Definition_t wF_Definition_t : list) {
            WF_Deployments_t wF_Deployments_t;
            block10: {
                wF_Deployments_t = new WF_Deployments_t();
                String string = String.format("WorkflowId = %s", wF_Definition_t.WorkflowId.get());
                try {
                    if (!wF_Deployments_t.fill(string, "DeploymentId DESC")) {
                        logger.debug("no deployment information found for workflow [%s]", wF_Definition_t.Name.get());
                    }
                    break block10;
                }
                catch (CTEDBException cTEDBException) {
                    logger.error("failed to retrieve WF_Deployments record for workflow id [" + wF_Definition_t.WorkflowId.get() + "]", cTEDBException);
                }
                continue;
            }
            try {
                DeploymentManager.redeploy(wF_Deployments_t);
            }
            catch (EvFailureException evFailureException) {
                logger.error("failed to re-deploy workflow [" + wF_Definition_t.Name.get() + "], deploymentId [" + wF_Deployments_t.DeploymentId.get() + "]");
            }
        }
        EngineProperties.getInstance().setReDeployment(0);
    }
}

