/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.workflow.JobManager;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.JMAdminJobInfoTable_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class CheckStaleJobs
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CheckStaleJobs.class);

    @Override
    public void onEngineStart() {
        if (WorkflowRegistry.getInstance().isEnableStateJobCheck()) {
            try {
                this.doWork();
            }
            catch (Throwable throwable) {
                logger.error("failed to check for stale jobs", throwable);
            }
        }
    }

    private String getCurrentJobs() throws Exception {
        List<WF_Process_t> list = WF_Process_t.select("state = 1");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (WF_Process_t wF_Process_t : list) {
            if (bl) {
                stringBuilder.append(",");
            } else {
                bl = true;
            }
            stringBuilder.append(wF_Process_t.jobId.get());
        }
        return stringBuilder.toString();
    }

    private void doWork() throws Exception {
        String string = this.getCurrentJobs();
        Integer n = WorkflowProperties.getInstance().getClient().getClientId();
        String string2 = string.length() > 0 ? String.format("opType = %s AND cloudId = %s AND jobId NOT IN (%s)", WorkflowRegistry.getInstance().getJMOpType(), n, string) : String.format("opType = %s AND cloudId = %s", WorkflowRegistry.getInstance().getJMOpType(), n);
        List<JMAdminJobInfoTable_t> list = JMAdminJobInfoTable_t.select(string2);
        for (JMAdminJobInfoTable_t jMAdminJobInfoTable_t : list) {
            logger.warn("found stale job in job controller [" + jMAdminJobInfoTable_t.jobId.get() + "]");
            WF_Process_t wF_Process_t = WorkflowEngine.getInstance().getJobRecord(jMAdminJobInfoTable_t.jobId.get().intValue(), 2);
            JobManager.completeJob(wF_Process_t);
        }
    }
}

