/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.workflow.EngineProperties;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;

public class CheckClientChange
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CheckClientChange.class);

    @Override
    public void onEngineStart() {
        Integer n = EngineProperties.getInstance().getClientId();
        if (n == null) {
            EngineProperties.getInstance().setClientId(WorkflowProperties.getInstance().getClient().getClientId());
            return;
        }
        if (!n.equals(WorkflowProperties.getInstance().getClient().getClientId())) {
            logger.info("client id has changed from [" + n + "] to [" + WorkflowProperties.getInstance().getClient().getClientId() + "], updating CommServ database");
            try {
                CommServUtils.updateInteractionClientId(n, WorkflowProperties.getInstance().getClient().getClientId());
                EngineProperties.getInstance().setClientId(WorkflowProperties.getInstance().getClient().getClientId());
            }
            catch (Exception exception) {
                logger.error("failed to update client id information in WF_Interaction table", exception);
            }
        }
    }
}

