/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.events.engine;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.DeploymentManager;
import commvault.cte.workflow.EngineProperties;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.db.cs.WF_Definition_t;
import commvault.cte.workflow.db.cs.WF_Deploy_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.schema.SchemaManager;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.WorkflowFlags;
import java.util.ArrayList;
import java.util.List;

public class AutoDeploymentCheck
implements EngineStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(AutoDeploymentCheck.class);

    @Override
    public void onEngineStart() {
        ThreadManager.getInstance().execute(new DeploymentTask());
    }

    private static class DeploymentTask
    implements Runnable {
        private DeploymentTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SchemaManager schemaManager;
            List<WF_Definition_t> list;
            Integer n = EngineProperties.getInstance().getAutoDeployment();
            String string = n == null || n == 0 ? String.format("((flags & %s) = %s) OR ((flags & %s) = %s)", WorkflowFlags.AUTODEPLOY.getEnumValue(), WorkflowFlags.AUTODEPLOY.getEnumValue(), WorkflowFlags.CV_WORKFLOW.getEnumValue(), WorkflowFlags.CV_WORKFLOW.getEnumValue()) : String.format("(flags & %s) = %s", WorkflowFlags.CV_WORKFLOW.getEnumValue(), WorkflowFlags.CV_WORKFLOW.getEnumValue());
            try {
                list = WF_Definition_t.select(string);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to select from WF_Definition table using where clause [" + string + "]", cTEDBException);
                return;
            }
            if (list.size() == 0) {
                return;
            }
            try {
                schemaManager = SchemaManager.newInstance();
            }
            catch (EvFailureException evFailureException) {
                logger.error("failed to auto deploy workflows");
                return;
            }
            UserEntity userEntity = new UserEntity();
            userEntity.setUserId(1);
            try {
                List<WF_Definition_t> list2 = this.deployDefinitions(list, schemaManager, userEntity, false);
                if (list2.size() > 0) {
                    this.deployDefinitions(list2, schemaManager, userEntity, true);
                }
            }
            finally {
                schemaManager.close();
            }
            if (n == null || n == 0) {
                EngineProperties.getInstance().setAutoDeployment(1);
            }
        }

        private List<WF_Definition_t> deployDefinitions(List<WF_Definition_t> list, SchemaManager schemaManager, UserEntity userEntity, boolean bl) {
            ArrayList<WF_Definition_t> arrayList = new ArrayList<WF_Definition_t>();
            for (WF_Definition_t wF_Definition_t : list) {
                boolean bl2;
                try {
                    bl2 = this.isVersionDeployed(wF_Definition_t.WorkflowId.get(), wF_Definition_t.Version.get()) && this.isCSVersionDeployed(wF_Definition_t.WorkflowId.get(), wF_Definition_t.Version.get());
                }
                catch (CTEDBException cTEDBException) {
                    logger.error("error checking deployment information from WF_Deployments", cTEDBException);
                    continue;
                }
                if (!bl2) {
                    DeploymentManager deploymentManager = new DeploymentManager(schemaManager, new DeploymentManager.WFDefinition(wF_Definition_t), userEntity);
                    try {
                        logger.info("auto deploying workflow [%s] with version [%s]", wF_Definition_t.Name.get(), wF_Definition_t.Version.get());
                        DeploymentManager.deploy(deploymentManager, wF_Definition_t, userEntity, schemaManager);
                    }
                    catch (EvFailureException evFailureException) {
                        if (!deploymentManager.missingWorkflowActivity || bl) {
                            logger.error("failed to auto deploy workflow [" + wF_Definition_t.Name.get() + "]");
                            continue;
                        }
                        logger.info("could not deploy workflow [%s] due to missing activty, will retry", wF_Definition_t.Name.get());
                        arrayList.add(wF_Definition_t);
                    }
                    continue;
                }
                logger.trace("internal workflow [%s] with version [%s] is up to date", wF_Definition_t.Name.get(), wF_Definition_t.Version.get());
            }
            return arrayList;
        }

        private boolean isVersionDeployed(int n, int n2) throws CTEDBException {
            WF_Deployments_t wF_Deployments_t = new WF_Deployments_t();
            String string = String.format("WorkflowId = %s AND Version = %s", n, n2);
            return wF_Deployments_t.fill(string);
        }

        private boolean isCSVersionDeployed(int n, int n2) throws CTEDBException {
            WF_Deploy_t wF_Deploy_t = new WF_Deploy_t();
            String string = String.format("WorkflowId = %s AND Version = %s", n, n2);
            return wF_Deploy_t.fill(string);
        }
    }
}

