/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.Evaluator;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ScriptLanguage;
import java.util.List;

public class XPathEvaluator
implements Evaluator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(XPathEvaluator.class);

    @Override
    public boolean canEvaluate(String string) {
        return string.matches("(?i)xpath:\\{[\\S\\s]*}") && ExpressionUtils.getExpressionCount(string) == 1;
    }

    @Override
    public Object eval(String string, EvalContext evalContext) throws EvFailureException {
        List list;
        logger.trace(evalContext.getJobId(), "evaluating xpath expression [%s]", string);
        try {
            list = evalContext.getXPathQuery().select(string);
        }
        catch (Exception exception) {
            logger.error("failed to evaluate expression [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                if (list.get(0) instanceof WorkflowElement) {
                    WorkflowElement workflowElement = (WorkflowElement)list.get(0);
                    if (Boolean.valueOf(workflowElement.getAttributeValue("_list_")).booleanValue()) {
                        return evalContext.getMarshaller().decode(list);
                    }
                    return evalContext.getMarshaller().decode((WorkflowElement)list.get(0));
                }
                return list.get(0);
            }
            if (list.get(0) instanceof WorkflowElement) {
                return evalContext.getMarshaller().decode(list);
            }
            return list;
        }
        return null;
    }

    @Override
    public ScriptLanguage getLanguage() {
        return null;
    }

    @Override
    public String getTag() {
        return "xpath";
    }
}

