/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.common.workflow.ExpressionParser;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.dom.WorkflowAttribute;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class WorkflowEvaluator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowEvaluator.class);
    private EvalContext eval;

    public WorkflowEvaluator(EvalContext evalContext) {
        this.eval = evalContext;
    }

    private boolean isObjectElement(WorkflowElement workflowElement) {
        String string = workflowElement.getAttributeValue("class");
        return string != null && string.equals(Object.class.getName());
    }

    public void processElement(WorkflowElement workflowElement) throws EvFailureException {
        logger.xml(this.eval.getJobId(), "processing expressions in element [%s]", workflowElement.toString());
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            this.processChildElement(workflowElement2);
        }
    }

    public void processChildElement(WorkflowElement workflowElement) throws EvFailureException {
        Object object;
        for (WorkflowAttribute object2 : workflowElement.getAttributes()) {
            if (object2.getText().length() <= 0) continue;
            object = this.parseString(object2.getText());
            object2.setText((String)object);
        }
        if (workflowElement.getChildren().size() > 0) {
            this.processElement(workflowElement);
        } else if (workflowElement.getText().length() > 0) {
            String string = workflowElement.getText();
            if (ExpressionUtils.isObjectExpression(string) && ExpressionUtils.getExpressionCount(string) == 1) {
                logger.xml(this.eval.getJobId(), "element [%s] contains expression [%s]", workflowElement.getName(), string);
                Object object2 = this.eval.evaluate(string);
                if (object2 != null) {
                    object = this.eval.getMarshaller().encode(workflowElement.getName(), object2);
                    WorkflowElement workflowElement2 = workflowElement.getParent();
                    workflowElement2.removeContent(workflowElement);
                    if (object != null) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            WorkflowElement workflowElement3 = (WorkflowElement)iterator.next();
                            WorkflowElement workflowElement4 = workflowElement3.clone();
                            if (workflowElement.getAttributeValue("class") != null && !workflowElement.getAttributeValue("class").equals(Object.class.getName()) && (workflowElement4.getAttributeValue("class") == null || workflowElement4.getAttributeValue("class").equals(Object.class.getName()))) {
                                String string2 = workflowElement.getAttributeValue("class");
                                logger.trace(this.eval.getJobId(), "newly encoded element [%s] has a type of Object, configuring it to the original element class [%s]", workflowElement4.getName(), string2);
                                workflowElement4.setAttribute("class", string2);
                            }
                            workflowElement4.copyAttributesFrom(workflowElement);
                            workflowElement2.addContent(workflowElement4);
                        }
                    } else {
                        logger.debug(this.eval.getJobId(), "expression [%s] returned null, removing child", string);
                    }
                } else {
                    logger.warn(this.eval.getJobId(), "expression [%s] returned NULL", string);
                    workflowElement.setText("");
                    if (workflowElement.getChildren().size() > 0) {
                        this.processElement(workflowElement);
                    }
                }
            } else {
                logger.xml(this.eval.getJobId(), "parsing expressions inside element [%s] text [%s]", workflowElement.getName(), string);
                String string3 = this.parseString(string);
                workflowElement.removeContent();
                workflowElement.setText(string3);
            }
        }
    }

    public WorkflowElement buildXml(Map<String, Object> map) throws EvFailureException {
        WorkflowElement workflowElement = new WorkflowElement("outputs");
        if (map == null) {
            return workflowElement;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            workflowElement.addContent(this.eval.getMarshaller().encode(String.valueOf(entry.getKey()), entry.getValue()));
        }
        return workflowElement;
    }

    public Map<String, Object> getObjectMap(String string, XMLSchema xMLSchema) throws EvFailureException {
        return this.getObjectMap(WorkflowElement.parse(string), xMLSchema, true);
    }

    public Map<String, Object> getObjectMap(WorkflowElement workflowElement, XMLSchema xMLSchema, boolean bl) throws EvFailureException {
        Iterator iterator2;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (workflowElement == null) {
            return hashMap;
        }
        if (xMLSchema != null) {
            for (Object object2 : xMLSchema.getChildren()) {
                iterator2 = workflowElement.getChildren(object2.getName()).iterator();
                if (!iterator2.hasNext()) continue;
                WorkflowElement workflowElement2 = (WorkflowElement)iterator2.next();
                workflowElement2.setAttribute("_list_", String.valueOf(object2.getListType()));
                workflowElement2.setAttribute("class", String.valueOf(object2.getClassName()));
            }
        }
        logger.debug("building input map from xml [%s]", workflowElement);
        if (bl) {
            this.processElement(workflowElement);
        }
        HashSet hashSet = new HashSet();
        for (Iterator iterator2 : workflowElement.getChildren()) {
            hashSet.add(((WorkflowElement)((Object)iterator2)).getName());
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            iterator2 = (String)object2.next();
            hashMap.put((String)((Object)iterator2), this.eval.getMarshaller().decode(workflowElement.getChildren((String)((Object)iterator2))));
        }
        return hashMap;
    }

    public String parseString(String string) throws EvFailureException {
        return this.parseString(string, false);
    }

    public String parseString(String string, boolean bl) throws EvFailureException {
        ExpressionParser expressionParser = new ExpressionParser(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (expressionParser.find()) {
            Object object = this.eval.evaluate(expressionParser.group());
            String string2 = this.toString(object);
            if (bl) {
                string2 = StringEscapeUtils.escapeXml((String)string2);
            }
            expressionParser.appendReplacement(stringBuffer, string2);
        }
        expressionParser.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String toString(Object object) {
        if (object instanceof WorkflowElement) {
            return ((WorkflowElement)object).getText();
        }
        if (object instanceof ClientEntity) {
            return ((ClientEntity)object).getClientName();
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() > 0) {
                if (list.size() == 1) {
                    return this.toString(list.get(0));
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object e : list) {
                    arrayList.add(this.toString(e));
                }
                return this.getStringValue(arrayList);
            }
            return "";
        }
        return this.getStringValue(object);
    }

    protected String getStringValue(Object object) {
        return String.valueOf(object);
    }
}

