/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowImport;
import commvault.cte.workflow.WorkflowLogger;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.DatabaseQuery;
import commvault.cte.workflow.eval.EvalConfig;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.EvalResult;
import commvault.cte.workflow.eval.Evaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.script.WorkflowScriptEngine;
import commvault.cte.workflow.utils.EventUtil;
import commvault.cte.workflow.utils.ImportUtils;
import commvault.cte.workflow.utils.ScriptUtils;
import commvault.msgs.Workflow.ScriptLanguage;

public class NashornEvaluator
implements Evaluator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(NashornEvaluator.class);

    @Override
    public Object eval(String string, EvalContext evalContext) throws EvFailureException {
        Object exception;
        logger.trace(evalContext.getJobId(), "evaluating java script expression [%s]", string);
        final WorkflowScriptEngine workflowScriptEngine = WorkflowScriptEngine.getScriptEngine();
        for (WorkflowImport object22 : evalContext.getWorkflow().getImports()) {
            try {
                exception = this.getClass().getClassLoader().loadClass(object22.getClassName());
                workflowScriptEngine.put(object22.getName(), ((Class)exception).newInstance());
            }
            catch (Exception exception2) {
                logger.error(evalContext.getJobId(), "failed to load class [" + object22.getClassName() + "]", exception2);
                throw new EvFailureException(new EvMessageContainer(exception2.getMessage()));
            }
        }
        try {
            workflowScriptEngine.put("import", new ImportUtils());
        }
        catch (Exception exception3) {
            logger.error(evalContext.getJobId(), "error adding script variable [import]", exception3);
            throw new EvFailureException(new EvMessageContainer(exception3.getMessage()));
        }
        try {
            workflowScriptEngine.put("workflow", evalContext.getWorkflow());
        }
        catch (Exception exception4) {
            logger.error(evalContext.getJobId(), "error adding script variable [workflow]", exception4);
            throw new EvFailureException(new EvMessageContainer(exception4.getMessage()));
        }
        try {
            workflowScriptEngine.put("csdb", new DatabaseQuery(evalContext.getWorkflow().getContext(), WorkflowProperties.getInstance().getCommCellConnection()));
        }
        catch (Exception exception5) {
            logger.error(evalContext.getJobId(), "error adding script variable [csdb]", exception5);
            throw new EvFailureException(new EvMessageContainer(exception5.getMessage()));
        }
        try {
            workflowScriptEngine.put("wfdb", new DatabaseQuery(evalContext.getWorkflow().getContext(), WorkflowProperties.getInstance().getEngineConnection()));
        }
        catch (Exception exception6) {
            logger.error(evalContext.getJobId(), "error adding script variable [wfdb]", exception6);
            throw new EvFailureException(new EvMessageContainer(exception6.getMessage()));
        }
        try {
            workflowScriptEngine.put("logger", WorkflowLogger.getInstance().getCustomLogger(evalContext.getWorkflow()));
        }
        catch (Exception exception7) {
            logger.error(evalContext.getJobId(), "error adding script variable [logger]", exception7);
            throw new EvFailureException(new EvMessageContainer(exception7.getMessage()));
        }
        try {
            workflowScriptEngine.put("event", new EventUtil(evalContext.getWorkflow()));
        }
        catch (Exception exception8) {
            logger.error(evalContext.getJobId(), "error adding script variable [event]", exception8);
            throw new EvFailureException(new EvMessageContainer(exception8.getMessage()));
        }
        try {
            workflowScriptEngine.put("utils", new ScriptUtils(evalContext.getWorkflow()));
        }
        catch (Exception exception9) {
            logger.error(evalContext.getJobId(), "error adding script variable [utils]", exception9);
            throw new EvFailureException(new EvMessageContainer(exception9.getMessage()));
        }
        if (evalContext.getActivity() != null) {
            try {
                logger.trace(evalContext.getJobId(), "adding variable [%s] as object [%s]", evalContext.getWorkflow().getUniqueName(), evalContext.getActivity().getClass());
                workflowScriptEngine.put(evalContext.getWorkflow().getUniqueName(), evalContext.getActivity());
            }
            catch (Exception exception10) {
                logger.error(evalContext.getJobId(), "error adding script variable [" + evalContext.getWorkflow().getUniqueName() + "]", exception10);
                throw new EvFailureException(new EvMessageContainer(exception10.getMessage()));
            }
            try {
                logger.trace(evalContext.getJobId(), "adding variable [%s] as object [%s]", "activity", evalContext.getActivity().getClass());
                workflowScriptEngine.put("activity", evalContext.getActivity());
            }
            catch (Exception exception11) {
                logger.error(evalContext.getJobId(), "error adding script variable [activity]", exception11);
                throw new EvFailureException(new EvMessageContainer(exception11.getMessage()));
            }
        }
        EvalResult evalResult = new EvalResult();
        try {
            workflowScriptEngine.put("eval", evalResult);
        }
        catch (Exception exception12) {
            logger.error(evalContext.getJobId(), "error adding script variable [eval]", exception12);
            throw new EvFailureException(new EvMessageContainer(exception12.getMessage()));
        }
        String string2 = evalContext.parseScript(string, new EvalConfig(){

            @Override
            public void setVariable(String string, Object object) throws Throwable {
                workflowScriptEngine.put(string, object);
            }
        });
        try {
            exception = workflowScriptEngine.eval(string2);
        }
        catch (Exception exception13) {
            logger.error(evalContext.getJobId(), "error executing script [" + string2 + "]", exception13);
            throw new EvFailureException(new EvMessageContainer(exception13.getMessage()));
        }
        if (evalResult.get() != null) {
            return evalResult.get();
        }
        return exception;
    }

    @Override
    public boolean canEvaluate(String string) {
        return string.matches("(?i)js:\\{[\\S\\s]*}:js") || string.matches("(?i)js:\\{[\\S\\s]*}");
    }

    @Override
    public ScriptLanguage getLanguage() {
        return ScriptLanguage.JAVASCRIPT;
    }

    @Override
    public String getTag() {
        return "script";
    }
}

