/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import bsh.Interpreter;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.DatabaseQuery;
import commvault.cte.workflow.eval.EvalConfig;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.EvalResult;
import commvault.cte.workflow.eval.Evaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.EventUtil;
import commvault.cte.workflow.utils.ImportUtils;
import commvault.msgs.Workflow.ScriptLanguage;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.python.util.PythonInterpreter;

public class JythonEvaluator
implements Evaluator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JythonEvaluator.class);

    @Override
    public Object eval(String string, EvalContext evalContext) throws EvFailureException {
        logger.trace(evalContext.getJobId(), "evaluating jython expression [%s]", string);
        final PythonInterpreter pythonInterpreter = new PythonInterpreter();
        EvalResult evalResult = new EvalResult();
        pythonInterpreter.set("eval", (Object)evalResult);
        pythonInterpreter.set("import", (Object)new ImportUtils());
        pythonInterpreter.set("workflow", (Object)evalContext.getWorkflow());
        pythonInterpreter.set("csdb", (Object)new DatabaseQuery(evalContext.getWorkflow().getContext(), WorkflowProperties.getInstance().getCommCellConnection()));
        pythonInterpreter.set("logger", (Object)CTELogger.getLogger(Interpreter.class, evalContext.getJobId()));
        pythonInterpreter.set("event", (Object)new EventUtil(evalContext.getWorkflow()));
        if (evalContext.getActivity() != null) {
            pythonInterpreter.set(evalContext.getWorkflow().getUniqueName(), (Object)evalContext.getActivity());
            pythonInterpreter.set("activity", (Object)evalContext.getActivity());
        }
        final String string2 = evalContext.parseScript(string, new EvalConfig(){

            @Override
            public void setVariable(String string, Object object) throws Throwable {
                pythonInterpreter.set(string, object);
            }
        });
        StringWriter stringWriter = new StringWriter();
        pythonInterpreter.setErr((Writer)stringWriter);
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return pythonInterpreter.eval(string2.toString());
            }
        };
        Subject.doAs(evalContext.getUserContext().getSubject(), privilegedAction);
        if (stringWriter.toString().length() > 0) {
            logger.error(evalContext.getJobId(), "errors occurred during evaluation of python script [" + string2 + "]");
            logger.error(evalContext.getJobId(), stringWriter.toString());
            throw new EvFailureException(new EvMessageContainer(stringWriter.toString()));
        }
        return evalResult.get();
    }

    @Override
    public boolean canEvaluate(String string) {
        return string.matches("(?i)jython:\\{[\\S\\s]*}:jython");
    }

    @Override
    public ScriptLanguage getLanguage() {
        return ScriptLanguage.JYTHON;
    }

    @Override
    public String getTag() {
        return "jython";
    }
}

