/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowImport;
import commvault.cte.workflow.WorkflowLogger;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.DatabaseQuery;
import commvault.cte.workflow.eval.EvalConfig;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.EvalResult;
import commvault.cte.workflow.eval.Evaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.script.WorkflowScriptBeanshell;
import commvault.cte.workflow.script.WorkflowScriptEngine;
import commvault.cte.workflow.utils.EventUtil;
import commvault.cte.workflow.utils.ImportUtils;
import commvault.cte.workflow.utils.ScriptUtils;
import commvault.msgs.Workflow.ScriptLanguage;
import workflow.types.EncryptedString;
import workflow.types.Time;
import workflow.types.XML;
import workflow.types.data.DataSet;
import workflow.types.data.ResultSet;

public class JavaEvaluator
implements Evaluator {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(JavaEvaluator.class);

    @Override
    public boolean canEvaluate(String string) {
        return string.matches("(?i)java:\\{[\\S\\s]*}:java") || string.matches("(?i)java:\\{[\\S\\s]*}");
    }

    @Override
    public Object eval(String string, EvalContext evalContext) throws EvFailureException {
        Object object;
        logger.trace(evalContext.getJobId(), "evaluating java expression [%s]", string);
        final WorkflowScriptEngine workflowScriptEngine = WorkflowRegistry.getInstance().getJavaEngine().length() == 0 ? this.getScriptEngine() : WorkflowScriptEngine.getJavaEngine();
        for (WorkflowImport object22 : evalContext.getWorkflow().getImports()) {
            try {
                logger.trace(evalContext.getJobId(), "loading utility class, name [%s], class [%s]", object22.getName(), object22.getClass());
                object = this.getClass().getClassLoader().loadClass(object22.getClassName());
                workflowScriptEngine.put(object22.getName(), ((Class)object).newInstance());
            }
            catch (Exception exception) {
                logger.error(evalContext.getJobId(), "failed to add java utility class [" + object22.getName() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        try {
            workflowScriptEngine.put("import", new ImportUtils());
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [import]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            workflowScriptEngine.put("workflow", evalContext.getWorkflow());
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [workflow]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            workflowScriptEngine.put("csdb", new DatabaseQuery(evalContext.getWorkflow().getContext(), WorkflowProperties.getInstance().getCommCellConnection()));
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [csdb]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            workflowScriptEngine.put("wfdb", new DatabaseQuery(evalContext.getWorkflow().getContext(), WorkflowProperties.getInstance().getEngineConnection()));
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [csdb]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            workflowScriptEngine.put("logger", WorkflowLogger.getInstance().getCustomLogger(evalContext.getWorkflow()));
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [logger]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            workflowScriptEngine.put("event", new EventUtil(evalContext.getWorkflow()));
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [event]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            workflowScriptEngine.put("utils", new ScriptUtils(evalContext.getWorkflow()));
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [utils]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (evalContext.getActivity() != null) {
            logger.trace(evalContext.getJobId(), "adding java variable [%s] as object [%s]", evalContext.getWorkflow().getUniqueName(), evalContext.getActivity().getClass());
            try {
                workflowScriptEngine.put(evalContext.getWorkflow().getUniqueName(), evalContext.getActivity());
            }
            catch (Exception exception) {
                logger.error(evalContext.getJobId(), "error adding java activity variable [" + evalContext.getWorkflow().getUniqueName() + "] as activity [" + evalContext.getActivity().getClass() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            logger.trace(evalContext.getJobId(), "adding java variable [%s] as object [%s]", "activity", evalContext.getActivity().getClass());
            try {
                workflowScriptEngine.put("activity", evalContext.getActivity());
            }
            catch (Exception exception) {
                logger.error(evalContext.getJobId(), "error adding java activity variable [activity] as activity [" + evalContext.getActivity().getClass() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (WorkflowRegistry.getInstance().isAddImports()) {
            workflowScriptEngine.addImport(DatabaseQuery.class);
            workflowScriptEngine.addImport(DataSet.class);
            workflowScriptEngine.addImport(ResultSet.class);
            workflowScriptEngine.addImport(XML.class);
            workflowScriptEngine.addImport(EncryptedString.class);
            workflowScriptEngine.addImport(Time.class);
        }
        EvalResult evalResult = new EvalResult();
        try {
            workflowScriptEngine.put("eval", evalResult);
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error adding java variable [eval]", exception);
        }
        String string2 = evalContext.parseScript(string, new EvalConfig(){

            @Override
            public void setVariable(String string, Object object) throws Throwable {
                workflowScriptEngine.put(string, object);
            }
        });
        try {
            object = workflowScriptEngine.eval(string2);
        }
        catch (Exception exception) {
            logger.error(evalContext.getJobId(), "error executing script [" + string2 + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (evalResult.get() != null) {
            return evalResult.get();
        }
        return object;
    }

    protected WorkflowScriptEngine getScriptEngine() {
        return new WorkflowScriptBeanshell();
    }

    @Override
    public ScriptLanguage getLanguage() {
        return ScriptLanguage.JAVA;
    }

    @Override
    public String getTag() {
        return "java";
    }
}

