/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.common.workflow.ExpressionParser;
import commvault.cte.workflow.logger.CTELogger;
import org.apache.commons.lang.StringUtils;

public class ExpressionUtils {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ExpressionUtils.class);

    public static boolean isObjectExpression(String string) {
        return string.matches("(?i)xpath:\\{[\\S\\s]*}") || string.matches("(?i)java:\\{[\\S\\s]*}:java") || string.matches("(?i)java:\\{[\\S\\s]*}") || string.matches("(?i)jython:\\{[\\S\\s]*}:jython") || string.matches("(?i)groovy:\\{[\\S\\s]*}:groovy") || string.matches("(?i)\\{\\{[\\S\\s]*(}}|})");
    }

    public static String getExpression(String string) {
        if (string.startsWith("{{")) {
            String string2 = string.endsWith("}}") ? string.substring(2, string.length() - 2) : string.substring(2, string.length() - 1);
            String string3 = StringUtils.replace((String)string2, (String)".", (String)"/").replaceAll("(?i)\\%2E", ".");
            String string4 = "/workflow/" + string3;
            logger.debug("Converted DotN expression [" + string2 + "] to xpath expressoin [" + string4 + "]");
            return string4;
        }
        return string.substring(string.indexOf("{") + 1, string.lastIndexOf("}"));
    }

    public static boolean parseBoolean(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isAssignableFrom(Boolean.class)) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(object.toString());
    }

    public static int getExpressionCount(String string) {
        ExpressionParser expressionParser = new ExpressionParser(string);
        int n = 0;
        while (expressionParser.find()) {
            ++n;
        }
        return n;
    }
}

