/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.eval;

import commvault.cte.common.workflow.ExpressionParser;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.eval.CommServQueryEvaluator;
import commvault.cte.workflow.eval.DotNotationEvalutor;
import commvault.cte.workflow.eval.EvalConfig;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.Evaluator;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.eval.GroovyEvaluator;
import commvault.cte.workflow.eval.JavaEvaluator;
import commvault.cte.workflow.eval.JythonEvaluator;
import commvault.cte.workflow.eval.NashornEvaluator;
import commvault.cte.workflow.eval.XPathEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.Marshaller;
import commvault.msgs.Workflow.ScriptDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import workflow.types.XPathQuery;

public class EvalManager
implements EvalContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EvalManager.class);
    private WorkflowContext workflow;
    private Activity activity;
    private XPathQuery query;
    private List<Evaluator> evaluators = new ArrayList<Evaluator>();
    private JavaEvaluator defaultEvaluator;

    public EvalManager(WorkflowContext workflowContext) throws EvFailureException {
        this(workflowContext, null);
    }

    public EvalManager(WorkflowContext workflowContext, Activity activity) {
        this(workflowContext, activity, (XPathQuery)(workflowContext instanceof XPathQuery ? (XPathQuery)workflowContext : workflowContext.getParent()));
    }

    public EvalManager(WorkflowContext workflowContext, Activity activity, XPathQuery xPathQuery) {
        this.workflow = workflowContext;
        this.activity = activity;
        this.query = xPathQuery;
        this.evaluators.add(new XPathEvaluator());
        this.evaluators.add(new JavaEvaluator());
        this.evaluators.add(new JythonEvaluator());
        this.evaluators.add(new NashornEvaluator());
        this.evaluators.add(new CommServQueryEvaluator());
        this.evaluators.add(new GroovyEvaluator());
        this.evaluators.add(new DotNotationEvalutor());
        this.defaultEvaluator = new GroovyEvaluator();
        this.evaluators.add(this.defaultEvaluator);
    }

    @Override
    public String getName() {
        return this.workflow.getName();
    }

    @Override
    public long getJobId() {
        return this.workflow.getJobId();
    }

    @Override
    public int getCommCellId() {
        return this.workflow.getCommCellId();
    }

    @Override
    public Object evaluate(ScriptDefinition scriptDefinition) throws EvFailureException {
        if (scriptDefinition.getScript().trim().length() == 0) {
            return null;
        }
        if (scriptDefinition.getLanguage(false) != null) {
            for (Evaluator evaluator : this.evaluators) {
                if (!scriptDefinition.getLanguage().equals((Object)evaluator.getLanguage())) continue;
                return evaluator.eval(scriptDefinition.getScript(), this);
            }
        }
        return this.defaultEvaluator.eval(scriptDefinition.getScript(), this);
    }

    @Override
    public Object evaluate(String string) throws EvFailureException {
        if (string.trim().length() == 0) {
            return null;
        }
        for (Evaluator evaluator : this.evaluators) {
            if (!evaluator.canEvaluate(string)) continue;
            return evaluator.eval(ExpressionUtils.getExpression(string), this);
        }
        logger.warn(this.getJobId(), "could not find an evaluator for expression [%s], using default java evaluator", string);
        return this.defaultEvaluator.eval(ExpressionUtils.getExpression(string), this);
    }

    @Override
    public XPathQuery getXPathQuery() {
        return this.query;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public Marshaller getMarshaller() {
        return this.workflow.getMarshaller();
    }

    @Override
    public WorkflowContext getWorkflow() {
        return this.workflow;
    }

    @Override
    public SecurityContext getUserContext() {
        return this.workflow.getContext();
    }

    @Override
    public String parseScript(String string, EvalConfig evalConfig) throws EvFailureException {
        ExpressionParser expressionParser = new ExpressionParser(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (expressionParser.find()) {
            String string2 = expressionParser.group();
            logger.trace(this.getJobId(), "found expression in script [%s], attempt to evaluate", string2);
            Object object = this.evaluate(string2);
            String string3 = "v_" + UUID.randomUUID().toString().replaceAll("-", "_");
            expressionParser.appendReplacement(stringBuffer, string3);
            if (object != null) {
                logger.debug(this.getJobId(), "replacing expression %s (%s) with value [%s], type [%s]", string2, string3, object, object.getClass().getName());
            } else {
                logger.debug(this.getJobId(), "replacing expression %s (%s) with null value", string2, string3);
            }
            try {
                evalConfig.setVariable(string3, object);
            }
            catch (Throwable throwable) {
                if (object != null) {
                    logger.error(this.getJobId(), "error setting expression [" + string2 + "] with value [" + string3 + "], type [" + object.getClass().getName() + "]", throwable);
                } else {
                    logger.error(this.getJobId(), "error setting expression [" + string2 + "] with null value", throwable);
                }
                throw new EvFailureException(new EvMessageContainer(throwable.getMessage()));
            }
        }
        expressionParser.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

