/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.dom;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.dom.DOMUtil;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.EvalManager;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.events.WorkflowStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.msgs.App.XMLSchema;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.json.JSONObject;
import org.json.XML;

public class InitializeExecution
implements WorkflowStartHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(InitializeExecution.class);

    public static void initialize(ProcessContext processContext) {
        new InitializeExecution().execute(processContext, ProcessStatus.PENDING);
    }

    @Override
    public void onWorkflowStart(WorkflowProcess workflowProcess) {
        this.execute(workflowProcess, ProcessStatus.FAILED);
    }

    private void execute(ProcessContext processContext, ProcessStatus processStatus) {
        Object object;
        Object object2;
        Element element;
        Element element2;
        Element element3;
        Element element4;
        Element element5;
        Element element6;
        Element element7;
        Element element8 = processContext.getWorkflowExecution().getInputElement();
        if (element8 != null) {
            processContext.getWorkflowExecution().getExecutionRoot().removeContent((Content)element8);
        }
        if ((element7 = processContext.getWorkflowExecution().getVariableElement()) != null) {
            processContext.getWorkflowExecution().getExecutionRoot().removeContent((Content)element7);
        }
        if ((element6 = processContext.getWorkflowExecution().getConfigurationElement()) != null) {
            processContext.getWorkflowExecution().getExecutionRoot().removeContent((Content)element6);
        }
        if ((element5 = processContext.getWorkflowExecution().getOutputElement()) != null) {
            processContext.getWorkflowExecution().getExecutionRoot().removeContent((Content)element5);
        }
        try {
            element4 = JDOMUtil.parseXml(processContext.getDefinitionInputs());
        }
        catch (JDOMException jDOMException) {
            logger.error(processContext.getJobId(), "failed to parse definition inputs [" + processContext.getDefinitionInputs() + "]", jDOMException);
            processContext.setFailureReason(new EvMessageContainer(jDOMException.getMessage()));
            processContext.setStatus(processStatus);
            return;
        }
        if (element4 != null) {
            logger.debug(processContext.getJobId(), "copying definition inputs into execution process [%s]", processContext.getDefinitionInputs());
            element4.setName("inputs");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)element4.clone());
        } else {
            logger.debug(processContext.getJobId(), "no defined inputs to copy into execution process");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)new Element("inputs"));
        }
        try {
            element3 = JDOMUtil.parseXml(processContext.getDefinitionVariables());
        }
        catch (JDOMException jDOMException) {
            logger.error(processContext.getJobId(), "failed to parse definition variables [" + processContext.getDefinitionVariables() + "]", jDOMException);
            processContext.setFailureReason(new EvMessageContainer(jDOMException.getMessage()));
            processContext.setStatus(processStatus);
            return;
        }
        if (element3 != null) {
            logger.debug(processContext.getJobId(), "copying definition variables into execution process [%s]", processContext.getDefinitionVariables());
            element3.setName("variables");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)element3.clone());
        } else {
            logger.debug(processContext.getJobId(), "no defined variables to copy into execution process");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)new Element("variables"));
        }
        try {
            element2 = JDOMUtil.parseXml(processContext.getDefinitionConfiguration());
        }
        catch (JDOMException jDOMException) {
            logger.error(processContext.getJobId(), "failed to parse definition configuration [" + processContext.getDefinitionConfiguration() + "]", jDOMException);
            processContext.setFailureReason(new EvMessageContainer(jDOMException.getMessage()));
            processContext.setStatus(processStatus);
            return;
        }
        if (element2 != null) {
            logger.debug(processContext.getJobId(), "copying definition configuration into execution process [%s]", processContext.getDefinitionConfiguration());
            element2.setName("configuration");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)element2.clone());
        } else {
            logger.debug(processContext.getJobId(), "no defined configuration to copy into execution process");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)new Element("configuration"));
        }
        try {
            element = JDOMUtil.parseXml(processContext.getOutputXml());
        }
        catch (JDOMException jDOMException) {
            logger.error(processContext.getJobId(), "failed to parse definition outputs [" + processContext.getOutputXml() + "]", jDOMException);
            processContext.setFailureReason(new EvMessageContainer(jDOMException.getMessage()));
            processContext.setStatus(processStatus);
            return;
        }
        if (element != null) {
            logger.debug(processContext.getJobId(), "copying definition outputs into execution process [%s]", processContext.getOutputXml());
            element.setName("outputs");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)element.clone());
        } else {
            logger.debug(processContext.getJobId(), "no defined outputs to copy into execution process");
            processContext.getWorkflowExecution().getExecutionRoot().addContent((Content)new Element("outputs"));
        }
        if (processContext.getJobInputs() != null) {
            if (processContext.getJobInputs().startsWith("{")) {
                object2 = new JSONObject(processContext.getJobInputs());
                object = XML.toString((Object)object2, (String)"inputs");
            } else {
                object = processContext.getJobInputs();
            }
            try {
                object2 = JDOMUtil.parseXml((String)object);
            }
            catch (JDOMException jDOMException) {
                logger.error(processContext.getJobId(), "failed to parse job inputs [" + (String)object + "]");
                processContext.setFailureReason(new EvMessageContainer(jDOMException.getMessage()));
                processContext.setStatus(processStatus);
                return;
            }
            processContext.getWorkflowExecution().mergeInputs((Element)object2);
            logger.debug(processContext.getJobId(), "merge results of job inputs [%s]", JDOMUtil.serialize(processContext.getWorkflowExecution().getInputElement()));
        } else {
            logger.debug(processContext.getJobId(), "no job inputs supplied to merge into execution process");
        }
        if (processContext.getConfigurationXml() != null) {
            try {
                object = JDOMUtil.parseXml(processContext.getConfigurationXml());
            }
            catch (JDOMException jDOMException) {
                logger.error(processContext.getJobId(), "failed to parse workflow configuration [" + processContext.getConfigurationXml() + "]");
                processContext.setFailureReason(new EvMessageContainer(jDOMException.getMessage()));
                processContext.setStatus(processStatus);
                return;
            }
            processContext.getWorkflowExecution().mergeConfiguration((Element)object);
            logger.debug(processContext.getJobId(), "merge results of workflow configuration [%s]", JDOMUtil.serialize(processContext.getWorkflowExecution().getConfigurationElement()));
        } else {
            logger.debug(processContext.getJobId(), "no user defined configuration to merge into execution process");
        }
        SchemaUtils.updateAttributes((Element)processContext.getWorkflowExecution().getInputElement(), (XMLSchema)processContext.getInputSchema());
        SchemaUtils.updateAttributes((Element)processContext.getWorkflowExecution().getVariableElement(), (XMLSchema)processContext.getVariableSchema());
        SchemaUtils.updateAttributes((Element)processContext.getWorkflowExecution().getOutputElement(), (XMLSchema)processContext.getOutputSchema());
        SchemaUtils.updateAttributes((Element)processContext.getWorkflowExecution().getConfigurationElement(), (XMLSchema)processContext.getConfigurationSchema());
        try {
            object = new EvalManager(processContext);
        }
        catch (EvFailureException evFailureException) {
            logger.error(processContext.getJobId(), "failed to load expression parser");
            processContext.setFailureReason(evFailureException.getMessageContainer());
            processContext.setStatus(processStatus);
            return;
        }
        try {
            DOMUtil.checkInputs(processContext.getWorkflowExecution().getInputs(), (EvalManager)object);
        }
        catch (EvFailureException evFailureException) {
            logger.error(processContext.getJobId(), "failed to check workflow inputs");
            processContext.setFailureReason(evFailureException.getMessageContainer());
            processContext.setStatus(processStatus);
            return;
        }
        if (processContext instanceof WorkflowProcess) {
            this.updateVariables((WorkflowProcess)processContext);
        }
        processContext.getWorkflowExecution().update();
        object2 = new WorkflowEvaluator((EvalContext)object);
        try {
            logger.xml(processContext.getJobId(), "workflow inputs pre-parsing [%s]", JDOMUtil.serialize(processContext.getWorkflowExecution().getInputElement()));
            ((WorkflowEvaluator)object2).processElement(new WorkflowElement(processContext.getWorkflowExecution().getInputElement()));
            logger.xml(processContext.getJobId(), "workflow inputs post parsing [%s]", JDOMUtil.serialize(processContext.getWorkflowExecution().getInputElement()));
        }
        catch (EvFailureException evFailureException) {
            logger.error(processContext.getJobId(), "failed to process workflow inputs expressions");
            processContext.setFailureReason(evFailureException.getMessageContainer());
            processContext.setStatus(processStatus);
            return;
        }
        try {
            logger.xml(processContext.getJobId(), "workflow variables pre-parsing [%s]", JDOMUtil.serialize(processContext.getWorkflowExecution().getVariableElement()));
            ((WorkflowEvaluator)object2).processElement(new WorkflowElement(processContext.getWorkflowExecution().getVariableElement()));
            logger.xml(processContext.getJobId(), "workflow variables post parsing [%s]", JDOMUtil.serialize(processContext.getWorkflowExecution().getVariableElement()));
        }
        catch (EvFailureException evFailureException) {
            logger.error(processContext.getJobId(), "failed to process workflow variable expressions");
            processContext.setFailureReason(evFailureException.getMessageContainer());
            processContext.setStatus(processStatus);
            return;
        }
    }

    private void updateVariables(final WorkflowProcess workflowProcess) {
        UpdateHandler updateHandler = new UpdateHandler(){

            @Override
            public Object getVariable(String string) throws EvFailureException {
                return workflowProcess.getInput(string);
            }

            @Override
            public void setVariable(String string, Object object) throws EvFailureException {
                workflowProcess.setInput(string, object);
            }
        };
        this.updateChildren(workflowProcess.getWorkflowExecution().getInputElement().getChildren(), workflowProcess, updateHandler);
        UpdateHandler updateHandler2 = new UpdateHandler(){

            @Override
            public Object getVariable(String string) throws EvFailureException {
                return workflowProcess.getVariable(string);
            }

            @Override
            public void setVariable(String string, Object object) throws EvFailureException {
                workflowProcess.setVariable(string, object);
            }
        };
        this.updateChildren(workflowProcess.getWorkflowExecution().getVariableElement().getChildren(), workflowProcess, updateHandler2);
    }

    private void updateChildren(List<Element> list, WorkflowProcess workflowProcess, UpdateHandler updateHandler) {
        if (list == null) {
            return;
        }
        for (Element element : list.toArray(new Element[0])) {
            Class<?> clazz;
            String string = element.getName();
            String string2 = element.getAttributeValue("class");
            if (string2 == null || string2.length() == 0) continue;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (!CTEProcessingModel.class.isAssignableFrom(clazz)) continue;
            try {
                updateHandler.setVariable(string, updateHandler.getVariable(string));
            }
            catch (EvFailureException evFailureException) {
                // empty catch block
            }
        }
    }

    private static interface UpdateHandler {
        public Object getVariable(String var1) throws EvFailureException;

        public void setVariable(String var1, Object var2) throws EvFailureException;
    }
}

