/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.db.QueryContext;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.CvEntities.CommCellEntity;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workflow.types.EncryptedString;
import workflow.types.SQLParameter;
import workflow.types.data.DataSet;

public class GenericQuery
implements QueryContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(GenericQuery.class);
    private CommCellEntity commCell;
    private String url;
    private String user;
    private String password;

    public GenericQuery(CommCellEntity commCellEntity, String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.password = string3;
        this.commCell = commCellEntity;
    }

    public GenericQuery(String string, String string2, EncryptedString encryptedString) {
        this.url = string;
        this.user = string2;
        this.password = encryptedString.getPlainText();
    }

    @Override
    public List<DataSet> executeBatch(String string, List<SQLParameter> list) throws CTEDBException {
        ArrayList<DataSet> arrayList;
        Connection connection;
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            if (list != null) {
                try {
                    WorkflowUtils.setSQLParameters(preparedStatement, list);
                }
                catch (Exception exception) {
                    throw new CTEDBException("failed to set sql parameters", (Throwable)exception);
                }
            }
            if (!preparedStatement.execute()) {
                List<DataSet> list2 = null;
                return list2;
            }
            ArrayList<DataSet> arrayList2 = new ArrayList<DataSet>();
            arrayList2.add(new DataSet(preparedStatement.getResultSet(), this.commCell));
            while (preparedStatement.getMoreResults()) {
                arrayList2.add(new DataSet(preparedStatement.getResultSet(), this.commCell));
            }
            arrayList = arrayList2;
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList;
    }

    @Override
    public List<DataSet> executeBatch(String string) throws CTEDBException {
        ArrayList<DataSet> arrayList;
        Connection connection;
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            if (!statement.execute(string)) {
                List<DataSet> list = null;
                return list;
            }
            ArrayList<DataSet> arrayList2 = new ArrayList<DataSet>();
            arrayList2.add(new DataSet(statement.getResultSet(), this.commCell));
            while (statement.getMoreResults()) {
                arrayList2.add(new DataSet(statement.getResultSet(), this.commCell));
            }
            arrayList = arrayList2;
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList;
    }

    @Override
    public DataSet execute(String string) throws CTEDBException {
        Connection connection;
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            if (statement.execute(string)) {
                DataSet dataSet = new DataSet(statement.getResultSet(), this.commCell);
                return dataSet;
            }
            DataSet dataSet = null;
            return dataSet;
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public int executeUpdate(String string) throws CTEDBException {
        Connection connection;
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            int n = statement.executeUpdate(string);
            return n;
        }
        catch (SQLException sQLException) {
            throw new CTEDBException(sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

