/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.db;

import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.QueryContext;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workflow.types.SQLParameter;
import workflow.types.data.DataSet;

public class DatabaseQuery
implements QueryContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DatabaseQuery.class);
    private CTEDBConnection connection;
    private SecurityContext context;

    public DatabaseQuery(SecurityContext securityContext, CTEDBConnection cTEDBConnection) {
        this.connection = cTEDBConnection;
        this.context = securityContext;
    }

    @Override
    public List<DataSet> executeBatch(String string, List<SQLParameter> list) throws CTEDBException {
        if (!this.context.isCommCellAdmin()) {
            throw new CTEDBException("impersonated user [" + this.context.getUser().getUserName() + "] does not have required capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "]");
        }
        try (CTEDBReservation cTEDBReservation = this.connection.createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            if (list != null) {
                try {
                    WorkflowUtils.setSQLParameters(preparedStatement, list);
                }
                catch (Exception exception) {
                    throw new CTEDBException("failed to set sql parameters", (Throwable)exception);
                }
            }
            if (!preparedStatement.execute()) {
                List<DataSet> list2 = null;
                return list2;
            }
            ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
            arrayList.add(new DataSet(preparedStatement.getResultSet(), WorkflowProperties.getInstance().getCommCell()));
            while (preparedStatement.getMoreResults()) {
                arrayList.add(new DataSet(preparedStatement.getResultSet(), WorkflowProperties.getInstance().getCommCell()));
            }
            ArrayList<DataSet> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public List<DataSet> executeBatch(String string) throws CTEDBException {
        if (!this.context.isCommCellAdmin()) {
            throw new CTEDBException("impersonated user [" + this.context.getUser().getUserName() + "] does not have required capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "]");
        }
        try (CTEDBReservation cTEDBReservation = this.connection.createReservation();){
            Statement statement = cTEDBReservation.createStatement();
            if (!statement.execute(string)) {
                List<DataSet> list = null;
                return list;
            }
            ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
            arrayList.add(new DataSet(statement.getResultSet(), WorkflowProperties.getInstance().getCommCell()));
            while (statement.getMoreResults()) {
                arrayList.add(new DataSet(statement.getResultSet(), WorkflowProperties.getInstance().getCommCell()));
            }
            ArrayList<DataSet> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public DataSet execute(String string) throws CTEDBException {
        if (!this.context.isCommCellAdmin()) {
            throw new CTEDBException("impersonated user [" + this.context.getUser().getUserName() + "] does not have required capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "]");
        }
        try (CTEDBReservation cTEDBReservation = this.connection.createReservation();){
            Statement statement = cTEDBReservation.createStatement();
            if (statement.execute(string)) {
                DataSet dataSet = new DataSet(statement.getResultSet(), WorkflowProperties.getInstance().getCommCell());
                return dataSet;
            }
            DataSet dataSet = null;
            return dataSet;
        }
    }

    @Override
    public int executeUpdate(String string) throws CTEDBException {
        if (!this.context.isCommCellAdmin()) {
            throw new CTEDBException("impersonated user [" + this.context.getUser().getUserName() + "] does not have required capability [" + Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName() + "]");
        }
        try (CTEDBReservation cTEDBReservation = this.connection.createReservation();){
            Statement statement = cTEDBReservation.createStatement();
            int n = statement.executeUpdate(string);
            return n;
        }
    }
}

