/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.Capability;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EvSecurityFailure;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.SessionUtil;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.logger.CTELogger;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;

public class WorkflowSecurityManager
extends SecurityManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowSecurityManager.class);
    private static final List<Class> restrictedMembers = new ArrayList<Class>();

    @Override
    public void checkAccept(String string, int n) {
    }

    @Override
    public void checkAccess(Thread thread) {
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
    }

    @Override
    public void checkConnect(String string, int n, Object object) {
    }

    @Override
    public void checkConnect(String string, int n) {
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkDelete(String string) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string2 = String.format("[Delete] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string2, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string3 = String.format("user [%s] cannot perform operation [Delete] on object [%s] due to missing capability [%s]", securityContext.getName(), string, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string3, evMessageContainer);
            }
        }
    }

    @Override
    public void checkExec(String string) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string2 = String.format("[Exec] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string2, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string3 = String.format("user [%s] cannot perform operation [Exec] on object [%s] due to missing capability [%s]", securityContext.getName(), string, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string3, evMessageContainer);
            }
        }
    }

    @Override
    public void checkExit(int n) {
    }

    @Override
    public void checkLink(String string) {
    }

    @Override
    public void checkListen(int n) {
    }

    @Override
    public void checkMulticast(InetAddress inetAddress) {
    }

    @Override
    public void checkPackageAccess(String string) {
    }

    @Override
    public void checkPackageDefinition(String string) {
    }

    @Override
    public void checkPermission(Permission permission, Object object) {
    }

    @Override
    public void checkPermission(Permission permission) {
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkPropertiesAccess() {
    }

    @Override
    public void checkPropertyAccess(String string) {
    }

    @Override
    public void checkRead(FileDescriptor fileDescriptor) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string = String.format("[Read] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string = String.format("user [%s] cannot perform operation [Read] on object [%s] due to missing capability [%s]", securityContext.getName(), fileDescriptor, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string, evMessageContainer);
            }
        }
    }

    @Override
    public void checkRead(String string, Object object) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string2 = String.format("[Read] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string2, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string3 = String.format("user [%s] cannot perform operation [Read] on object [%s] due to missing capability [%s]", securityContext.getName(), string, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string3, evMessageContainer);
            }
        }
    }

    @Override
    public void checkRead(String string) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string2 = String.format("[Read] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string2, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string3 = String.format("user [%s] cannot perform operation [Read] on object [%s] due to missing capability [%s]", securityContext.getName(), string, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string3, evMessageContainer);
            }
        }
    }

    @Override
    public void checkSecurityAccess(String string) {
    }

    @Override
    public void checkSetFactory() {
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string = String.format("[Write] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string = String.format("user [%s] cannot perform operation [Write] on object [%s] due to missing capability [%s]", securityContext.getName(), fileDescriptor, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string, evMessageContainer);
            }
        }
    }

    @Override
    public void checkWrite(String string) {
        SecurityContext securityContext = this.getPrinciple();
        if (securityContext != null) {
            if (!securityContext.isLoggedIn() || securityContext.getCommCell().getCommCellId() != WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
                String string2 = String.format("[Write] user [%s] is not logged into commcell [%s]", securityContext.getName(), WorkflowProperties.getInstance().getCommCell().getCommCellName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string2, evMessageContainer);
            }
            if (!securityContext.isEngineAdmin() && !securityContext.isClientAdmin()) {
                String string3 = String.format("user [%s] cannot perform operation [Write] on object [%s] due to missing capability [%s]", securityContext.getName(), string, Capability.AGENT_MANAGEMENT.getDisplayName());
                EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", securityContext.getName(), Capability.AGENT_MANAGEMENT.getDisplayName(), WorkflowProperties.getInstance().getClient().getClientName());
                throw new EvSecurityFailure(string3, evMessageContainer);
            }
        }
    }

    private SecurityContext getPrinciple() {
        AccessControlContext accessControlContext = (AccessControlContext)this.getSecurityContext();
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject != null && subject.getPrincipals().size() > 0) {
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof SecurityContext)) continue;
                return (SecurityContext)principal;
            }
        }
        return null;
    }

    static {
        restrictedMembers.add(SessionUtil.class);
    }
}

