/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.workflow.EngineContext;
import commvault.cte.workflow.ImpersonateUtil;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.DBConn;
import commvault.cte.workflow.db.WorkflowConnection;
import commvault.cte.workflow.db.cs.APP_ClientProp_t;
import commvault.cte.workflow.db.cs.simInstalledPackages_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.msgs.CvEntities.ClientEntity;
import commvault.msgs.CvEntities.CommCellEntity;
import java.io.File;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class WorkflowProperties
implements EngineContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowProperties.class);
    public static final String WEBSERVICE_CLASS_NAME = "CVWebService.svc";
    private static WorkflowProperties instance;
    public static final String COMMSERV_DB = "CommServ";
    public static final String ENGINE_DB = "WFEngine";
    private CTEDBConnection engineConnection;
    private CTEDBConnection commCellConnection;
    private ClientEntity client;
    private CommCellEntity commCell;
    private ClientEntity commCellClient;
    private String commServHost;
    private String commServClient;
    private WebServiceParameters defaultWebService = null;
    private WebServiceParameters webServiceParameters = null;
    private int version = 11;

    public static WorkflowProperties getInstance() {
        return instance;
    }

    protected static void setInstance(WorkflowProperties workflowProperties) {
        instance = workflowProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkflowProperties() {
        String string = null;
        try {
            string = WorkflowRegistry.getInstance().getCommServDatabaseName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = COMMSERV_DB;
        }
        String string2 = null;
        try {
            string2 = WorkflowRegistry.getInstance().getWorkflowEngineDatabaseName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string2 == null || string2.length() == 0) {
            string2 = ENGINE_DB;
        }
        this.commCellConnection = new WorkflowConnection(DBConn.COMMSERV, string);
        this.engineConnection = new WorkflowConnection(DBConn.WFENGINE, string2);
        File file = new File(WorkflowRegistry.getInstance().getInstallFolder(), "workflowEngine.jar");
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            this.version = Integer.parseInt(manifest.getMainAttributes().getValue("Specification-Version").trim());
        }
        catch (Throwable throwable) {
            logger.error("failed to retrieve release version from manifest file from binary [" + file.getAbsolutePath() + "]", throwable);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void initialize() throws Exception {
        this.commCellConnection.checkAlive();
        this.engineConnection.checkAlive();
        List<String> list = WorkflowRegistry.getInstance().getInstalledClients();
        if (list.size() == 0) {
            throw new Exception("failed to retrieve installed clients via the registry");
        }
        this.client = list.size() == 1 ? CommServUtils.getClientFromGUID(list.get(0)) : this.lookupEngine(list);
        logger.debug("workflow engine initialized with client name [%s], guid [%s]", this.client.getClientName(), this.client.getClientGUID());
        this.client.setCommCellName(WorkflowRegistry.getInstance().getCommCellName());
        this.client.setCommCellId(2);
        this.commCell = new CommCellEntity();
        this.commCell.setCommCellId(2);
        this.commCell.setCommCellName(WorkflowRegistry.getInstance().getCommCellName());
        this.commServHost = ImpersonateUtil.getInstance().findCommServerHostName();
        this.commServClient = ImpersonateUtil.getInstance().findCommServerClientName();
        this.commCellClient = CommServUtils.getClientEntity(this.commServClient);
    }

    private ClientEntity lookupEngine(List<String> list) throws Exception {
        List<ClientEntity> list2 = CommServUtils.getInstalledEngines();
        for (String string : list) {
            for (ClientEntity clientEntity : list2) {
                if (!clientEntity.getClientGUID().equals(string)) continue;
                return clientEntity;
            }
        }
        throw new Exception("failed to determine workflow engine from registered clients " + list.toString());
    }

    private ClientEntity getDefaultWebServer() throws Exception {
        String string = "simPackageID = 252 And clientId in (Select componentNameId From APP_ClientProp Where attrname = 'DM2WebService Web Site Port')";
        List<simInstalledPackages_t> list = simInstalledPackages_t.select(string);
        if (list.size() == 0) {
            return null;
        }
        int n = 0;
        for (simInstalledPackages_t simInstalledPackages_t2 : list) {
            if (simInstalledPackages_t2.ClientId.get().intValue() == this.client.getClientId()) {
                return this.client;
            }
            if (simInstalledPackages_t2.ClientId.get().intValue() == this.commCellClient.getClientId()) {
                if (n != 0) continue;
                n = simInstalledPackages_t2.ClientId.get();
                continue;
            }
            n = simInstalledPackages_t2.ClientId.get();
        }
        if (n == this.commCellClient.getClientId()) {
            return this.commCellClient;
        }
        return CommServUtils.getClientEntity(n);
    }

    public ClientEntity getCommCellClient() {
        return this.commCellClient;
    }

    @Override
    public ClientEntity getClient() {
        return this.client;
    }

    @Override
    public CommCellEntity getCommCell() {
        return this.commCell;
    }

    public String getJobResultsDir() {
        return WorkflowRegistry.getInstance().getJobResultsDirectory(this.getClient().getClientName());
    }

    @Override
    public String getCommServHost() {
        return this.commServHost;
    }

    @Override
    public String getCommServClient() {
        return this.commServClient;
    }

    @Override
    public CTEDBConnection getEngineConnection() {
        return this.engineConnection;
    }

    @Override
    public CTEDBConnection getCommCellConnection() {
        return this.commCellConnection;
    }

    @Override
    public CTEDBConnInfo getConnInfo() {
        return WorkflowRegistry.getInstance().getCommServDatabaseConnection();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private String getConfiguredWebServiceUrl() {
        String string = WorkflowRegistry.getInstance().getDefaultWebServer();
        if (string != null && string.length() > 0) {
            if (string.endsWith("/")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    private String getEdgeDriveWebServiceUrl() {
        String string = WorkflowRegistry.getInstance().getEdgeDriveWebServer();
        if (string != null && string.length() > 0) {
            if (string.endsWith("/")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    public String getWebConsoleUrl() throws Exception {
        String string = WorkflowRegistry.getInstance().getDefaultWebconsole();
        if (string == null || string.length() == 0) {
            string = CommServUtils.getWebConsoleUrl();
        } else if (string.equalsIgnoreCase("APP_ClientProp")) {
            string = CommServUtils.getWebConsoleUrlFromClientProp();
        }
        return string;
    }

    public WebServiceParameters getEdgeDriveWebService() {
        String string = this.getEdgeDriveWebServiceUrl();
        if (string != null) {
            return new WebServiceParameters(string, "");
        }
        return null;
    }

    public WebServiceParameters getDefaultWebServiceParameters() throws Exception {
        if (this.defaultWebService == null) {
            ClientEntity clientEntity = this.getDefaultWebServer();
            if (clientEntity != null) {
                APP_ClientProp_t aPP_ClientProp_t = new APP_ClientProp_t(this.getCommCellConnection());
                String string = String.format("attrname in ('DM2WebService Web Site Port', 'DM2WebService Search Web Alias') AND componentNameId=%s", clientEntity.getClientId());
                List list = aPP_ClientProp_t.executeSelect(string);
                String string2 = null;
                String string3 = "SearchSvc";
                for (APP_ClientProp_t aPP_ClientProp_t2 : list) {
                    if (aPP_ClientProp_t2.attrName.get().equalsIgnoreCase("DM2WebService Search Web Alias")) {
                        string3 = aPP_ClientProp_t2.attrVal.get();
                    }
                    if (!aPP_ClientProp_t2.attrName.get().equalsIgnoreCase("DM2WebService Web Site Port")) continue;
                    string2 = aPP_ClientProp_t2.attrVal.get();
                }
                if (string2 == null) {
                    throw new Exception("failed to get [DM2WebService Web Site Port] setting from APP_ClientProp table for client id [" + clientEntity.getClientId() + "]");
                }
                this.defaultWebService = new WebServiceParameters("http://" + clientEntity.getHostName() + ":" + string2, "/" + string3 + "/" + WEBSERVICE_CLASS_NAME, clientEntity.getClientId());
            } else {
                logger.warn("no web server found on CommCell");
            }
        }
        return this.defaultWebService;
    }

    private WebServiceParameters getWebServiceParameters() throws Exception {
        String string = this.getConfiguredWebServiceUrl();
        if (string != null) {
            return new WebServiceParameters(string, "");
        }
        if (this.webServiceParameters == null) {
            ClientEntity clientEntity = this.getDefaultWebServer();
            if (clientEntity != null) {
                String string2 = String.format("attrname in ('DM2WebService Web Site Port', 'DM2WebService Search Web Alias') AND componentNameId=%s", clientEntity.getClientId());
                List<APP_ClientProp_t> list = APP_ClientProp_t.select(string2);
                String string3 = null;
                String string4 = "SearchSvc";
                for (APP_ClientProp_t aPP_ClientProp_t : list) {
                    if (aPP_ClientProp_t.attrName.get().equalsIgnoreCase("DM2WebService Search Web Alias")) {
                        string4 = aPP_ClientProp_t.attrVal.get();
                    }
                    if (!aPP_ClientProp_t.attrName.get().equalsIgnoreCase("DM2WebService Web Site Port")) continue;
                    string3 = aPP_ClientProp_t.attrVal.get();
                }
                if (string3 == null) {
                    throw new Exception("failed to get [DM2WebService Web Site Port] setting from APP_ClientProp table for client id [" + clientEntity.getClientId() + "]");
                }
                this.webServiceParameters = new WebServiceParameters("http://" + clientEntity.getHostName() + ":" + string3, "/" + string4 + "/" + WEBSERVICE_CLASS_NAME, clientEntity.getClientId());
            } else {
                logger.debug("no web server found on CommCell");
            }
        }
        return this.webServiceParameters;
    }

    @Override
    public WebServiceParameters getDefaultWebService() {
        try {
            return this.getWebServiceParameters();
        }
        catch (Exception exception) {
            logger.error("failed to retrieve web service parameters from commcell [" + this.getCommCell().getCommCellName() + "]", exception);
            return null;
        }
    }

    public static class WebServiceParameters {
        private String webUrl;
        private String basePath;
        private int clientId;

        public WebServiceParameters(String string, String string2) {
            this(string, string2, 0);
        }

        public WebServiceParameters(String string, String string2, int n) {
            this.webUrl = string;
            this.basePath = string2;
            this.clientId = n;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public int getClientId() {
            return this.clientId;
        }
    }
}

