/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.CVInitiatedFrom;
import commvault.cte.workflow.CommCellSettings;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.JobManagerContext;
import commvault.cte.workflow.JobSettings;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ScheduleView;
import commvault.cte.workflow.SessionContext;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.WorkflowImport;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.ApplicationDatabase;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.OnDemandDatabase;
import commvault.cte.workflow.db.cs.TM_SubTaskXMLOptions_t;
import commvault.cte.workflow.db.engine.GetCompletionPercentage_p;
import commvault.cte.workflow.db.engine.GetCompletionPercentage_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.dom.WorkflowExecution;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.Marshaller;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.DeploymentFlags;
import commvault.msgs.Workflow.OutputFormat;
import commvault.msgs.Workflow.ProcessFlags;
import commvault.msgs.Workflow.SchemaDefinition;
import commvault.msgs.Workflow.ScriptDefinition;
import commvault.msgs.Workflow.StartWorkflow;
import commvault.msgs.Workflow.StepFlags;
import commvault.msgs.Workflow.WorkflowFlags;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class WorkflowProcess
implements ProcessContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowProcess.class);
    private final Marshaller marshaller;
    private WorkflowExecution workflowExecution;
    private SessionContext context;
    private final DataAccessLayer database;
    private final WF_Process_t processRow;
    private final WF_Deployments_t deployment;
    private String configurationXml;
    private int globalFlags = 0;
    private int resumeInterval = 0;
    private List<WorkflowImport> imports = null;
    private ScriptDefinition onStart;
    private ScriptDefinition onComplete;
    private final UserEntity executor;
    private UserEntity creator = null;
    private final Set<EvFailureReason> failures = Collections.synchronizedSet(new HashSet());
    private EvFailureReason lastFailure;
    private final Object lock = new Object();
    private JobManagerContext jobManager;
    private JobSettings settings = new CommCellSettings();
    private ScheduleView scheduleView;
    private SchemaDefinition schemaDefinition = null;
    private boolean running = true;
    private StartWorkflow startWorklowRequest;
    private boolean saveExecution = false;
    private boolean debug;
    private StringBuilder failureReport = new StringBuilder();
    private Map<String, Object> cacheMap = Collections.synchronizedMap(new HashMap());
    private List<String> debugLog = new ArrayList<String>();
    private String instanceId = UUID.randomUUID().toString();
    private boolean autoCloseSessions = true;
    private ConcurrentHashMap<Integer, ProcessContext> childWorkflows = new ConcurrentHashMap();
    private boolean switchToJob = false;
    private Boolean startWhenActivityIsLow;
    private String callerIP = "";
    private boolean autoEnableLogging;
    private boolean manualPercentComplete = false;

    public WorkflowProcess(DataAccessLayer dataAccessLayer, WF_Deployments_t wF_Deployments_t, WF_Process_t wF_Process_t, UserEntity userEntity, Integer n) {
        logger.trace("intializing workflow process");
        UserEntity userEntity2 = new UserEntity();
        userEntity2.setUserId(-1);
        userEntity2.setUserName("Unknown");
        userEntity2.set_type_(EntityType.USER_ENTITY);
        this.creator = new UserModel(userEntity2);
        this.database = dataAccessLayer;
        this.deployment = wF_Deployments_t;
        this.processRow = wF_Process_t;
        this.executor = userEntity;
        boolean bl = this.manualPercentComplete = (wF_Deployments_t.flags.get() & DeploymentFlags.MANUAL_PERCENT_COMPLETE.getEnumValue()) > 0;
        if (!this.processRow.logFile.isNull() && this.processRow.logFile.get().length() > 0) {
            try {
                logger.setLogFile(this.processRow.jobId.get(), this.processRow.logFile.get());
            }
            catch (Throwable throwable) {
                logger.resetLogFile(this.processRow.jobId.get());
                logger.error("failed to initialize logger for file [" + this.processRow.logFile.get() + "]", throwable);
            }
        }
        if (n != null) {
            this.globalFlags = n;
        }
        if (!wF_Process_t.xmlJobInfo.isNull() && wF_Process_t.xmlJobInfo.get().length() > 0) {
            try {
                StartWorkflow startWorkflow = (StartWorkflow)XMLDecoder.decode((String)wF_Process_t.xmlJobInfo.get(), (Object)new StartWorkflow());
                this.callerIP = startWorkflow.getCallerIP();
            }
            catch (Exception exception) {
                logger.error("failed to decode Start Workflow request", exception);
            }
        }
        logger.trace("intializing xml stream");
        this.marshaller = new XMLStream();
    }

    protected void initialize() throws EvFailureException {
        try {
            this.startWorklowRequest = (StartWorkflow)XMLDecoder.decode((String)this.processRow.xmlJobInfo.get());
        }
        catch (Exception exception) {
            logger.error(this.getJobId(), "failed to decode Workflow::StartWorkflow request", exception);
        }
        try {
            logger.trace("loading creator user id [%s]", this.deployment.Creator.get());
            this.creator = UserModel.load(this.deployment.Creator.get());
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.getJobId(), "failed to load creator user from id [" + this.deployment.Creator.get() + "]");
            throw evFailureException;
        }
        if (!this.deployment.SchemaDefinition.isNull()) {
            try {
                this.schemaDefinition = (SchemaDefinition)WorkflowUtils.decodeMessage(this.deployment.SchemaDefinition.get(), (Object)new SchemaDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "failed to decode Workflow::SchemaDefinition from xml [" + this.deployment.SchemaDefinition.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        } else {
            logger.warn(this.getJobId(), "no schema definition present for workflow [%s]", this.getName());
            this.schemaDefinition = new SchemaDefinition();
        }
        try {
            logger.trace("retrieving imports from workflow definition");
            this.imports = WorkflowImport.convert(this.database.getImports(this.deployment.DeploymentId.get()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving imports", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (!this.deployment.OnStart.isNull() && this.deployment.OnStart.get().length() > 0) {
            try {
                logger.trace("decoding workflow onStart script");
                this.onStart = (ScriptDefinition)XMLDecoder.decode((String)this.deployment.OnStart.get(), (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "error decoding workflow onStart [" + this.deployment.OnStart.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (!this.deployment.OnComplete.isNull() && this.deployment.OnComplete.get().length() > 0) {
            try {
                logger.trace("decoding workflow onComplete script");
                this.onComplete = (ScriptDefinition)XMLDecoder.decode((String)this.deployment.OnComplete.get(), (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "error decoding workflow onComplete [" + this.deployment.OnComplete.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        try {
            this.scheduleView = CommServUtils.getScheduleView(this.getSubTaskId());
        }
        catch (Exception exception) {
            logger.error(this.getJobId(), "failed to retrieve schedule information for subtask id [" + this.getSubTaskId() + "]", exception);
        }
        try {
            this.configurationXml = CommServUtils.getConfigurationSettings(this.getWorkflowId());
        }
        catch (Exception exception) {
            logger.error(this.getJobId(), "failed to retrieve configuration settings from APP_ComponentProp table for workflow id [" + this.getWorkflowId() + "]");
        }
        logger.trace("loading session context");
        this.context = SessionContext.getInstance(this);
        logger.trace("loading execution document");
        this.workflowExecution = WorkflowExecution.createInstance(this);
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    @Override
    public void clearFailures() {
        this.failures.clear();
        this.getJobManager().updatePendingReason();
    }

    public void clearFailureReport() {
        this.failureReport = new StringBuilder();
    }

    @Override
    public void addFailedActivity(ActivityContext activityContext) {
        if (this.failureReport.length() > 0) {
            this.failureReport.append(',');
        }
        this.failureReport.append(activityContext.getUniqueName()).append('(').append(activityContext.getThreadId()).append(')');
    }

    public String getFailureReport() {
        return this.failureReport.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof WorkflowProcess) {
            return this.getJobId() == ((WorkflowProcess)object).getJobId() && this.getCommCellId() == ((WorkflowProcess)object).getCommCellId();
        }
        return false;
    }

    @Override
    public int getCommCellId() {
        return this.processRow.commCellId.get();
    }

    @Override
    public void setCompletionPercentage(int n) {
        this.processRow.completed.set(Integer.valueOf(n));
    }

    @Override
    public int getCompletionPercentage() {
        if (this.manualPercentComplete) {
            if (this.processRow.completed.isNull()) {
                return 0;
            }
            return this.processRow.completed.get();
        }
        if (!this.isApiWorkflow()) {
            try {
                GetCompletionPercentage_p getCompletionPercentage_p = new GetCompletionPercentage_p();
                getCompletionPercentage_p.i_jobId.set(Long.valueOf(this.getJobId()));
                getCompletionPercentage_p.i_commCellId.set(Integer.valueOf(this.getCommCellId()));
                GetCompletionPercentage_t getCompletionPercentage_t = getCompletionPercentage_p.executeQuery();
                if (getCompletionPercentage_t.percentComplete.isNull()) {
                    return 0;
                }
                int n = (int)(getCompletionPercentage_t.percentComplete.get() * 100.0);
                if (n > 100) {
                    return 100;
                }
                return n;
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.getJobId(), "error retrieving completion percentage", cTEDBException);
                return 0;
            }
        }
        return 0;
    }

    @Override
    public SessionContext getContext() {
        return this.context;
    }

    @Override
    public String getCreator() {
        return this.getCreatorModel().getUserName();
    }

    @Override
    public int getCreatorId() {
        return this.getCreatorModel().getUserId();
    }

    public UserEntity getCreatorModel() {
        return this.creator;
    }

    @Override
    public String getCurrentUserToken() {
        return this.context.getCurrentUserToken();
    }

    @Override
    public Integer getDeploymentId() {
        return this.processRow.DeploymentId.get();
    }

    @Override
    public String getDescription() {
        if (this.deployment.Description.isNull()) {
            return "";
        }
        return this.deployment.Description.get();
    }

    @Override
    public ExecutionState getExecutionState() {
        return ExecutionState.fromInt(this.processRow.State.get());
    }

    @Override
    public String getExecutionXml() {
        return this.processRow.Execution.get();
    }

    @Override
    public EvFailureReason getLastFailure() {
        return this.lastFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailureReason() {
        Set<EvFailureReason> set = this.failures;
        synchronized (set) {
            return WorkflowUtils.buildFailureReason(this.failures);
        }
    }

    @Override
    public Set<EvFailureReason> getFailures() {
        return this.failures;
    }

    @Override
    public List<WorkflowImport> getImports() {
        return this.imports;
    }

    @Override
    public CVInitiatedFrom getInitFrom() {
        return CVInitiatedFrom.fromInitType(this.processRow.initFrom.get());
    }

    public Object selectSingleNode(String string) throws Exception {
        return this.getWorkflowExecution().selectSingleNode(string);
    }

    public List select(String string) throws Exception {
        return this.getWorkflowExecution().select(string);
    }

    @Override
    public Object getInput(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/inputs/" + string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/inputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getInput(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getInput(string);
        }
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/inputs/" + string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/inputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public XMLSchema getInputSchema() {
        return this.schemaDefinition.getInputs();
    }

    @Override
    public XMLSchema getVariableSchema() {
        return this.schemaDefinition.getVariables();
    }

    @Override
    public XMLSchema getConfigurationSchema() {
        return this.schemaDefinition.getConfig();
    }

    @Override
    public long getJobId() {
        return this.processRow.jobId.get();
    }

    @Override
    public String getProcessId() {
        return this.processRow.processId.get();
    }

    @Override
    public String getConfigurationXml() {
        return this.configurationXml;
    }

    @Override
    public String getName() {
        if (this.deployment.WorkflowName.isNull() || this.deployment.WorkflowName.get().length() == 0) {
            return "New Workflow";
        }
        return this.deployment.WorkflowName.get();
    }

    @Override
    public Object getObject(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.workflowExecution.select(string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getObject(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getObject(string);
        }
        try {
            return this.getMarshaller().decode(this.workflowExecution.select(string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public ScriptDefinition getOnComplete() {
        return this.onComplete;
    }

    @Override
    public ScriptDefinition getOnStart() {
        return this.onStart;
    }

    @Override
    public ProcessContext getParent() {
        return this;
    }

    @Override
    public Integer getProcessStepId() {
        return null;
    }

    @Override
    public Date getStartTime() {
        return new Date((long)this.processRow.StartTime.get().intValue() * 1000L);
    }

    @Override
    public Integer getStartTimeUnix() {
        return this.processRow.StartTime.get();
    }

    @Override
    public Date getEndTime() {
        if (this.processRow.EndTime.isNull()) {
            return null;
        }
        return new Date((long)this.processRow.EndTime.get().intValue() * 1000L);
    }

    @Override
    public ProcessStatus getStatus() {
        return ProcessStatus.fromInt((int)this.processRow.Status.get());
    }

    @Override
    public int getSubTaskId() {
        return this.processRow.subTaskId.get();
    }

    @Override
    public int getTaskId() {
        return this.processRow.taskId.get();
    }

    @Override
    public String getUniqueName() {
        return null;
    }

    @Override
    public String getFriendlyName() {
        return this.getName();
    }

    @Override
    public String getExecutor() {
        return this.getExecutorModel().getUserName();
    }

    @Override
    public int getExecutorId() {
        return this.getExecutorModel().getUserId();
    }

    public UserEntity getExecutorModel() {
        return this.executor;
    }

    @Override
    public int getLocaleId() {
        return this.processRow.localeId.get();
    }

    @Override
    public Object getVariable(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/variables/" + string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/variables/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getVariable(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getVariable(string);
        }
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/variables/" + string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/variables/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getLocalVariable(String string) throws EvFailureException {
        return this.getVariable(string);
    }

    @Override
    public Object getLocalVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.getVariable(string, clazz);
    }

    @Override
    public void setLocalVariable(String string, Object object) throws EvFailureException {
        this.setVariable(string, object);
    }

    @Override
    public Object getParentVariable(String string) throws EvFailureException {
        return this.getVariable(string);
    }

    @Override
    public Object getParentVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.getVariable(string, clazz);
    }

    @Override
    public Object getConfiguration(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/configuration/" + string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/configuration/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getConfiguration(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getConfiguration(string);
        }
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/configuration/" + string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/configuration/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getOutput(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/outputs/" + string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/outputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getOutput(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getOutput(string);
        }
        try {
            return this.getMarshaller().decode(this.workflowExecution.select("/workflow/outputs/" + string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/outputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public int getVersion() {
        return this.deployment.Version.get();
    }

    @Override
    public int getWorkflowId() {
        return this.deployment.WorkflowId.get();
    }

    public String getXmlJobInfo() {
        return this.processRow.xmlJobInfo.get();
    }

    @Override
    public String impersonateCommCell(String string) throws EvFailureException {
        return this.context.impersonateCommCell(string);
    }

    @Override
    public String impersonateCreator() throws EvFailureException {
        return this.context.impersonateCreator();
    }

    @Override
    public String impersonateLogin(String string, String string2, String string3) throws EvFailureException {
        return this.context.impersonateLogin(string, string2, string3);
    }

    @Override
    public String impersonateLogin(String string, String string2) throws EvFailureException {
        return this.context.impersonateLogin(string, string2);
    }

    @Override
    public String impersonateExecutor() throws EvFailureException {
        return this.context.impersonateExecutor();
    }

    @Override
    public void logoutImpersonatedUser() {
        this.context.logoutImpersonatedUser();
    }

    @Override
    public void removeFailure(EvFailureReason evFailureReason) {
        this.failures.remove(evFailureReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFailures(Set<EvFailureReason> set) {
        Set<EvFailureReason> set2 = set;
        synchronized (set2) {
            for (EvFailureReason evFailureReason : set) {
                this.failures.remove(evFailureReason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.getWorkflowExecution() != null) {
                    this.getWorkflowExecution().update();
                    try {
                        this.processRow.Execution.set(this.getWorkflowExecution().serialize());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.getStatus() == ProcessStatus.PENDING) {
                    this.processRow.pendingTime.set(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
                } else if (!this.processRow.pendingTime.isNull()) {
                    this.processRow.pendingTime.setNull();
                }
                if (this.getStatus().isJobComplete()) {
                    this.processRow.EndTime.set(Integer.valueOf(DateUtilities.getNow()));
                }
                this.processRow.Modified.set(Integer.valueOf(DateUtilities.getNow()));
                this.processRow.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.getJobId(), "error saving workflow [" + this.getName() + "]", cTEDBException);
            }
        }
    }

    public void setCompleted() {
        this.processRow.EndTime.set(Integer.valueOf(DateUtilities.getNow()));
        this.setExecutionState(ExecutionState.CLEANUP);
    }

    @Override
    public void setExecutionState(ExecutionState executionState) {
        this.processRow.State.set(Integer.valueOf(executionState.toInt()));
    }

    @Override
    public void setFailed(String string) {
        this.setFailureReason(new EvMessageContainer(string));
        this.setStatus(ProcessStatus.FAILED);
    }

    @Override
    public void setSwitchToJob() {
        if (this.isApiWorkflow()) {
            this.switchToJob = true;
            this.setStatus(ProcessStatus.SUSPEND_PENDING);
        } else {
            logger.info("workflow is not running as an API");
        }
    }

    @Override
    public void suspend(String string) {
        this.setFailureReason(new EvMessageContainer(string));
        this.setStatus(ProcessStatus.SUSPEND_PENDING);
    }

    @Override
    public boolean isGlobalLock() {
        return this.hasFlag(ProcessFlags.GLOBAL_LOCK);
    }

    private boolean hasFlag(ProcessFlags processFlags) {
        if (this.processRow.flags.isNull()) {
            return false;
        }
        return (this.processRow.flags.get() & processFlags.getEnumValue()) == processFlags.getEnumValue();
    }

    private void setFlag(ProcessFlags processFlags, boolean bl) {
        int n = 0;
        if (!this.processRow.flags.isNull()) {
            n = this.processRow.flags.get();
        }
        n = bl ? (n |= processFlags.getEnumValue()) : (n &= ~processFlags.getEnumValue());
        this.processRow.flags.set(Integer.valueOf(n));
    }

    @Override
    public void setCompletedWithErrors(boolean bl) {
        this.setFlag(ProcessFlags.ERRORS, bl);
    }

    @Override
    public boolean isCompletedWithErrors() {
        return this.hasFlag(ProcessFlags.ERRORS);
    }

    public void setFailureReason(EvFailureException evFailureException) {
        this.setFailureReason(evFailureException.getMessageContainer());
    }

    @Override
    public void setFailureReason(EvFailureReason evFailureReason) {
        if (evFailureReason != null) {
            this.failures.add(evFailureReason);
            this.lastFailure = evFailureReason;
        }
    }

    @Override
    public void setFailureReason(EvMessageContainer evMessageContainer) {
        EvFailureReason evFailureReason = new EvFailureReason(this, evMessageContainer);
        this.setFailureReason(evFailureReason);
    }

    @Override
    public void setInput(String string, Object object) throws EvFailureException {
        this.workflowExecution.setInput(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(ProcessStatus processStatus) {
        Object object = this.lock;
        synchronized (object) {
            if (processStatus == ProcessStatus.FAILED || processStatus == ProcessStatus.PENDING) {
                logger.warn(this.getJobId(), "failing workflow job [%s]", this.getName());
            } else {
                logger.trace(this.getJobId(), "updating workflow job [%s] with status [%s]", this.getJobId(), processStatus.toString());
            }
            this.processRow.Status.set(Integer.valueOf(processStatus.toInt()));
        }
    }

    @Override
    public void setVariable(String string, Object object) throws EvFailureException {
        this.workflowExecution.setVariable(string, object);
    }

    @Override
    public void setOutput(String string, Object object) throws EvFailureException {
        this.workflowExecution.setOutput(string, object);
    }

    @Override
    public String getJobInputs() {
        return this.processRow.Inputs.get();
    }

    @Override
    public String getOutputs() {
        return this.processRow.outputs.get();
    }

    @Override
    public void setOutputs(String string) {
        this.processRow.outputs.set(string);
    }

    @Override
    public XMLSchema getOutputSchema() {
        return this.schemaDefinition.getOutputs();
    }

    @Override
    public String getOutputXml() {
        return this.deployment.Outputs.get();
    }

    @Override
    public String getJobDescription() {
        if (this.processRow.jobDescription.isNull()) {
            return "";
        }
        return this.processRow.jobDescription.get();
    }

    @Override
    public void setJobDescription(String string) {
        this.processRow.jobDescription.set(string);
    }

    @Override
    public String getDefinitionInputs() {
        return this.deployment.Inputs.get();
    }

    @Override
    public String getDefinitionVariables() {
        return this.deployment.Variables.get();
    }

    @Override
    public String getDefinitionConfiguration() {
        return this.deployment.Configuration.get();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getWorkflowName() {
        return this.getName();
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public WF_Steps_t getStartStep() throws EvFailureException {
        WF_Steps_t wF_Steps_t;
        try {
            wF_Steps_t = this.getDataAccess().getStartStep(this.getDeploymentId(), null);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving workflow start activity", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Steps_t == null) {
            logger.error(this.getJobId(), "could not find workflow start for workflow [" + this.getName() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_START", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        wF_Steps_t.flags.set(Integer.valueOf(wF_Steps_t.flags.get() | StepFlags.BREAKPOINT.getEnumValue()));
        return wF_Steps_t;
    }

    @Override
    public List<WF_ProcessSteps_t> getExecutingSteps() throws EvFailureException {
        try {
            return this.getDataAccess().getProcessSteps(this.getJobId(), null, ExecutionState.RUNNING);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving uncompleted activities for workflow [" + this.getName() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    @Override
    public List<WF_Steps_t> getEventSteps(String string) throws EvFailureException {
        try {
            return this.getDataAccess().getEventSteps(this.getDeploymentId(), string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving onComplete activities", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public String getCommCell() {
        return WorkflowRegistry.getInstance().getCommCellName();
    }

    protected void registerJobManager(JobManagerContext jobManagerContext) {
        this.jobManager = jobManagerContext;
    }

    @Override
    public JobManagerContext getJobManager() {
        return this.jobManager;
    }

    @Override
    public void setAttemptCreation(int n) {
        this.setFlag(ProcessFlags.ATTEMPTS_DISABLED, false);
        this.setFlag(ProcessFlags.ATTEMPTS_ENABLED, false);
        if (n == 1) {
            this.setFlag(ProcessFlags.ATTEMPTS_ENABLED, true);
        } else if (n == 0) {
            this.setFlag(ProcessFlags.ATTEMPTS_DISABLED, true);
        }
    }

    public boolean isForceWriteAttempts() {
        return this.hasFlag(ProcessFlags.ATTEMPTS_ENABLED);
    }

    public boolean isForceDisableAttempts() {
        return this.hasFlag(ProcessFlags.ATTEMPTS_DISABLED);
    }

    @Override
    public Integer getSuperProcessId() {
        return null;
    }

    public boolean isDisabled() {
        return (this.globalFlags & WorkflowFlags.DISABLED.getEnumValue()) == WorkflowFlags.DISABLED.getEnumValue();
    }

    public void dispose() {
        this.context = null;
        this.workflowExecution = null;
        this.jobManager = null;
    }

    @Override
    public JobSettings getJobSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRunning(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (!bl) {
                logger.info(this.getJobId(), "shutting down workflow [%s], job id [%s]", this.getName(), this.getJobId());
            } else {
                logger.debug(this.getJobId(), "setting workflow [%s] to running status", this.getName());
            }
            this.running = bl;
        }
    }

    @Override
    public boolean isRunning() {
        return this.running && WorkflowEngine.getInstance().isRunning();
    }

    @Override
    public int getAutoResumeInterval() {
        return this.resumeInterval;
    }

    @Override
    public void setAutoResumeInterval(int n) {
        this.resumeInterval = n;
    }

    @Override
    public void interrupt() {
        logger.warn(this.getJobId(), "illegal call to interrupt running workflow process");
    }

    @Override
    public boolean isLoggingDisabled() {
        return this.hasFlag(ProcessFlags.LOGGING_DISABLED);
    }

    @Override
    public boolean isAutoEnableLogging() {
        return this.autoEnableLogging;
    }

    @Override
    public void setLoggingDisabled(boolean bl, boolean bl2) {
        this.autoEnableLogging = bl2;
        this.setFlag(ProcessFlags.LOGGING_DISABLED, bl);
        this.setSaveExecution(true);
        if (bl) {
            logger.setJobDisabled(this.getJobId());
        } else {
            logger.setJobEnabled(this.getJobId());
        }
    }

    @Override
    public void setLoggingDisabled(boolean bl) {
        this.setLoggingDisabled(bl, true);
    }

    @Override
    public boolean isLogRedirected() {
        return logger.isRedirected(this.getJobId());
    }

    @Override
    public void setLogFile(String string) throws Exception {
        this.processRow.logFile.set(string);
        this.setSaveExecution(true);
        logger.setLogFile(this.getJobId(), string);
    }

    @Override
    public void resetLogFile() {
        this.processRow.logFile.set("");
        this.setSaveExecution(true);
        logger.resetLogFile(this.getJobId());
    }

    @Override
    public ScheduleView getScheduleView() {
        return this.scheduleView;
    }

    @Override
    public ProcessContext getRoot() {
        return this;
    }

    @Override
    public Integer getCalculatedMaxRestarts() {
        return null;
    }

    @Override
    public String sendMessage(String string) throws Exception {
        return WorkflowUtils.executeXml(string, this.context, this.getJobId());
    }

    @Override
    public OutputFormat getOutputFormat() {
        if (this.startWorklowRequest == null || this.startWorklowRequest.getOutputFormat() == null) {
            return OutputFormat.XML;
        }
        return this.startWorklowRequest.getOutputFormat();
    }

    @Override
    public List<WorkflowElement> getProcessXml() {
        return new ArrayList<WorkflowElement>();
    }

    @Override
    public void setSaveExecution(boolean bl) {
        this.saveExecution = bl;
    }

    @Override
    public boolean isSaveExecution() {
        return this.saveExecution;
    }

    @Override
    public String getProcessName() {
        return null;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public DataAccessLayer getDataAccess() {
        return this.database;
    }

    @Override
    public boolean isOnDemand() {
        return this.getDataAccess() instanceof OnDemandDatabase;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public ProcessStatus getWorkflowStatus() {
        return this.getStatus();
    }

    @Override
    public void addCache(String string, Object object) {
        this.cacheMap.put(string, object);
    }

    @Override
    public Object getCache(String string) {
        return this.cacheMap.get(string);
    }

    @Override
    public int getCacheSize() {
        return this.cacheMap.size();
    }

    @Override
    public String getMaskedStep() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDebugMessage(String string) {
        List<String> list = this.debugLog;
        synchronized (list) {
            while (this.debugLog.size() >= 50) {
                this.debugLog.remove(0);
            }
            this.debugLog.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDebugLog() {
        List<String> list = this.debugLog;
        synchronized (list) {
            return this.debugLog;
        }
    }

    @Override
    public String getSessionId() {
        return this.processRow.sessionId.get();
    }

    @Override
    public void setSessionId(String string) {
        this.processRow.sessionId.set(string);
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public boolean isApiWorkflow() {
        return this.database instanceof ApplicationDatabase;
    }

    @Override
    public boolean isTransitionCancelled() {
        return false;
    }

    @Override
    public void setTransitionCancelled(boolean bl) {
    }

    public boolean isAutoCloseSessions() {
        return this.autoCloseSessions;
    }

    public void setAutoCloseSessions(boolean bl) {
        this.autoCloseSessions = bl;
    }

    @Override
    public ProcessContext getParentWorkflow() {
        return this;
    }

    @Override
    public long getWorkflowJobId() {
        return 0L;
    }

    @Override
    public void registerChild(ProcessContext processContext) {
        this.childWorkflows.put(processContext.getProcessStepId(), processContext);
    }

    @Override
    public void removeChild(ProcessContext processContext) {
        this.childWorkflows.remove(processContext.getProcessStepId());
    }

    public ProcessContext getChildProcess(int n) {
        return this.childWorkflows.get(n);
    }

    public ProcessContext[] getChildProcesses() {
        return this.childWorkflows.values().toArray(new ProcessContext[0]);
    }

    public boolean isSwitchToJob() {
        return this.switchToJob;
    }

    public WF_Process_t getProcessRow() {
        return this.processRow;
    }

    @Override
    public String getCallerIP() {
        return this.callerIP;
    }

    public boolean startWhenActivityIsLow() {
        if (this.getSubTaskId() > 0) {
            if (this.startWhenActivityIsLow == null) {
                String string = this.getJobOptions(this.getJobId(), this.getSubTaskId());
                try {
                    String string2;
                    WorkflowElement workflowElement = WorkflowElement.parse(string);
                    if (workflowElement != null && (string2 = workflowElement.getText("/TMMsg_JobOption/commonOpts/startUpOpts/@startWhenActivityIsLow")) != null && (string2.equals("1") || string2.equalsIgnoreCase("true"))) {
                        this.startWhenActivityIsLow = true;
                        return this.startWhenActivityIsLow;
                    }
                }
                catch (EvFailureException evFailureException) {
                    // empty catch block
                }
                this.startWhenActivityIsLow = false;
            }
            return this.startWhenActivityIsLow;
        }
        return false;
    }

    private String getJobOptions(long l, int n) {
        TM_SubTaskXMLOptions_t tM_SubTaskXMLOptions_t = new TM_SubTaskXMLOptions_t();
        String string = "subTaskId = " + n;
        try {
            if (!tM_SubTaskXMLOptions_t.fill(string)) {
                logger.debug("could not find TM_SubTaskXMLOptions_t for job [%s] using where clause [%s]", l, string);
                return null;
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve subTask xml options for job [" + l + "], subTaskId [" + n + "]", cTEDBException);
            return null;
        }
        return tM_SubTaskXMLOptions_t.xmlValue.getString();
    }

    @Override
    public boolean isTimedOut() {
        return false;
    }

    @Override
    public boolean isSessionActive() {
        return SessionManager.getInstance().contains(this.getJobId());
    }
}

