/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.logger.CTELogger;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorkflowMultiThread
extends WorkflowThread {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowMultiThread.class);
    private ConcurrentLinkedQueue<ThreadData> tasks = new ConcurrentLinkedQueue();
    private volatile ThreadData currentTask = null;

    public WorkflowMultiThread(Runnable runnable, String string, WorkflowContext workflowContext) {
        super(runnable, string, workflowContext);
        this.currentTask = new ThreadData(runnable, workflowContext);
        this.add(this.currentTask);
    }

    public void add(Runnable runnable, String string, WorkflowContext workflowContext) {
        this.setName(string);
        if (this.getState() == Thread.State.TERMINATED) {
            throw new Error("thread is terminated");
        }
        this.add(new ThreadData(runnable, workflowContext));
    }

    private void add(ThreadData threadData) {
        this.tasks.add(threadData);
    }

    @Override
    public long getJobId() {
        return this.currentTask.context.getJobId();
    }

    @Override
    public Integer getProcessStepId() {
        return this.currentTask.context.getProcessStepId();
    }

    @Override
    public Integer getParentStepId() {
        return this.currentTask.context.getParent().getProcessStepId();
    }

    @Override
    public WorkflowContext getWorkflowContext() {
        return this.currentTask.context;
    }

    @Override
    public synchronized void start() {
        if (this.getState() == Thread.State.NEW) {
            super.start();
        }
    }

    @Override
    public void run() {
        do {
            this.currentTask = this.tasks.poll();
            if (this.currentTask == null) break;
            try {
                this.currentTask.runnable.run();
            }
            catch (Throwable throwable) {
                logger.error("uncaught exception executing workflow thread", throwable);
            }
        } while (!this.isInterrupted());
    }

    private static class ThreadData {
        private Runnable runnable;
        private WorkflowContext context;

        public ThreadData(Runnable runnable, WorkflowContext workflowContext) {
            this.runnable = runnable;
            this.context = workflowContext;
        }
    }
}

